/*
 * Decompiled with CFR 0.152.
 */
package com.sqlparser.statement.insert;

import com.sqlparser.expression.Expression;
import com.sqlparser.schema.Column;
import com.sqlparser.statement.insert.ConflictActionType;
import com.sqlparser.statement.update.UpdateSet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class InsertConflictAction
implements Serializable {
    ConflictActionType conflictActionType;
    private List<UpdateSet> updateSets;
    Expression whereExpression;

    public InsertConflictAction(ConflictActionType conflictActionType) {
        this.conflictActionType = Objects.requireNonNull(conflictActionType, "The Conflict Action Type is mandatory and must not be Null.");
    }

    public List<UpdateSet> getUpdateSets() {
        return this.updateSets;
    }

    public void setUpdateSets(List<UpdateSet> updateSets) {
        this.updateSets = updateSets;
    }

    public InsertConflictAction withUpdateSets(List<UpdateSet> updateSets) {
        this.setUpdateSets(updateSets);
        return this;
    }

    public ConflictActionType getConflictActionType() {
        return this.conflictActionType;
    }

    public void setConflictActionType(ConflictActionType conflictActionType) {
        this.conflictActionType = Objects.requireNonNull(conflictActionType, "The Conflict Action Type is mandatory and must not be Null.");
    }

    public InsertConflictAction withConflictActionType(ConflictActionType conflictActionType) {
        this.setConflictActionType(conflictActionType);
        return this;
    }

    public InsertConflictAction addUpdateSet(Column column, Expression expression) {
        return this.addUpdateSet(new UpdateSet());
    }

    public InsertConflictAction addUpdateSet(UpdateSet updateSet) {
        if (this.updateSets == null) {
            this.updateSets = new ArrayList<UpdateSet>();
        }
        this.updateSets.add(updateSet);
        return this;
    }

    public InsertConflictAction withUpdateSets(Collection<UpdateSet> updateSets) {
        this.setUpdateSets(new ArrayList<UpdateSet>(updateSets));
        return this;
    }

    public Expression getWhereExpression() {
        return this.whereExpression;
    }

    public void setWhereExpression(Expression whereExpression) {
        this.whereExpression = whereExpression;
    }

    public InsertConflictAction withWhereExpression(Expression whereExpression) {
        this.setWhereExpression(whereExpression);
        return this;
    }

    public StringBuilder appendTo(StringBuilder builder) {
        switch (this.conflictActionType) {
            case DO_NOTHING: {
                builder.append(" DO NOTHING");
                break;
            }
            case DO_UPDATE: {
                builder.append(" DO UPDATE SET ");
                UpdateSet.appendUpdateSetsTo(builder, this.updateSets);
                if (this.whereExpression == null) break;
                builder.append(" WHERE ").append(this.whereExpression);
            }
        }
        return builder;
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }
}

