/*
 * Decompiled with CFR 0.152.
 */
package com.sqlparser.statement.select;

import com.sqlparser.expression.Expression;
import com.sqlparser.expression.ExpressionVisitor;
import com.sqlparser.expression.operators.relational.ExpressionList;
import com.sqlparser.parser.ASTNodeAccessImpl;
import com.sqlparser.schema.Column;
import com.sqlparser.statement.select.SelectItem;
import java.util.ArrayList;
import java.util.List;

public class AllColumns
extends ASTNodeAccessImpl
implements Expression {
    protected ExpressionList<Column> exceptColumns;
    protected List<SelectItem<?>> replaceExpressions;

    public AllColumns(ExpressionList<Column> exceptColumns, List<SelectItem<?>> replaceExpressions) {
        this.exceptColumns = exceptColumns;
        this.replaceExpressions = replaceExpressions;
    }

    public AllColumns() {
        this(null, null);
    }

    public ExpressionList<Column> getExceptColumns() {
        return this.exceptColumns;
    }

    public ExpressionList<Column> addExceptColumn(Column column) {
        if (this.exceptColumns == null) {
            this.exceptColumns = new ExpressionList();
        }
        this.exceptColumns.add(column);
        return this.exceptColumns;
    }

    public AllColumns setExceptColumns(ExpressionList<Column> exceptColumns) {
        this.exceptColumns = exceptColumns;
        return this;
    }

    public List<SelectItem<?>> getReplaceExpressions() {
        return this.replaceExpressions;
    }

    public List<SelectItem<?>> addReplaceExpression(SelectItem<?> selectItem) {
        if (this.replaceExpressions == null) {
            this.replaceExpressions = new ArrayList();
        }
        this.replaceExpressions.add(selectItem);
        return this.replaceExpressions;
    }

    public AllColumns setReplaceExpressions(List<SelectItem<?>> replaceExpressions) {
        this.replaceExpressions = replaceExpressions;
        return this;
    }

    @Override
    public StringBuilder appendTo(StringBuilder builder) {
        builder.append("*");
        if (this.exceptColumns != null && this.exceptColumns.size() > 0) {
            builder.append(" Except( ");
            this.exceptColumns.appendTo(builder);
            builder.append(" )");
        }
        if (this.replaceExpressions != null && this.replaceExpressions.size() > 0) {
            builder.append(" Replace(");
            int i = 0;
            for (SelectItem<?> selectItem : this.replaceExpressions) {
                builder.append(i++ > 0 ? ", " : " ");
                selectItem.appendTo(builder);
            }
            builder.append(" )");
        }
        return builder;
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }

    @Override
    public void accept(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }
}

