/*
 * Decompiled with CFR 0.152.
 */
package com.sqlparser.statement.select;

import com.sqlparser.ClassName;
import com.sqlparser.parser.ASTNodeAccessImpl;

public class KSQLWindow
extends ASTNodeAccessImpl {
    private boolean hopping;
    private boolean tumbling;
    private boolean session;
    private long sizeDuration;
    private TimeUnit sizeTimeUnit;
    private long advanceDuration;
    private TimeUnit advanceTimeUnit;

    public boolean isHoppingWindow() {
        return this.hopping;
    }

    public void setHoppingWindow(boolean hopping) {
        this.hopping = hopping;
    }

    public boolean isTumblingWindow() {
        return this.tumbling;
    }

    public void setTumblingWindow(boolean tumbling) {
        this.tumbling = tumbling;
    }

    public boolean isSessionWindow() {
        return this.session;
    }

    public void setSessionWindow(boolean session) {
        this.session = session;
    }

    public long getSizeDuration() {
        return this.sizeDuration;
    }

    public void setSizeDuration(long sizeDuration) {
        this.sizeDuration = sizeDuration;
    }

    public TimeUnit getSizeTimeUnit() {
        return this.sizeTimeUnit;
    }

    public void setSizeTimeUnit(TimeUnit sizeTimeUnit) {
        this.sizeTimeUnit = sizeTimeUnit;
    }

    public long getAdvanceDuration() {
        return this.advanceDuration;
    }

    public void setAdvanceDuration(long advanceDuration) {
        this.advanceDuration = advanceDuration;
    }

    public TimeUnit getAdvanceTimeUnit() {
        return this.advanceTimeUnit;
    }

    public void setAdvanceTimeUnit(TimeUnit advanceTimeUnit) {
        this.advanceTimeUnit = advanceTimeUnit;
    }

    public String toString() {
        if (this.isHoppingWindow()) {
            return "HOPPING (SIZE " + this.sizeDuration + " " + this.sizeTimeUnit + ", ADVANCE BY " + this.advanceDuration + " " + this.advanceTimeUnit + ")";
        }
        if (this.isSessionWindow()) {
            return "SESSION (" + this.sizeDuration + " " + this.sizeTimeUnit + ")";
        }
        return "TUMBLING (SIZE " + this.sizeDuration + " " + this.sizeTimeUnit + ")";
    }

    public KSQLWindow withSizeDuration(long sizeDuration) {
        this.setSizeDuration(sizeDuration);
        return this;
    }

    public KSQLWindow withSizeTimeUnit(TimeUnit sizeTimeUnit) {
        this.setSizeTimeUnit(sizeTimeUnit);
        return this;
    }

    public KSQLWindow withAdvanceDuration(long advanceDuration) {
        this.setAdvanceDuration(advanceDuration);
        return this;
    }

    public KSQLWindow withAdvanceTimeUnit(TimeUnit advanceTimeUnit) {
        this.setAdvanceTimeUnit(advanceTimeUnit);
        return this;
    }

    public static enum WindowType implements ClassName
    {
        HOPPING("HOPPING"),
        SESSION("SESSION"),
        TUMBLING("TUMBLING");

        private String windowType;

        private WindowType(String windowType) {
            this.windowType = windowType;
        }

        public String getWindowType() {
            return this.windowType;
        }

        public static WindowType from(String type) {
            return Enum.valueOf(WindowType.class, type.toUpperCase());
        }
    }

    public static enum TimeUnit implements ClassName
    {
        DAY,
        HOUR,
        MINUTE,
        SECOND,
        MILLISECOND,
        DAYS,
        HOURS,
        MINUTES,
        SECONDS,
        MILLISECONDS;


        public static TimeUnit from(String unit) {
            return Enum.valueOf(TimeUnit.class, unit.toUpperCase());
        }
    }
}

