/*
 * Decompiled with CFR 0.152.
 */
package com.sqlparser.statement.select;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.sqlparser.expression.Expression;
import com.sqlparser.expression.ExpressionVisitor;
import com.sqlparser.parser.ASTNodeAccessImpl;
import com.sqlparser.statement.Statement;
import com.sqlparser.statement.StatementVisitor;
import com.sqlparser.statement.select.Fetch;
import com.sqlparser.statement.select.ForClause;
import com.sqlparser.statement.select.Limit;
import com.sqlparser.statement.select.Offset;
import com.sqlparser.statement.select.OrderByElement;
import com.sqlparser.statement.select.PlainSelect;
import com.sqlparser.statement.select.SelectVisitor;
import com.sqlparser.statement.select.SetOperationList;
import com.sqlparser.statement.select.Values;
import com.sqlparser.statement.select.WithIsolation;
import com.sqlparser.statement.select.WithItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;

public abstract class Select
extends ASTNodeAccessImpl
implements Statement,
Expression {
    List<WithItem> withItemsList;
    Limit limitBy;
    Limit limit;
    Offset offset;
    Fetch fetch;
    WithIsolation isolation;
    boolean oracleSiblings = false;
    ForClause forClause = null;
    List<OrderByElement> orderByElements;

    public static String orderByToString(List<OrderByElement> orderByElements) {
        return Select.orderByToString(false, orderByElements);
    }

    public static String orderByToString(boolean oracleSiblings, List<OrderByElement> orderByElements) {
        return Select.getFormattedList(orderByElements, oracleSiblings ? "ORDER SIBLINGS BY" : "ORDER BY");
    }

    public static String getFormattedList(List<?> list, String expression) {
        return Select.getFormattedList(list, expression, true, false);
    }

    public static String getFormattedList(List<?> list, String expression, boolean useComma, boolean useBrackets) {
        String sql = Select.getStringList(list, useComma, useBrackets);
        if (sql.length() > 0) {
            sql = expression.length() > 0 ? " " + expression + " " + sql : " " + sql;
        }
        return sql;
    }

    public static String getStringList(List<?> list) {
        return Select.getStringList(list, true, false);
    }

    public static String getStringList(List<?> list, boolean useComma, boolean useBrackets) {
        return Select.appendStringListTo(new StringBuilder(), list, useComma, useBrackets).toString();
    }

    public static StringBuilder appendStringListTo(StringBuilder builder, List<?> list, boolean useComma, boolean useBrackets) {
        if (list != null) {
            String comma;
            String string = comma = useComma ? ", " : " ";
            if (useBrackets) {
                builder.append("(");
            }
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                builder.append(list.get(i)).append(i < size - 1 ? comma : "");
            }
            if (useBrackets) {
                builder.append(")");
            }
        }
        return builder;
    }

    public List<WithItem> getWithItemsList() {
        return this.withItemsList;
    }

    public void setWithItemsList(List<WithItem> withItemsList) {
        this.withItemsList = withItemsList;
    }

    public Select withWithItemsList(List<WithItem> withItemsList) {
        this.setWithItemsList(withItemsList);
        return this;
    }

    public Select addWithItemsList(Collection<? extends WithItem> withItemsList) {
        List collection = Optional.ofNullable(this.getWithItemsList()).orElseGet(ArrayList::new);
        collection.addAll(withItemsList);
        return this.withWithItemsList(collection);
    }

    public Select addWithItemsList(WithItem ... withItemsList) {
        return this.addWithItemsList(Arrays.asList(withItemsList));
    }

    public boolean isOracleSiblings() {
        return this.oracleSiblings;
    }

    public void setOracleSiblings(boolean oracleSiblings) {
        this.oracleSiblings = oracleSiblings;
    }

    public Select withOracleSiblings(boolean oracleSiblings) {
        this.setOracleSiblings(oracleSiblings);
        return this;
    }

    public ForClause getForClause() {
        return this.forClause;
    }

    public Select setForClause(ForClause forClause) {
        this.forClause = forClause;
        return this;
    }

    public List<OrderByElement> getOrderByElements() {
        return this.orderByElements;
    }

    public void setOrderByElements(List<OrderByElement> orderByElements) {
        this.orderByElements = orderByElements;
    }

    public Select withOrderByElements(List<OrderByElement> orderByElements) {
        this.setOrderByElements(orderByElements);
        return this;
    }

    public Select addOrderByElements(Collection<? extends OrderByElement> orderByElements) {
        List collection = Optional.ofNullable(this.getOrderByElements()).orElseGet(ArrayList::new);
        collection.addAll(orderByElements);
        return this.withOrderByElements(collection);
    }

    public Select addOrderByElements(OrderByElement ... orderByElements) {
        return this.addOrderByElements(Arrays.asList(orderByElements));
    }

    public Limit getLimit() {
        return this.limit;
    }

    public void setLimit(Limit limit) {
        this.limit = limit;
    }

    public Select withLimit(Limit limit) {
        this.setLimit(limit);
        return this;
    }

    public Limit getLimitBy() {
        return this.limitBy;
    }

    public void setLimitBy(Limit limitBy) {
        this.limitBy = limitBy;
    }

    public <E extends Select> E withLimitBy(Class<E> type, Limit limitBy) {
        this.setLimitBy(limitBy);
        return (E)((Select)type.cast(this));
    }

    public Offset getOffset() {
        return this.offset;
    }

    public void setOffset(Offset offset) {
        this.offset = offset;
    }

    public Select withOffset(Offset offset) {
        this.setOffset(offset);
        return this;
    }

    public Fetch getFetch() {
        return this.fetch;
    }

    public void setFetch(Fetch fetch) {
        this.fetch = fetch;
    }

    public Select withFetch(Fetch fetch) {
        this.setFetch(fetch);
        return this;
    }

    public WithIsolation getIsolation() {
        return this.isolation;
    }

    public void setIsolation(WithIsolation isolation) {
        this.isolation = isolation;
    }

    public Select withIsolation(WithIsolation isolation) {
        this.setIsolation(isolation);
        return this;
    }

    public abstract StringBuilder appendSelectBodyTo(StringBuilder var1);

    @Override
    public StringBuilder appendTo(StringBuilder builder) {
        if (this.withItemsList != null && !this.withItemsList.isEmpty()) {
            builder.append("WITH ");
            Iterator<WithItem> iter = this.withItemsList.iterator();
            while (iter.hasNext()) {
                WithItem withItem = iter.next();
                builder.append(withItem);
                if (iter.hasNext()) {
                    builder.append(",");
                }
                builder.append(" ");
            }
        }
        this.appendSelectBodyTo(builder);
        if (this.forClause != null) {
            this.forClause.appendTo(builder);
        }
        builder.append(Select.orderByToString(this.oracleSiblings, this.orderByElements));
        if (this.limitBy != null) {
            builder.append(this.limitBy);
        }
        if (this.limit != null) {
            builder.append(this.limit);
        }
        if (this.offset != null) {
            builder.append(this.offset);
        }
        if (this.fetch != null) {
            builder.append(this.fetch);
        }
        if (this.isolation != null) {
            builder.append(this.isolation);
        }
        return builder;
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }

    public abstract void accept(SelectVisitor var1);

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    @Override
    public void accept(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    @Deprecated
    @JsonIgnore
    public Select getSelectBody() {
        return this;
    }

    @JsonIgnore
    public Values getValues() {
        return (Values)this;
    }

    @JsonIgnore
    public PlainSelect getPlainSelect() {
        return (PlainSelect)this;
    }

    @JsonIgnore
    public SetOperationList getSetOperationList() {
        return (SetOperationList)this;
    }

    @JsonIgnore
    public <E extends Select> E as(Class<E> type) {
        return (E)((Select)type.cast(this));
    }
}

