/*
 * Decompiled with CFR 0.152.
 */
package com.sqlparser.statement.show;

import com.sqlparser.expression.Expression;
import com.sqlparser.statement.Statement;
import com.sqlparser.statement.StatementVisitor;
import java.util.EnumSet;

public class ShowTablesStatement
implements Statement {
    private EnumSet<Modifiers> modifiers;
    private SelectionMode selectionMode;
    private String dbName;
    private Expression likeExpression;
    private Expression whereCondition;

    public EnumSet<Modifiers> getModifiers() {
        return this.modifiers;
    }

    public void setModifiers(EnumSet<Modifiers> modifiers) {
        this.modifiers = modifiers;
    }

    public SelectionMode getSelectionMode() {
        return this.selectionMode;
    }

    public void setSelectionMode(SelectionMode selectionMode) {
        this.selectionMode = selectionMode;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public Expression getLikeExpression() {
        return this.likeExpression;
    }

    public void setLikeExpression(Expression likeExpression) {
        this.likeExpression = likeExpression;
    }

    public Expression getWhereCondition() {
        return this.whereCondition;
    }

    public void setWhereCondition(Expression whereCondition) {
        this.whereCondition = whereCondition;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SHOW");
        if (this.modifiers.contains((Object)Modifiers.EXTENDED)) {
            builder.append(" EXTENDED");
        }
        if (this.modifiers.contains((Object)Modifiers.FULL)) {
            builder.append(" FULL");
        }
        builder.append(" TABLES");
        if (this.dbName != null) {
            builder.append(" ").append(this.selectionMode.name()).append(" ").append(this.dbName);
        }
        if (this.likeExpression != null) {
            builder.append(" ").append("LIKE").append(" ").append(this.likeExpression);
        }
        if (this.whereCondition != null) {
            builder.append(" ").append("WHERE").append(" ").append(this.whereCondition);
        }
        return builder.toString();
    }

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public static enum Modifiers {
        EXTENDED,
        FULL;


        public static Modifiers from(String modifier) {
            return Enum.valueOf(Modifiers.class, modifier.toUpperCase());
        }
    }

    public static enum SelectionMode {
        FROM,
        IN;


        public static SelectionMode from(String mode) {
            return Enum.valueOf(SelectionMode.class, mode.toUpperCase());
        }
    }
}

