/*
 * Decompiled with CFR 0.152.
 */
package com.sqlparser.statement.update;

import com.sqlparser.expression.Expression;
import com.sqlparser.expression.OracleHint;
import com.sqlparser.schema.Column;
import com.sqlparser.schema.Table;
import com.sqlparser.statement.OutputClause;
import com.sqlparser.statement.ReturningClause;
import com.sqlparser.statement.Statement;
import com.sqlparser.statement.StatementVisitor;
import com.sqlparser.statement.select.FromItem;
import com.sqlparser.statement.select.Join;
import com.sqlparser.statement.select.Limit;
import com.sqlparser.statement.select.OrderByElement;
import com.sqlparser.statement.select.PlainSelect;
import com.sqlparser.statement.select.Select;
import com.sqlparser.statement.select.WithItem;
import com.sqlparser.statement.update.UpdateModifierPriority;
import com.sqlparser.statement.update.UpdateSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;

public class Update
implements Statement {
    private List<WithItem> withItemsList;
    private Table table;
    private Expression where;
    private List<UpdateSet> updateSets;
    private FromItem fromItem;
    private List<Join> joins;
    private List<Join> startJoins;
    private OracleHint oracleHint = null;
    private List<OrderByElement> orderByElements;
    private Limit limit;
    private ReturningClause returningClause;
    private UpdateModifierPriority modifierPriority;
    private boolean modifierIgnore;
    private OutputClause outputClause;

    public OutputClause getOutputClause() {
        return this.outputClause;
    }

    public void setOutputClause(OutputClause outputClause) {
        this.outputClause = outputClause;
    }

    public List<UpdateSet> getUpdateSets() {
        return this.updateSets;
    }

    public UpdateSet getUpdateSet(int index) {
        return this.updateSets.get(index);
    }

    public void setUpdateSets(List<UpdateSet> updateSets) {
        this.updateSets = updateSets;
    }

    public Update withUpdateSets(List<UpdateSet> updateSets) {
        this.setUpdateSets(updateSets);
        return this;
    }

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public List<WithItem> getWithItemsList() {
        return this.withItemsList;
    }

    public void setWithItemsList(List<WithItem> withItemsList) {
        this.withItemsList = withItemsList;
    }

    public Update withWithItemsList(List<WithItem> withItemsList) {
        this.setWithItemsList(withItemsList);
        return this;
    }

    public Update addWithItemsList(WithItem ... withItemsList) {
        List collection = Optional.ofNullable(this.getWithItemsList()).orElseGet(ArrayList::new);
        Collections.addAll(collection, withItemsList);
        return this.withWithItemsList(collection);
    }

    public Update addWithItemsList(Collection<? extends WithItem> withItemsList) {
        List collection = Optional.ofNullable(this.getWithItemsList()).orElseGet(ArrayList::new);
        collection.addAll(withItemsList);
        return this.withWithItemsList(collection);
    }

    public Table getTable() {
        return this.table;
    }

    public Expression getWhere() {
        return this.where;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public void setWhere(Expression expression) {
        this.where = expression;
    }

    public OracleHint getOracleHint() {
        return this.oracleHint;
    }

    public void setOracleHint(OracleHint oracleHint) {
        this.oracleHint = oracleHint;
    }

    public Update addUpdateSet(Column column, Expression expression) {
        return this.addUpdateSet(new UpdateSet(column, expression));
    }

    public Update addUpdateSet(UpdateSet updateSet) {
        if (this.updateSets == null) {
            this.updateSets = new ArrayList<UpdateSet>();
        }
        this.updateSets.add(updateSet);
        return this;
    }

    @Deprecated
    public List<Column> getColumns() {
        return this.updateSets.get((int)0).columns;
    }

    @Deprecated
    public List<Expression> getExpressions() {
        return this.updateSets.get((int)0).values;
    }

    @Deprecated
    public void setColumns(List<Column> list) {
        if (this.updateSets.isEmpty()) {
            this.updateSets.add(new UpdateSet());
        }
        this.updateSets.get((int)0).columns.clear();
        this.updateSets.get((int)0).columns.addAll(list);
    }

    @Deprecated
    public void setExpressions(List<Expression> list) {
        this.updateSets.get((int)0).values.clear();
        this.updateSets.get((int)0).values.addAll(list);
    }

    public FromItem getFromItem() {
        return this.fromItem;
    }

    public void setFromItem(FromItem fromItem) {
        this.fromItem = fromItem;
    }

    public List<Join> getJoins() {
        return this.joins;
    }

    public void setJoins(List<Join> joins) {
        this.joins = joins;
    }

    public List<Join> getStartJoins() {
        return this.startJoins;
    }

    public void setStartJoins(List<Join> startJoins) {
        this.startJoins = startJoins;
    }

    @Deprecated
    public Select getSelect() {
        Select select = null;
        if (this.updateSets.get((int)0).values.get(0) instanceof Select) {
            select = (Select)this.updateSets.get((int)0).values.get(0);
        }
        return select;
    }

    @Deprecated
    public void setSelect(Select select) {
        if (select != null) {
            if (this.updateSets.get((int)0).values.isEmpty()) {
                this.updateSets.get((int)0).values.add(select);
            } else {
                this.updateSets.get((int)0).values.set(0, select);
            }
        }
    }

    @Deprecated
    public boolean isUseColumnsBrackets() {
        return false;
    }

    @Deprecated
    public void setUseColumnsBrackets(boolean useColumnsBrackets) {
    }

    @Deprecated
    public boolean isUseSelect() {
        return false;
    }

    @Deprecated
    public void setUseSelect(boolean useSelect) {
    }

    public void setOrderByElements(List<OrderByElement> orderByElements) {
        this.orderByElements = orderByElements;
    }

    public void setLimit(Limit limit) {
        this.limit = limit;
    }

    public List<OrderByElement> getOrderByElements() {
        return this.orderByElements;
    }

    public Limit getLimit() {
        return this.limit;
    }

    public ReturningClause getReturningClause() {
        return this.returningClause;
    }

    public Update setReturningClause(ReturningClause returningClause) {
        this.returningClause = returningClause;
        return this;
    }

    public UpdateModifierPriority getModifierPriority() {
        return this.modifierPriority;
    }

    public void setModifierPriority(UpdateModifierPriority modifierPriority) {
        this.modifierPriority = modifierPriority;
    }

    public boolean isModifierIgnore() {
        return this.modifierIgnore;
    }

    public void setModifierIgnore(boolean modifierIgnore) {
        this.modifierIgnore = modifierIgnore;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        if (this.withItemsList != null && !this.withItemsList.isEmpty()) {
            b.append("WITH ");
            Iterator<WithItem> iter = this.withItemsList.iterator();
            while (iter.hasNext()) {
                WithItem withItem = iter.next();
                b.append(withItem);
                if (iter.hasNext()) {
                    b.append(",");
                }
                b.append(" ");
            }
        }
        b.append("UPDATE ");
        if (this.oracleHint != null) {
            b.append(this.oracleHint).append(" ");
        }
        if (this.modifierPriority != null) {
            b.append(this.modifierPriority.name()).append(" ");
        }
        if (this.modifierIgnore) {
            b.append("IGNORE ");
        }
        b.append(this.table);
        if (this.startJoins != null) {
            for (Join join : this.startJoins) {
                if (join.isSimple()) {
                    b.append(", ").append(join);
                    continue;
                }
                b.append(" ").append(join);
            }
        }
        b.append(" SET ");
        UpdateSet.appendUpdateSetsTo(b, this.updateSets);
        if (this.outputClause != null) {
            this.outputClause.appendTo(b);
        }
        if (this.fromItem != null) {
            b.append(" FROM ").append(this.fromItem);
            if (this.joins != null) {
                for (Join join : this.joins) {
                    if (join.isSimple()) {
                        b.append(", ").append(join);
                        continue;
                    }
                    b.append(" ").append(join);
                }
            }
        }
        if (this.where != null) {
            b.append(" WHERE ");
            b.append(this.where);
        }
        if (this.orderByElements != null) {
            b.append(PlainSelect.orderByToString(this.orderByElements));
        }
        if (this.limit != null) {
            b.append(this.limit);
        }
        if (this.returningClause != null) {
            this.returningClause.appendTo(b);
        }
        return b.toString();
    }

    public Update withTable(Table table) {
        this.setTable(table);
        return this;
    }

    public Update withFromItem(FromItem fromItem) {
        this.setFromItem(fromItem);
        return this;
    }

    public Update withJoins(List<Join> joins) {
        this.setJoins(joins);
        return this;
    }

    public Update withStartJoins(List<Join> startJoins) {
        this.setStartJoins(startJoins);
        return this;
    }

    public Update withSelect(Select select) {
        this.setSelect(select);
        return this;
    }

    public Update withUseColumnsBrackets(boolean useColumnsBrackets) {
        this.setUseColumnsBrackets(useColumnsBrackets);
        return this;
    }

    public Update withUseSelect(boolean useSelect) {
        this.setUseSelect(useSelect);
        return this;
    }

    public Update withOrderByElements(List<OrderByElement> orderByElements) {
        this.setOrderByElements(orderByElements);
        return this;
    }

    public Update withLimit(Limit limit) {
        this.setLimit(limit);
        return this;
    }

    public Update withWhere(Expression where) {
        this.setWhere(where);
        return this;
    }

    public Update withColumns(List<Column> columns) {
        this.setColumns(columns);
        return this;
    }

    public Update withExpressions(List<Expression> expressions) {
        this.setExpressions(expressions);
        return this;
    }

    public Update withModifierPriority(UpdateModifierPriority modifierPriority) {
        this.setModifierPriority(modifierPriority);
        return this;
    }

    public Update withModifierIgnore(boolean modifierIgnore) {
        this.setModifierIgnore(modifierIgnore);
        return this;
    }

    public Update addColumns(Column ... columns) {
        return this.addColumns(Arrays.asList(columns));
    }

    public Update addColumns(Collection<? extends Column> columns) {
        for (Column column : columns) {
            this.updateSets.get(this.updateSets.size() - 1).add(column);
        }
        return this;
    }

    public Update addExpressions(Expression ... expressions) {
        return this.addExpressions(Arrays.asList(expressions));
    }

    public Update addExpressions(Collection<? extends Expression> expressions) {
        for (Expression expression : expressions) {
            this.updateSets.get(this.updateSets.size() - 1).add(expression);
        }
        return this;
    }

    public Update addJoins(Join ... joins) {
        List collection = Optional.ofNullable(this.getJoins()).orElseGet(ArrayList::new);
        Collections.addAll(collection, joins);
        return this.withJoins(collection);
    }

    public Update addJoins(Collection<? extends Join> joins) {
        List collection = Optional.ofNullable(this.getJoins()).orElseGet(ArrayList::new);
        collection.addAll(joins);
        return this.withJoins(collection);
    }

    public Update addStartJoins(Join ... startJoins) {
        List collection = Optional.ofNullable(this.getStartJoins()).orElseGet(ArrayList::new);
        Collections.addAll(collection, startJoins);
        return this.withStartJoins(collection);
    }

    public Update addStartJoins(Collection<? extends Join> startJoins) {
        List collection = Optional.ofNullable(this.getStartJoins()).orElseGet(ArrayList::new);
        collection.addAll(startJoins);
        return this.withStartJoins(collection);
    }

    public Update addOrderByElements(OrderByElement ... orderByElements) {
        List collection = Optional.ofNullable(this.getOrderByElements()).orElseGet(ArrayList::new);
        Collections.addAll(collection, orderByElements);
        return this.withOrderByElements(collection);
    }

    public Update addOrderByElements(Collection<? extends OrderByElement> orderByElements) {
        List collection = Optional.ofNullable(this.getOrderByElements()).orElseGet(ArrayList::new);
        collection.addAll(orderByElements);
        return this.withOrderByElements(collection);
    }

    public <E extends Expression> E getWhere(Class<E> type) {
        return (E)((Expression)type.cast(this.getWhere()));
    }

    public <E extends FromItem> E getFromItem(Class<E> type) {
        return (E)((FromItem)type.cast(this.getFromItem()));
    }
}

