/*
 * Decompiled with CFR 0.152.
 */
package com.sqlparser.statement.upsert;

import com.sqlparser.expression.operators.relational.ExpressionList;
import com.sqlparser.schema.Column;
import com.sqlparser.schema.Table;
import com.sqlparser.statement.Statement;
import com.sqlparser.statement.StatementVisitor;
import com.sqlparser.statement.select.PlainSelect;
import com.sqlparser.statement.select.Select;
import com.sqlparser.statement.select.SetOperationList;
import com.sqlparser.statement.select.Values;
import com.sqlparser.statement.update.UpdateSet;
import com.sqlparser.statement.upsert.UpsertType;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

public class Upsert
implements Statement {
    private Table table;
    private ExpressionList<Column> columns;
    private ExpressionList<?> expressions;
    private Select select;
    private List<UpdateSet> updateSets;
    private List<UpdateSet> duplicateUpdateSets;
    private UpsertType upsertType = UpsertType.UPSERT;
    private boolean isUsingInto;

    public List<UpdateSet> getUpdateSets() {
        return this.updateSets;
    }

    public Upsert setUpdateSets(List<UpdateSet> updateSets) {
        this.updateSets = updateSets;
        return this;
    }

    public List<UpdateSet> getDuplicateUpdateSets() {
        return this.duplicateUpdateSets;
    }

    public Upsert setDuplicateUpdateSets(List<UpdateSet> duplicateUpdateSets) {
        this.duplicateUpdateSets = duplicateUpdateSets;
        return this;
    }

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public UpsertType getUpsertType() {
        return this.upsertType;
    }

    public void setUpsertType(UpsertType upsertType) {
        this.upsertType = upsertType;
    }

    public Upsert withUpsertType(UpsertType upsertType) {
        this.setUpsertType(upsertType);
        return this;
    }

    public boolean isUsingInto() {
        return this.isUsingInto;
    }

    public void setUsingInto(boolean useInto) {
        this.isUsingInto = useInto;
    }

    public Upsert withUsingInto(boolean useInto) {
        this.setUsingInto(useInto);
        return this;
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table name) {
        this.table = name;
    }

    public ExpressionList<Column> getColumns() {
        return this.columns;
    }

    public void setColumns(ExpressionList<Column> list) {
        this.columns = list;
    }

    public ExpressionList getExpressions() {
        return this.expressions;
    }

    public void setExpressions(ExpressionList list) {
        this.expressions = list;
    }

    @Deprecated
    public ExpressionList<?> getSetExpressions() {
        return this.expressions;
    }

    public Select getSelect() {
        return this.select;
    }

    public void setSelect(Select select) {
        this.select = select;
    }

    public Values getValues() {
        return this.select.getValues();
    }

    public PlainSelect getPlainSelect() {
        return this.select.getPlainSelect();
    }

    public SetOperationList getSetOperationList() {
        return this.select.getSetOperationList();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        switch (this.upsertType) {
            case REPLACE: 
            case REPLACE_SET: {
                sb.append("REPLACE ");
                break;
            }
            case INSERT_OR_ABORT: {
                sb.append("INSERT OR ABORT ");
                break;
            }
            case INSERT_OR_FAIL: {
                sb.append("INSERT OR FAIL ");
                break;
            }
            case INSERT_OR_IGNORE: {
                sb.append("INSERT OR IGNORE ");
                break;
            }
            case INSERT_OR_REPLACE: {
                sb.append("INSERT OR REPLACE ");
                break;
            }
            case INSERT_OR_ROLLBACK: {
                sb.append("INSERT OR ROLLBACK ");
                break;
            }
            default: {
                sb.append("UPSERT ");
            }
        }
        if (this.isUsingInto) {
            sb.append("INTO ");
        }
        sb.append(this.table).append(" ");
        if (this.updateSets != null) {
            sb.append("SET ");
            UpdateSet.appendUpdateSetsTo(sb, this.updateSets);
        } else {
            if (this.columns != null) {
                sb.append(this.columns).append(" ");
            }
            if (this.select != null) {
                sb.append(this.select);
            }
        }
        if (this.duplicateUpdateSets != null) {
            sb.append(" ON DUPLICATE KEY UPDATE ");
            UpdateSet.appendUpdateSetsTo(sb, this.duplicateUpdateSets);
        }
        return sb.toString();
    }

    public Upsert withSelect(Select select) {
        this.setSelect(select);
        return this;
    }

    public Upsert withTable(Table table) {
        this.setTable(table);
        return this;
    }

    public Upsert withColumns(ExpressionList<Column> columns) {
        this.setColumns(columns);
        return this;
    }

    public Upsert withExpressions(ExpressionList expressions) {
        this.setExpressions(expressions);
        return this;
    }

    public Upsert addColumns(Column ... columns) {
        return this.addColumns(Arrays.asList(columns));
    }

    public Upsert addColumns(Collection<? extends Column> columns) {
        ExpressionList collection = Optional.ofNullable(this.getColumns()).orElseGet(ExpressionList::new);
        collection.addAll(columns);
        return this.withColumns(collection);
    }
}

