/*
 * Decompiled with CFR 0.152.
 */
package com.sqlparser.util;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.reflect.generics.reflectiveObjects.ParameterizedTypeImpl;

public class ReflectionUtils {
    private static final Logger logger = LoggerFactory.getLogger(ReflectionUtils.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static <T> T getObject(JsonNode node, Class<T> type) throws InstantiationException, IllegalAccessException, ClassNotFoundException, JsonProcessingException, InvocationTargetException, NoSuchMethodException {
        T t = type.newInstance();
        Map<String, List<Method>> methodMap = ReflectionUtils.getMethodsGroupByMethodName(type);
        for (String methodName : methodMap.keySet()) {
            String uncapitalize = ReflectionUtils.uncapitalize(methodName.substring(3));
            JsonNode jsonNode = node.get(uncapitalize);
            List methods = methodMap.getOrDefault(methodName, new ArrayList());
            if (jsonNode == null) continue;
            for (Method method : methods) {
                ArrayList param;
                if (methods.size() > 1 && ((JsonProperty[])method.getAnnotationsByType(JsonProperty.class)).length < 1) continue;
                Class<?> methodParameterType = method.getParameterTypes()[0];
                if (jsonNode.isNull()) {
                    param = null;
                } else if (jsonNode.isObject()) {
                    if (ReflectionUtils.isContains(jsonNode, "className")) {
                        Class<?> ObjectClass = ReflectionUtils.localClass(jsonNode);
                        param = ReflectionUtils.getObject(jsonNode, ObjectClass);
                    } else {
                        HashMap resultMap = new HashMap();
                        jsonNode.fields().forEachRemaining(entry -> resultMap.put(entry.getKey(), ((JsonNode)entry.getValue()).asText()));
                        param = resultMap;
                    }
                } else if (jsonNode.isArray()) {
                    if (methodParameterType.getClassLoader() == null) {
                        Type[] parameterTypes = method.getGenericParameterTypes();
                        ParameterizedTypeImpl parameterType = (ParameterizedTypeImpl)parameterTypes[0];
                        Type l = parameterType.getRawType();
                        Class<?> p = ReflectionUtils.localClass(parameterType.getActualTypeArguments()[0].getTypeName());
                        if (p.getClassLoader() == null) {
                            param = objectMapper.convertValue((Object)jsonNode, (JavaType)objectMapper.getTypeFactory().constructCollectionType((Class)l, p));
                        } else {
                            ArrayList objects = new ArrayList();
                            ArrayNode arrayNode = (ArrayNode)jsonNode;
                            for (JsonNode json : arrayNode) {
                                Class<?> ObjectClass = ReflectionUtils.localClass(json);
                                objects.add(ReflectionUtils.getObject(json, ObjectClass));
                            }
                            param = objects;
                        }
                    } else {
                        param = methodParameterType.newInstance();
                        ArrayList objects = new ArrayList();
                        ArrayNode arrayNode = (ArrayNode)jsonNode;
                        for (JsonNode json : arrayNode) {
                            Class<?> ObjectClass = ReflectionUtils.localClass(json);
                            objects.add(ReflectionUtils.getObject(json, ObjectClass));
                        }
                        Method set = methodParameterType.getMethod("init", List.class);
                        set.invoke(param, objects);
                    }
                } else {
                    param = objectMapper.convertValue((Object)jsonNode, methodParameterType);
                }
                method.invoke(t, param);
            }
        }
        return t;
    }

    public static boolean isContains(JsonNode jsonNode, String key) {
        return jsonNode.get(key) != null;
    }

    public static Class<?> localClass(String className) throws ClassNotFoundException {
        if (className.contains("?")) {
            className = className.substring(0, className.length() - 3);
        }
        return Class.forName(className);
    }

    public static Class<?> localClass(JsonNode jsonNode) throws ClassNotFoundException {
        String className = (String)objectMapper.convertValue((Object)jsonNode.get("className"), String.class);
        return Class.forName(className);
    }

    public static Map<String, List<Method>> getMethodsGroupByMethodName(Class<?> clazz) {
        return ReflectionUtils.getMethods(clazz).stream().collect(Collectors.groupingBy(Method::getName));
    }

    public static List<Method> getMethods(Class<?> clazz) {
        return Arrays.stream(clazz.getMethods()).filter(method -> Modifier.isPublic(method.getModifiers()) && method.getName().startsWith("set") && method.getParameterCount() == 1).collect(Collectors.toList());
    }

    public static String uncapitalize(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        return Character.toLowerCase(str.charAt(0)) + str.substring(1);
    }
}

