/*
 * Decompiled with CFR 0.152.
 */
package com.sqlparser.util.deparser;

import com.sqlparser.statement.create.view.AlterView;
import com.sqlparser.statement.select.PlainSelect;
import com.sqlparser.statement.select.SelectVisitor;
import com.sqlparser.util.deparser.AbstractDeParser;
import com.sqlparser.util.deparser.ExpressionDeParser;
import com.sqlparser.util.deparser.SelectDeParser;

public class AlterViewDeParser
extends AbstractDeParser<AlterView> {
    private SelectVisitor selectVisitor;

    public AlterViewDeParser(StringBuilder buffer) {
        super(buffer);
        SelectDeParser selectDeParser = new SelectDeParser(buffer);
        ExpressionDeParser expressionDeParser = new ExpressionDeParser(selectDeParser, buffer);
        selectDeParser.setExpressionVisitor(expressionDeParser);
        this.selectVisitor = selectDeParser;
    }

    public AlterViewDeParser(StringBuilder buffer, SelectVisitor selectVisitor) {
        super(buffer);
        this.selectVisitor = selectVisitor;
    }

    @Override
    public void deParse(AlterView alterView) {
        if (alterView.isUseReplace()) {
            this.buffer.append("REPLACE ");
        } else {
            this.buffer.append("ALTER ");
        }
        this.buffer.append("VIEW ").append(alterView.getView().getFullyQualifiedName());
        if (alterView.getColumnNames() != null) {
            this.buffer.append(PlainSelect.getStringList(alterView.getColumnNames(), true, true));
        }
        this.buffer.append(" AS ");
        alterView.getSelect().accept(this.selectVisitor);
    }
}

