/*
 * Decompiled with CFR 0.152.
 */
package com.sqlparser.util.deparser;

import com.sqlparser.statement.create.index.CreateIndex;
import com.sqlparser.statement.create.table.Index;
import com.sqlparser.util.deparser.AbstractDeParser;
import java.util.stream.Collectors;

public class CreateIndexDeParser
extends AbstractDeParser<CreateIndex> {
    public CreateIndexDeParser(StringBuilder buffer) {
        super(buffer);
    }

    @Override
    public void deParse(CreateIndex createIndex) {
        Index index = createIndex.getIndex();
        this.buffer.append("CREATE ");
        if (index.getType() != null) {
            this.buffer.append(index.getType());
            this.buffer.append(" ");
        }
        this.buffer.append("INDEX ");
        if (createIndex.isUsingIfNotExists()) {
            this.buffer.append("IF NOT EXISTS ");
        }
        this.buffer.append(index.getName());
        String using = index.getUsing();
        if (using != null && createIndex.isIndexTypeBeforeOn()) {
            this.buffer.append(" USING ");
            this.buffer.append(using);
        }
        this.buffer.append(" ON ");
        this.buffer.append(createIndex.getTable().getFullyQualifiedName());
        if (using != null && !createIndex.isIndexTypeBeforeOn()) {
            this.buffer.append(" USING ");
            this.buffer.append(using);
        }
        if (index.getColumnsNames() != null) {
            this.buffer.append(" (");
            this.buffer.append(index.getColumnWithParams().stream().map(cp -> cp.columnName + (cp.getParams() != null ? " " + String.join((CharSequence)" ", cp.getParams()) : "")).collect(Collectors.joining(", ")));
            this.buffer.append(")");
        }
        if (createIndex.getTailParameters() != null) {
            for (String param : createIndex.getTailParameters()) {
                this.buffer.append(" ").append(param);
            }
        }
    }
}

