/*
 * Decompiled with CFR 0.152.
 */
package com.sqlparser.util.deparser;

import com.sqlparser.statement.create.view.AutoRefreshOption;
import com.sqlparser.statement.create.view.CreateView;
import com.sqlparser.statement.create.view.TemporaryOption;
import com.sqlparser.statement.select.PlainSelect;
import com.sqlparser.statement.select.Select;
import com.sqlparser.statement.select.SelectVisitor;
import com.sqlparser.util.deparser.AbstractDeParser;
import com.sqlparser.util.deparser.ExpressionDeParser;
import com.sqlparser.util.deparser.SelectDeParser;

public class CreateViewDeParser
extends AbstractDeParser<CreateView> {
    private final SelectVisitor selectVisitor;

    public CreateViewDeParser(StringBuilder buffer) {
        super(buffer);
        SelectDeParser selectDeParser = new SelectDeParser();
        selectDeParser.setBuffer(buffer);
        ExpressionDeParser expressionDeParser = new ExpressionDeParser(selectDeParser, buffer);
        selectDeParser.setExpressionVisitor(expressionDeParser);
        this.selectVisitor = selectDeParser;
    }

    public CreateViewDeParser(StringBuilder buffer, SelectVisitor selectVisitor) {
        super(buffer);
        this.selectVisitor = selectVisitor;
    }

    @Override
    public void deParse(CreateView createView) {
        this.buffer.append("CREATE ");
        if (createView.isOrReplace()) {
            this.buffer.append("OR REPLACE ");
        }
        switch (createView.getForce()) {
            case FORCE: {
                this.buffer.append("FORCE ");
                break;
            }
            case NO_FORCE: {
                this.buffer.append("NO FORCE ");
                break;
            }
            case NONE: {
                break;
            }
        }
        if (createView.getTemporary() != TemporaryOption.NONE) {
            this.buffer.append(createView.getTemporary().name()).append(" ");
        }
        if (createView.isMaterialized()) {
            this.buffer.append("MATERIALIZED ");
        }
        this.buffer.append("VIEW ").append(createView.getView().getFullyQualifiedName());
        if (createView.isIfNotExists()) {
            this.buffer.append(" IF NOT EXISTS");
        }
        if (createView.getAutoRefresh() != AutoRefreshOption.NONE) {
            this.buffer.append(" AUTO REFRESH ").append(createView.getAutoRefresh().name());
        }
        if (createView.getColumnNames() != null) {
            this.buffer.append("(");
            this.buffer.append(createView.getColumnNames());
            this.buffer.append(")");
        }
        if (createView.getViewCommentOptions() != null) {
            this.buffer.append(PlainSelect.getStringList(createView.getViewCommentOptions(), false, false));
        }
        this.buffer.append(" AS ");
        Select select = createView.getSelect();
        select.accept(this.selectVisitor);
        if (createView.isWithReadOnly()) {
            this.buffer.append(" WITH READ ONLY");
        }
    }
}

