/*
 * Decompiled with CFR 0.152.
 */
package com.sqlparser.util.deparser;

import com.sqlparser.expression.Expression;
import com.sqlparser.expression.ExpressionVisitor;
import com.sqlparser.statement.SetStatement;
import com.sqlparser.util.deparser.AbstractDeParser;
import java.util.List;

public class SetStatementDeParser
extends AbstractDeParser<SetStatement> {
    private ExpressionVisitor expressionVisitor;

    public SetStatementDeParser(ExpressionVisitor expressionVisitor, StringBuilder buffer) {
        super(buffer);
        this.expressionVisitor = expressionVisitor;
    }

    @Override
    public void deParse(SetStatement set) {
        this.buffer.append("SET ");
        if (set.getEffectParameter() != null) {
            this.buffer.append(set.getEffectParameter()).append(" ");
        }
        for (int i = 0; i < set.getCount(); ++i) {
            if (i > 0) {
                this.buffer.append(", ");
            }
            this.buffer.append(set.getName(i));
            if (set.isUseEqual(i)) {
                this.buffer.append(" =");
            }
            this.buffer.append(" ");
            List<Expression> expressions = set.getExpressions(i);
            for (int j = 0; j < expressions.size(); ++j) {
                if (j > 0) {
                    this.buffer.append(", ");
                }
                expressions.get(j).accept(this.expressionVisitor);
            }
        }
    }

    public ExpressionVisitor getExpressionVisitor() {
        return this.expressionVisitor;
    }

    public void setExpressionVisitor(ExpressionVisitor visitor) {
        this.expressionVisitor = visitor;
    }
}

