/*
 * Decompiled with CFR 0.152.
 */
package com.sqlparser.util.deparser;

import com.sqlparser.statement.Block;
import com.sqlparser.statement.Commit;
import com.sqlparser.statement.CreateFunctionalStatement;
import com.sqlparser.statement.DeclareStatement;
import com.sqlparser.statement.DescribeStatement;
import com.sqlparser.statement.ExplainStatement;
import com.sqlparser.statement.IfElseStatement;
import com.sqlparser.statement.PurgeStatement;
import com.sqlparser.statement.ResetStatement;
import com.sqlparser.statement.RollbackStatement;
import com.sqlparser.statement.SavepointStatement;
import com.sqlparser.statement.SetStatement;
import com.sqlparser.statement.ShowColumnsStatement;
import com.sqlparser.statement.ShowStatement;
import com.sqlparser.statement.Statement;
import com.sqlparser.statement.StatementVisitor;
import com.sqlparser.statement.Statements;
import com.sqlparser.statement.UnsupportedStatement;
import com.sqlparser.statement.UseStatement;
import com.sqlparser.statement.alter.Alter;
import com.sqlparser.statement.alter.AlterSession;
import com.sqlparser.statement.alter.AlterSystemStatement;
import com.sqlparser.statement.alter.RenameTableStatement;
import com.sqlparser.statement.alter.sequence.AlterSequence;
import com.sqlparser.statement.analyze.Analyze;
import com.sqlparser.statement.comment.Comment;
import com.sqlparser.statement.create.index.CreateIndex;
import com.sqlparser.statement.create.schema.CreateSchema;
import com.sqlparser.statement.create.sequence.CreateSequence;
import com.sqlparser.statement.create.synonym.CreateSynonym;
import com.sqlparser.statement.create.table.CreateTable;
import com.sqlparser.statement.create.view.AlterView;
import com.sqlparser.statement.create.view.CreateView;
import com.sqlparser.statement.delete.Delete;
import com.sqlparser.statement.drop.Drop;
import com.sqlparser.statement.execute.Execute;
import com.sqlparser.statement.grant.Grant;
import com.sqlparser.statement.insert.Insert;
import com.sqlparser.statement.merge.Merge;
import com.sqlparser.statement.merge.MergeInsert;
import com.sqlparser.statement.merge.MergeUpdate;
import com.sqlparser.statement.refresh.RefreshMaterializedViewStatement;
import com.sqlparser.statement.select.Select;
import com.sqlparser.statement.select.WithItem;
import com.sqlparser.statement.show.ShowIndexStatement;
import com.sqlparser.statement.show.ShowTablesStatement;
import com.sqlparser.statement.truncate.Truncate;
import com.sqlparser.statement.update.Update;
import com.sqlparser.statement.upsert.Upsert;
import com.sqlparser.util.deparser.AbstractDeParser;
import com.sqlparser.util.deparser.AlterDeParser;
import com.sqlparser.util.deparser.AlterSequenceDeParser;
import com.sqlparser.util.deparser.AlterSessionDeParser;
import com.sqlparser.util.deparser.AlterViewDeParser;
import com.sqlparser.util.deparser.CreateIndexDeParser;
import com.sqlparser.util.deparser.CreateSequenceDeParser;
import com.sqlparser.util.deparser.CreateSynonymDeparser;
import com.sqlparser.util.deparser.CreateTableDeParser;
import com.sqlparser.util.deparser.CreateViewDeParser;
import com.sqlparser.util.deparser.DeclareStatementDeParser;
import com.sqlparser.util.deparser.DeleteDeParser;
import com.sqlparser.util.deparser.DropDeParser;
import com.sqlparser.util.deparser.ExecuteDeParser;
import com.sqlparser.util.deparser.ExpressionDeParser;
import com.sqlparser.util.deparser.GrantDeParser;
import com.sqlparser.util.deparser.InsertDeParser;
import com.sqlparser.util.deparser.RefreshMaterializedViewStatementDeParser;
import com.sqlparser.util.deparser.ResetStatementDeParser;
import com.sqlparser.util.deparser.SelectDeParser;
import com.sqlparser.util.deparser.SetStatementDeParser;
import com.sqlparser.util.deparser.ShowColumnsStatementDeParser;
import com.sqlparser.util.deparser.ShowIndexStatementDeParser;
import com.sqlparser.util.deparser.ShowStatementDeParser;
import com.sqlparser.util.deparser.ShowTablesStatementDeparser;
import com.sqlparser.util.deparser.UpdateDeParser;
import com.sqlparser.util.deparser.UpsertDeParser;
import com.sqlparser.util.deparser.UseStatementDeParser;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class StatementDeParser
extends AbstractDeParser<Statement>
implements StatementVisitor {
    private final ExpressionDeParser expressionDeParser;
    private final SelectDeParser selectDeParser;

    public StatementDeParser(StringBuilder buffer) {
        this(new ExpressionDeParser(), new SelectDeParser(), buffer);
    }

    public StatementDeParser(ExpressionDeParser expressionDeParser, SelectDeParser selectDeParser, StringBuilder buffer) {
        super(buffer);
        this.expressionDeParser = expressionDeParser;
        this.selectDeParser = selectDeParser;
        this.selectDeParser.setBuffer(buffer);
        this.selectDeParser.setExpressionVisitor(expressionDeParser);
        this.expressionDeParser.setSelectVisitor(selectDeParser);
        this.expressionDeParser.setBuffer(buffer);
    }

    @Override
    public void visit(CreateIndex createIndex) {
        CreateIndexDeParser createIndexDeParser = new CreateIndexDeParser(this.buffer);
        createIndexDeParser.deParse(createIndex);
    }

    @Override
    public void visit(CreateTable createTable) {
        CreateTableDeParser createTableDeParser = new CreateTableDeParser(this, this.buffer);
        createTableDeParser.deParse(createTable);
    }

    @Override
    public void visit(CreateView createView) {
        CreateViewDeParser createViewDeParser = new CreateViewDeParser(this.buffer);
        createViewDeParser.deParse(createView);
    }

    @Override
    public void visit(RefreshMaterializedViewStatement materializedViewStatement) {
        new RefreshMaterializedViewStatementDeParser(this.buffer).deParse(materializedViewStatement);
    }

    @Override
    public void visit(AlterView alterView) {
        AlterViewDeParser alterViewDeParser = new AlterViewDeParser(this.buffer);
        alterViewDeParser.deParse(alterView);
    }

    @Override
    public void visit(Delete delete) {
        DeleteDeParser deleteDeParser = new DeleteDeParser(this.expressionDeParser, this.buffer);
        deleteDeParser.deParse(delete);
    }

    @Override
    public void visit(Drop drop) {
        DropDeParser dropDeParser = new DropDeParser(this.buffer);
        dropDeParser.deParse(drop);
    }

    @Override
    public void visit(Insert insert) {
        InsertDeParser insertDeParser = new InsertDeParser(this.expressionDeParser, this.selectDeParser, this.buffer);
        insertDeParser.deParse(insert);
    }

    @Override
    public void visit(Select select) {
        select.accept(this.selectDeParser);
    }

    @Override
    public void visit(Truncate truncate) {
        this.buffer.append("TRUNCATE");
        if (truncate.isTableToken()) {
            this.buffer.append(" TABLE");
        }
        if (truncate.isOnly()) {
            this.buffer.append(" ONLY");
        }
        this.buffer.append(" ");
        this.buffer.append(truncate.getTable());
        if (truncate.getCascade()) {
            this.buffer.append(" CASCADE");
        }
    }

    @Override
    public void visit(Update update) {
        UpdateDeParser updateDeParser = new UpdateDeParser(this.expressionDeParser, this.buffer);
        updateDeParser.deParse(update);
    }

    @Override
    public void visit(Analyze analyzer) {
        this.buffer.append("ANALYZE ");
        this.buffer.append(analyzer.getTable());
    }

    @Override
    public void visit(Alter alter) {
        AlterDeParser alterDeParser = new AlterDeParser(this.buffer);
        alterDeParser.deParse(alter);
    }

    @Override
    public void visit(Statements stmts) {
        stmts.accept(this);
    }

    @Override
    public void visit(Execute execute) {
        ExecuteDeParser executeDeParser = new ExecuteDeParser(this.expressionDeParser, this.buffer);
        executeDeParser.deParse(execute);
    }

    @Override
    public void visit(SetStatement set) {
        SetStatementDeParser setStatementDeparser = new SetStatementDeParser(this.expressionDeParser, this.buffer);
        setStatementDeparser.deParse(set);
    }

    @Override
    public void visit(ResetStatement reset) {
        ResetStatementDeParser setStatementDeparser = new ResetStatementDeParser(this.expressionDeParser, this.buffer);
        setStatementDeparser.deParse(reset);
    }

    @Override
    public void visit(Merge merge) {
        List<WithItem> withItemsList = merge.getWithItemsList();
        if (withItemsList != null && !withItemsList.isEmpty()) {
            this.buffer.append("WITH ");
            Iterator<WithItem> iter = withItemsList.iterator();
            while (iter.hasNext()) {
                iter.next().accept(this.expressionDeParser);
                if (iter.hasNext()) {
                    this.buffer.append(",");
                }
                this.buffer.append(" ");
            }
        }
        this.buffer.append("MERGE ");
        if (merge.getOracleHint() != null) {
            this.buffer.append(merge.getOracleHint()).append(" ");
        }
        this.buffer.append("INTO ");
        merge.getTable().accept(this.selectDeParser);
        this.buffer.append(" USING ");
        merge.getFromItem().accept(this.selectDeParser);
        this.buffer.append(" ON ");
        merge.getOnCondition().accept(this.expressionDeParser);
        MergeInsert mergeInsert = merge.getMergeInsert();
        MergeUpdate mergeUpdate = merge.getMergeUpdate();
        if (merge.isInsertFirst() && mergeInsert != null) {
            this.deparseMergeInsert(mergeInsert);
        }
        if (mergeUpdate != null) {
            this.buffer.append(" WHEN MATCHED");
            if (mergeUpdate.getAndPredicate() != null) {
                this.buffer.append(" AND ");
                mergeUpdate.getAndPredicate().accept(this.expressionDeParser);
            }
            this.buffer.append(" THEN UPDATE SET ");
            StatementDeParser.deparseUpdateSets(mergeUpdate.getUpdateSets(), this.buffer, this.expressionDeParser);
            if (mergeUpdate.getWhereCondition() != null) {
                this.buffer.append(" WHERE ");
                mergeUpdate.getWhereCondition().accept(this.expressionDeParser);
            }
            if (mergeUpdate.getDeleteWhereCondition() != null) {
                this.buffer.append(" DELETE WHERE ");
                mergeUpdate.getDeleteWhereCondition().accept(this.expressionDeParser);
            }
        }
        if (!merge.isInsertFirst() && mergeInsert != null) {
            this.deparseMergeInsert(mergeInsert);
        }
        if (merge.getOutputClause() != null) {
            merge.getOutputClause().appendTo(this.buffer);
        }
    }

    private void deparseMergeInsert(MergeInsert mergeInsert) {
        this.buffer.append(" WHEN NOT MATCHED");
        if (mergeInsert.getAndPredicate() != null) {
            this.buffer.append(" AND ");
            mergeInsert.getAndPredicate().accept(this.expressionDeParser);
        }
        this.buffer.append(" THEN INSERT ");
        if (mergeInsert.getColumns() != null) {
            mergeInsert.getColumns().accept(this.expressionDeParser);
        }
        this.buffer.append(" VALUES ");
        mergeInsert.getValues().accept(this.expressionDeParser);
        if (mergeInsert.getWhereCondition() != null) {
            this.buffer.append(" WHERE ");
            mergeInsert.getWhereCondition().accept(this.expressionDeParser);
        }
    }

    @Override
    public void visit(SavepointStatement savepointStatement) {
        this.buffer.append(savepointStatement.toString());
    }

    @Override
    public void visit(RollbackStatement rollbackStatement) {
        this.buffer.append(rollbackStatement.toString());
    }

    @Override
    public void visit(Commit commit) {
        this.buffer.append(commit.toString());
    }

    @Override
    public void visit(Upsert upsert) {
        UpsertDeParser upsertDeParser = new UpsertDeParser(this.expressionDeParser, this.selectDeParser, this.buffer);
        upsertDeParser.deParse(upsert);
    }

    @Override
    public void visit(UseStatement use) {
        new UseStatementDeParser(this.buffer).deParse(use);
    }

    @Override
    public void visit(ShowColumnsStatement show) {
        new ShowColumnsStatementDeParser(this.buffer).deParse(show);
    }

    @Override
    public void visit(ShowIndexStatement showIndexes) {
        new ShowIndexStatementDeParser(this.buffer).deParse(showIndexes);
    }

    @Override
    public void visit(ShowTablesStatement showTables) {
        new ShowTablesStatementDeparser(this.buffer).deParse(showTables);
    }

    @Override
    public void visit(Block block) {
        this.buffer.append("BEGIN\n");
        if (block.getStatements() != null) {
            for (Statement stmt : block.getStatements().getStatements()) {
                stmt.accept(this);
                this.buffer.append(";\n");
            }
        }
        this.buffer.append("END");
        if (block.hasSemicolonAfterEnd()) {
            this.buffer.append(";");
        }
    }

    @Override
    public void visit(Comment comment) {
        this.buffer.append(comment.toString());
    }

    @Override
    public void visit(DescribeStatement describe) {
        this.buffer.append(describe.getDescribeType());
        this.buffer.append(" ");
        this.buffer.append(describe.getTable());
    }

    @Override
    public void visit(ExplainStatement explain) {
        this.buffer.append("EXPLAIN ");
        if (explain.getTable() != null) {
            this.buffer.append(explain.getTable());
        } else if (explain.getOptions() != null) {
            this.buffer.append(explain.getOptions().values().stream().map(ExplainStatement.Option::formatOption).collect(Collectors.joining(" ")));
            this.buffer.append(" ");
        }
        if (explain.getStatement() != null) {
            explain.getStatement().accept(this);
        }
    }

    @Override
    public void visit(ShowStatement show) {
        new ShowStatementDeParser(this.buffer).deParse(show);
    }

    @Override
    public void visit(DeclareStatement declare) {
        new DeclareStatementDeParser(this.expressionDeParser, this.buffer).deParse(declare);
    }

    @Override
    public void visit(Grant grant) {
        GrantDeParser grantDeParser = new GrantDeParser(this.buffer);
        grantDeParser.deParse(grant);
    }

    @Override
    public void visit(CreateSchema aThis) {
        this.buffer.append(aThis.toString());
    }

    @Override
    public void visit(CreateSequence createSequence) {
        new CreateSequenceDeParser(this.buffer).deParse(createSequence);
    }

    @Override
    public void visit(AlterSequence alterSequence) {
        new AlterSequenceDeParser(this.buffer).deParse(alterSequence);
    }

    @Override
    public void visit(CreateFunctionalStatement createFunctionalStatement) {
        this.buffer.append(createFunctionalStatement.toString());
    }

    @Override
    public void visit(CreateSynonym createSynonym) {
        new CreateSynonymDeparser(this.buffer).deParse(createSynonym);
    }

    @Override
    void deParse(Statement statement) {
        statement.accept(this);
    }

    @Override
    public void visit(AlterSession alterSession) {
        new AlterSessionDeParser(this.buffer).deParse(alterSession);
    }

    @Override
    public void visit(IfElseStatement ifElseStatement) {
        ifElseStatement.appendTo(this.buffer);
    }

    @Override
    public void visit(RenameTableStatement renameTableStatement) {
        renameTableStatement.appendTo(this.buffer);
    }

    @Override
    public void visit(PurgeStatement purgeStatement) {
        purgeStatement.appendTo(this.buffer);
    }

    @Override
    public void visit(AlterSystemStatement alterSystemStatement) {
        alterSystemStatement.appendTo(this.buffer);
    }

    @Override
    public void visit(UnsupportedStatement unsupportedStatement) {
        unsupportedStatement.appendTo(this.buffer);
    }
}

