/*
 * Decompiled with CFR 0.152.
 */
package com.sqlparser.util.deparser;

import com.sqlparser.expression.ExpressionVisitor;
import com.sqlparser.expression.ExpressionVisitorAdapter;
import com.sqlparser.statement.select.Join;
import com.sqlparser.statement.select.OrderByElement;
import com.sqlparser.statement.select.OrderByVisitor;
import com.sqlparser.statement.select.WithItem;
import com.sqlparser.statement.update.Update;
import com.sqlparser.util.deparser.AbstractDeParser;
import com.sqlparser.util.deparser.LimitDeparser;
import com.sqlparser.util.deparser.OrderByDeParser;
import java.util.Iterator;

public class UpdateDeParser
extends AbstractDeParser<Update>
implements OrderByVisitor {
    private ExpressionVisitor expressionVisitor = new ExpressionVisitorAdapter();

    public UpdateDeParser() {
        super(new StringBuilder());
    }

    public UpdateDeParser(ExpressionVisitor expressionVisitor, StringBuilder buffer) {
        super(buffer);
        this.expressionVisitor = expressionVisitor;
    }

    @Override
    public void deParse(Update update) {
        if (update.getWithItemsList() != null && !update.getWithItemsList().isEmpty()) {
            this.buffer.append("WITH ");
            Iterator<WithItem> iter = update.getWithItemsList().iterator();
            while (iter.hasNext()) {
                WithItem withItem = iter.next();
                this.buffer.append(withItem);
                if (iter.hasNext()) {
                    this.buffer.append(",");
                }
                this.buffer.append(" ");
            }
        }
        this.buffer.append("UPDATE ");
        if (update.getOracleHint() != null) {
            this.buffer.append(update.getOracleHint()).append(" ");
        }
        if (update.getModifierPriority() != null) {
            this.buffer.append((Object)update.getModifierPriority()).append(" ");
        }
        if (update.isModifierIgnore()) {
            this.buffer.append("IGNORE ");
        }
        this.buffer.append(update.getTable());
        if (update.getStartJoins() != null) {
            for (Join join : update.getStartJoins()) {
                if (join.isSimple()) {
                    this.buffer.append(", ").append(join);
                    continue;
                }
                this.buffer.append(" ").append(join);
            }
        }
        this.buffer.append(" SET ");
        UpdateDeParser.deparseUpdateSets(update.getUpdateSets(), this.buffer, this.expressionVisitor);
        if (update.getOutputClause() != null) {
            update.getOutputClause().appendTo(this.buffer);
        }
        if (update.getFromItem() != null) {
            this.buffer.append(" FROM ").append(update.getFromItem());
            if (update.getJoins() != null) {
                for (Join join : update.getJoins()) {
                    if (join.isSimple()) {
                        this.buffer.append(", ").append(join);
                        continue;
                    }
                    this.buffer.append(" ").append(join);
                }
            }
        }
        if (update.getWhere() != null) {
            this.buffer.append(" WHERE ");
            update.getWhere().accept(this.expressionVisitor);
        }
        if (update.getOrderByElements() != null) {
            new OrderByDeParser(this.expressionVisitor, this.buffer).deParse(update.getOrderByElements());
        }
        if (update.getLimit() != null) {
            new LimitDeparser(this.expressionVisitor, this.buffer).deParse(update.getLimit());
        }
        if (update.getReturningClause() != null) {
            update.getReturningClause().appendTo(this.buffer);
        }
    }

    public ExpressionVisitor getExpressionVisitor() {
        return this.expressionVisitor;
    }

    public void setExpressionVisitor(ExpressionVisitor visitor) {
        this.expressionVisitor = visitor;
    }

    @Override
    public void visit(OrderByElement orderBy) {
        orderBy.getExpression().accept(this.expressionVisitor);
        if (!orderBy.isAsc()) {
            this.buffer.append(" DESC");
        } else if (orderBy.isAscDescPresent()) {
            this.buffer.append(" ASC");
        }
        if (orderBy.getNullOrdering() != null) {
            this.buffer.append(' ');
            this.buffer.append(orderBy.getNullOrdering() == OrderByElement.NullOrdering.NULLS_FIRST ? "NULLS FIRST" : "NULLS LAST");
        }
    }
}

