/*
 * Decompiled with CFR 0.152.
 */
package com.sqlparser.util.validation;

import com.sqlparser.parser.feature.FeatureConfiguration;
import com.sqlparser.statement.Statement;
import com.sqlparser.statement.Statements;
import com.sqlparser.util.validation.ParseCapability;
import com.sqlparser.util.validation.ValidationCapability;
import com.sqlparser.util.validation.ValidationContext;
import com.sqlparser.util.validation.ValidationError;
import com.sqlparser.util.validation.ValidationException;
import com.sqlparser.util.validation.validator.StatementValidator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Validation {
    private FeatureConfiguration featureConfiguration;
    private Collection<? extends ValidationCapability> capabilities;
    private List<String> statementsList;
    private List<ValidationError> errors;
    private Statements parsedStatements;

    public Validation(Collection<? extends ValidationCapability> capabilities, String ... statements) {
        this(new FeatureConfiguration(), capabilities, statements);
    }

    public Validation(FeatureConfiguration featureConfiguration, Collection<? extends ValidationCapability> capabilities, String ... statements) {
        this.featureConfiguration = featureConfiguration;
        this.capabilities = capabilities;
        this.statementsList = Arrays.asList(statements);
    }

    public List<ValidationError> validate() {
        this.errors = new ArrayList<ValidationError>();
        ValidationContext context = Validation.createValidationContext(this.featureConfiguration, this.capabilities);
        for (String statements : this.statementsList) {
            ParseCapability parse = new ParseCapability(statements);
            parse.validate(context, e -> this.errors.add(new ValidationError(statements).withCapability(parse).addError((ValidationException)e)));
            this.parsedStatements = parse.getParsedStatements();
            if (this.parsedStatements == null || this.parsedStatements.getStatements() == null || this.capabilities.isEmpty()) continue;
            for (Statement parsedStatement : this.parsedStatements.getStatements()) {
                Map<ValidationCapability, Set<ValidationException>> errorMap = Validation.validate(parsedStatement, context);
                this.errors.addAll(Validation.toValidationErrors(statements, parsedStatement, errorMap));
            }
        }
        return this.errors;
    }

    public FeatureConfiguration getFeatureConfiguration() {
        return this.featureConfiguration;
    }

    public Collection<? extends ValidationCapability> getCapabilities() {
        return this.capabilities;
    }

    public List<String> getStatements() {
        return this.statementsList;
    }

    public List<ValidationError> getErrors() {
        return this.errors;
    }

    public Statements getParsedStatements() {
        return this.parsedStatements;
    }

    public static List<ValidationError> validate(Collection<? extends ValidationCapability> capabilities, String ... statements) {
        return new Validation(capabilities, statements).validate();
    }

    public static ValidationContext createValidationContext(FeatureConfiguration config, Collection<? extends ValidationCapability> capabilities) {
        ValidationContext context = new ValidationContext();
        context.setCapabilities(new ArrayList<ValidationCapability>(capabilities));
        context.setConfiguration(config);
        return context;
    }

    public static List<ValidationError> toValidationErrors(String statements, Statement parsedStatement, Map<ValidationCapability, Set<ValidationException>> errorMap) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        for (Map.Entry<ValidationCapability, Set<ValidationException>> e : errorMap.entrySet()) {
            errors.add(new ValidationError(statements).withParsedStatement(parsedStatement).withCapability(e.getKey()).addErrors((Collection<ValidationException>)e.getValue()));
        }
        return errors;
    }

    public static Map<ValidationCapability, Set<ValidationException>> validate(Statement statement, ValidationContext context) {
        StatementValidator validator = new StatementValidator();
        validator.setContext(context);
        validator.validate(statement);
        return validator.getValidationErrors();
    }
}

