/*
 * Decompiled with CFR 0.152.
 */
package com.sqlparser.util.validation;

import com.sqlparser.parser.feature.Feature;
import com.sqlparser.parser.feature.FeatureConfiguration;
import com.sqlparser.util.validation.ContextKey;
import com.sqlparser.util.validation.ValidationCapability;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ValidationContext {
    private Collection<ValidationCapability> capabilities;
    private FeatureConfiguration configuration = new FeatureConfiguration();
    private Map<ContextKey, Object> contextMap = new HashMap<ContextKey, Object>();

    public ValidationContext put(ContextKey key, Object value) {
        this.contextMap.put(key, value);
        return this;
    }

    public <T> T get(ContextKey key, Class<T> type) {
        T t = this.getOptional(key, type);
        if (t == null) {
            throw new IllegalStateException(key + ": value missing");
        }
        return t;
    }

    public <T> T getOptional(ContextKey key, Class<T> type) {
        return type.cast(this.contextMap.get(key));
    }

    public ValidationContext reinit(boolean reInit) {
        if (reInit) {
            this.contextMap.clear();
        }
        return this;
    }

    public ValidationContext setConfiguration(FeatureConfiguration configuration) {
        this.configuration = configuration;
        return this;
    }

    public FeatureConfiguration getConfiguration() {
        return this.configuration;
    }

    public boolean getAsBoolean(Feature f) {
        return this.getConfiguration().getAsBoolean(f);
    }

    public String getAsString(Feature f) {
        return this.getConfiguration().getAsString(f);
    }

    public Collection<ValidationCapability> getCapabilities() {
        return this.capabilities;
    }

    public ValidationContext setCapabilities(Collection<ValidationCapability> capabilities) {
        this.capabilities = capabilities;
        return this;
    }
}

