/*
 * Decompiled with CFR 0.152.
 */
package com.sqlparser.util.validation.feature;

import com.sqlparser.parser.feature.Feature;
import com.sqlparser.util.validation.feature.DatabaseType;
import com.sqlparser.util.validation.feature.Version;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

public enum H2Version implements Version
{
    V_1_4_200("1.4.200", EnumSet.of(Feature.jdbcParameter, new Feature[]{Feature.jdbcNamedParameter, Feature.exprLike, Feature.select, Feature.selectGroupBy, Feature.function, Feature.selectHaving, Feature.join, Feature.joinSimple, Feature.joinRight, Feature.joinFull, Feature.joinLeft, Feature.joinCross, Feature.joinOuter, Feature.joinInner, Feature.joinNatural, Feature.joinUsingColumns, Feature.orderBy, Feature.orderByNullOrdering, Feature.withItem, Feature.withItemRecursive, Feature.comment, Feature.commentOnTable, Feature.commentOnColumn, Feature.commentOnView, Feature.tableFunction, Feature.setOperation, Feature.setOperationUnion, Feature.setOperationIntersect, Feature.setOperationExcept, Feature.setOperationMinus, Feature.createSequence, Feature.alterSequence, Feature.createSchema, Feature.createIndex, Feature.createTable, Feature.createTableCreateOptionStrings, Feature.createTableTableOptionStrings, Feature.createTableFromSelect, Feature.createTableIfNotExists, Feature.createView, Feature.createViewForce, Feature.createOrReplaceView, Feature.top, Feature.fetch, Feature.fetchFirst, Feature.distinct, Feature.distinctOn, Feature.insert, Feature.insertValues, Feature.values, Feature.insertFromSelect, Feature.update, Feature.delete, Feature.truncate, Feature.executeStatementImmediate, Feature.drop, Feature.dropTable, Feature.dropIndex, Feature.dropView, Feature.dropSchema, Feature.dropSequence, Feature.dropTableIfExists, Feature.dropIndexIfExists, Feature.dropViewIfExists, Feature.dropSchemaIfExists, Feature.dropSequenceIfExists, Feature.alterTable, Feature.explain, Feature.grant, Feature.commit}));

    private Set<Feature> features;
    private String versionString;

    private H2Version(String versionString, Set<Feature> featuresSupported) {
        this(versionString, featuresSupported, Collections.emptySet());
    }

    private H2Version(String versionString, Set<Feature> featuresSupported, Set<Feature> unsupported) {
        this.versionString = versionString;
        this.features = featuresSupported;
        this.features.removeAll(unsupported);
    }

    @Override
    public String getVersionString() {
        return this.versionString;
    }

    @Override
    public Set<Feature> getFeatures() {
        return this.features;
    }

    @Override
    public String getName() {
        return DatabaseType.H2.getName() + " " + this.getVersionString();
    }
}

