/*
 * Decompiled with CFR 0.152.
 */
package com.sqlparser.util.validation.metadata;

import com.sqlparser.util.validation.UnexpectedValidationException;
import com.sqlparser.util.validation.ValidationCapability;
import com.sqlparser.util.validation.ValidationContext;
import com.sqlparser.util.validation.ValidationException;
import com.sqlparser.util.validation.metadata.MetadataContext;
import com.sqlparser.util.validation.metadata.Named;
import java.util.function.Consumer;

public interface DatabaseMetaDataValidation
extends ValidationCapability {
    public static final String NAME = "meta data";

    @Override
    default public void validate(ValidationContext context, Consumer<ValidationException> errorConsumer) {
        Named named = context.get(MetadataContext.named, Named.class);
        boolean checkForExists = context.get(MetadataContext.exists, Boolean.class);
        try {
            boolean exists = this.exists(named);
            if (exists ^ checkForExists) {
                errorConsumer.accept(this.getErrorMessage(named, checkForExists));
            }
        }
        catch (ValidationException ve) {
            errorConsumer.accept(ve);
        }
        catch (UnsupportedOperationException uoe) {
            errorConsumer.accept(new ValidationException("This Operation " + named.toString() + "  is not supported yet.", uoe));
        }
        catch (Exception e) {
            errorConsumer.accept(this.getUnexpectedErrorMessage(named, e));
        }
    }

    public boolean exists(Named var1);

    default public ValidationException getErrorMessage(Named named, boolean checkForExists) {
        return this.toError(String.format("%s does %sexist.", named.getFqn(), checkForExists ? "not " : ""));
    }

    default public ValidationException getUnexpectedErrorMessage(Named named, Exception cause) {
        return new UnexpectedValidationException(named.getFqn() + ": cannot validate " + (Object)((Object)named.getNamedObject()) + "-name. detail: " + cause.getMessage(), cause);
    }

    @Override
    default public String getName() {
        return NAME;
    }
}

