/*
 * Decompiled with CFR 0.152.
 */
package com.sqlparser.util.validation.validator;

import com.sqlparser.parser.feature.Feature;
import com.sqlparser.statement.alter.Alter;
import com.sqlparser.statement.alter.AlterExpression;
import com.sqlparser.statement.alter.AlterOperation;
import com.sqlparser.statement.create.table.ColumnDefinition;
import com.sqlparser.util.validation.ValidationCapability;
import com.sqlparser.util.validation.ValidationUtil;
import com.sqlparser.util.validation.metadata.NamedObject;
import com.sqlparser.util.validation.validator.AbstractValidator;
import java.util.EnumSet;

public class AlterValidator
extends AbstractValidator<Alter> {
    @Override
    public void validate(Alter alter) {
        this.validateFeature(Feature.alterTable);
        this.validateOptionalFromItem(alter.getTable());
        alter.getAlterExpressions().forEach(e -> this.validate(alter, (AlterExpression)e));
    }

    public void validate(Alter alter, AlterExpression e) {
        for (ValidationCapability c : this.getCapabilities()) {
            this.validateOptionalColumnName(c, e.getColumnOldName());
            this.validateOptionalColumnName(c, e.getColumnName());
            if (e.getColumnDropNotNullList() != null) {
                this.validateOptionalColumnNames(c, ValidationUtil.map(e.getColumnDropNotNullList(), AlterExpression.ColumnDropNotNull::getColumnName), new NamedObject[0]);
            }
            if (e.getColDataTypeList() != null) {
                boolean validateForExist = !EnumSet.of(AlterOperation.ADD).contains(e.getOperation());
                this.validateOptionalColumnNames(c, ValidationUtil.map(e.getColDataTypeList(), ColumnDefinition::getColumnName), validateForExist, NamedObject.table);
            }
            this.validateOptionalName(c, NamedObject.constraint, e.getConstraintName(), new NamedObject[0]);
            if (e.getPkColumns() != null) {
                this.validateOptionalColumnNames(c, e.getPkColumns(), new NamedObject[0]);
            }
            if (e.getFkColumns() != null) {
                this.validateName(c, NamedObject.table, e.getFkSourceTable());
                this.validateOptionalColumnNames(c, e.getFkColumns(), new NamedObject[0]);
                this.validateOptionalColumnNames(c, e.getFkSourceColumns(), new NamedObject[0]);
            }
            if (e.getUk()) {
                this.validateName(c, NamedObject.uniqueConstraint, e.getUkName());
                this.validateOptionalColumnNames(c, e.getUkColumns(), NamedObject.uniqueConstraint);
            }
            if (e.getIndex() == null) continue;
            this.validateName(c, NamedObject.index, e.getIndex().getName());
            if (e.getIndex().getColumns() == null) continue;
            this.validateOptionalColumnNames(c, e.getIndex().getColumnsNames(), NamedObject.index);
        }
    }
}

