/*
 * Decompiled with CFR 0.152.
 */
package com.sqlparser.util.validation.validator;

import com.sqlparser.parser.feature.Feature;
import com.sqlparser.statement.create.table.CreateTable;
import com.sqlparser.statement.create.table.Index;
import com.sqlparser.util.validation.ValidationCapability;
import com.sqlparser.util.validation.metadata.NamedObject;
import com.sqlparser.util.validation.validator.AbstractValidator;
import com.sqlparser.util.validation.validator.StatementValidator;

public class CreateTableValidator
extends AbstractValidator<CreateTable> {
    @Override
    public void validate(CreateTable createTable) {
        for (ValidationCapability c : this.getCapabilities()) {
            this.validateFeature(c, Feature.createTable);
            this.validateFeature(c, createTable.isUnlogged(), Feature.createTableUnlogged);
            this.validateOptionalFeature(c, createTable.getCreateOptionsStrings(), Feature.createTableCreateOptionStrings);
            this.validateOptionalFeature(c, createTable.getTableOptionsStrings(), Feature.createTableTableOptionStrings);
            this.validateFeature(c, createTable.isIfNotExists(), Feature.createTableIfNotExists);
            this.validateOptionalFeature(c, createTable.getRowMovement(), Feature.createTableRowMovement);
            this.validateOptionalFeature(c, createTable.getSelect(), Feature.createTableFromSelect);
            if (this.isNotEmpty(createTable.getIndexes())) {
                for (Index i : createTable.getIndexes()) {
                    this.validateName(c, NamedObject.index, i.getName());
                }
            }
            this.validateName(c, NamedObject.table, createTable.getTable().getFullyQualifiedName(), false, new NamedObject[0]);
        }
        if (createTable.getSelect() != null) {
            this.getValidator(StatementValidator.class).validate(createTable.getSelect());
        }
    }
}

