/*
 * Decompiled with CFR 0.152.
 */
package com.sqlparser.util.validation.validator;

import com.sqlparser.parser.feature.Feature;
import com.sqlparser.statement.create.view.CreateView;
import com.sqlparser.statement.create.view.ForceOption;
import com.sqlparser.statement.create.view.TemporaryOption;
import com.sqlparser.statement.select.Select;
import com.sqlparser.util.validation.ValidationCapability;
import com.sqlparser.util.validation.metadata.NamedObject;
import com.sqlparser.util.validation.validator.AbstractValidator;
import com.sqlparser.util.validation.validator.SelectValidator;

public class CreateViewValidator
extends AbstractValidator<CreateView> {
    @Override
    public void validate(CreateView createView) {
        for (ValidationCapability c : this.getCapabilities()) {
            this.validateFeature(c, Feature.createView);
            this.validateFeature(c, createView.isOrReplace(), Feature.createOrReplaceView);
            this.validateFeature(c, !ForceOption.NONE.equals(createView.getForce()), Feature.createViewForce);
            this.validateFeature(c, !TemporaryOption.NONE.equals(createView.getTemporary()), Feature.createViewTemporary);
            this.validateFeature(c, createView.isMaterialized(), Feature.createViewMaterialized);
            this.validateName(c, NamedObject.view, createView.getView().getFullyQualifiedName(), false, new NamedObject[0]);
            this.validateFeature(c, createView.getViewCommentOptions() != null, Feature.createViewWithComment);
        }
        SelectValidator v = this.getValidator(SelectValidator.class);
        Select select = createView.getSelect();
        select.accept(v);
    }
}

