/*
 * Decompiled with CFR 0.152.
 */
package com.sqlparser.util.validation.validator;

import com.sqlparser.parser.feature.Feature;
import com.sqlparser.statement.drop.Drop;
import com.sqlparser.util.validation.ValidationCapability;
import com.sqlparser.util.validation.metadata.NamedObject;
import com.sqlparser.util.validation.validator.AbstractValidator;
import java.util.Arrays;

public class DropValidator
extends AbstractValidator<Drop> {
    @Override
    public void validate(Drop drop) {
        String type = drop.getType();
        for (ValidationCapability c : this.getCapabilities()) {
            this.validateFeature(c, Feature.drop);
            this.validateFeature(c, NamedObject.table.name().equalsIgnoreCase(type), Feature.dropTable);
            this.validateFeature(c, NamedObject.index.equalsIgnoreCase(type), Feature.dropIndex);
            this.validateFeature(c, NamedObject.view.equalsIgnoreCase(type), Feature.dropView);
            this.validateFeature(c, NamedObject.schema.equalsIgnoreCase(type), Feature.dropSchema);
            this.validateFeature(c, NamedObject.sequence.equalsIgnoreCase(type), Feature.dropSequence);
            this.validateFeature(c, drop.isIfExists() && NamedObject.table.name().equalsIgnoreCase(type), Feature.dropTableIfExists);
            this.validateFeature(c, drop.isIfExists() && NamedObject.index.equalsIgnoreCase(type), Feature.dropIndexIfExists);
            this.validateFeature(c, drop.isIfExists() && NamedObject.view.equalsIgnoreCase(type), Feature.dropViewIfExists);
            this.validateFeature(c, drop.isIfExists() && NamedObject.schema.equalsIgnoreCase(type), Feature.dropSchemaIfExists);
            this.validateFeature(c, drop.isIfExists() && NamedObject.sequence.equalsIgnoreCase(type), Feature.dropSequenceIfExists);
        }
        NamedObject named = NamedObject.forName(type);
        if (Arrays.asList(NamedObject.table, NamedObject.view).contains((Object)named)) {
            this.validateName(named, drop.getName().getFullyQualifiedName());
        }
    }
}

