/*
 * Decompiled with CFR 0.152.
 */
package com.sqlparser.util.validation.validator;

import com.sqlparser.expression.AllValue;
import com.sqlparser.expression.AnalyticExpression;
import com.sqlparser.expression.AnyComparisonExpression;
import com.sqlparser.expression.ArrayConstructor;
import com.sqlparser.expression.ArrayExpression;
import com.sqlparser.expression.BinaryExpression;
import com.sqlparser.expression.CaseExpression;
import com.sqlparser.expression.CastExpression;
import com.sqlparser.expression.CollateExpression;
import com.sqlparser.expression.ConnectByRootOperator;
import com.sqlparser.expression.DateTimeLiteralExpression;
import com.sqlparser.expression.DateValue;
import com.sqlparser.expression.DoubleValue;
import com.sqlparser.expression.Expression;
import com.sqlparser.expression.ExpressionVisitor;
import com.sqlparser.expression.ExtractExpression;
import com.sqlparser.expression.Function;
import com.sqlparser.expression.HexValue;
import com.sqlparser.expression.IntervalExpression;
import com.sqlparser.expression.JdbcNamedParameter;
import com.sqlparser.expression.JdbcParameter;
import com.sqlparser.expression.JsonAggregateFunction;
import com.sqlparser.expression.JsonExpression;
import com.sqlparser.expression.JsonFunction;
import com.sqlparser.expression.KeepExpression;
import com.sqlparser.expression.LongValue;
import com.sqlparser.expression.MySQLGroupConcat;
import com.sqlparser.expression.NextValExpression;
import com.sqlparser.expression.NotExpression;
import com.sqlparser.expression.NullValue;
import com.sqlparser.expression.NumericBind;
import com.sqlparser.expression.OracleHierarchicalExpression;
import com.sqlparser.expression.OracleHint;
import com.sqlparser.expression.OracleNamedFunctionParameter;
import com.sqlparser.expression.OverlapsCondition;
import com.sqlparser.expression.Parenthesis;
import com.sqlparser.expression.RangeExpression;
import com.sqlparser.expression.RowConstructor;
import com.sqlparser.expression.RowGetExpression;
import com.sqlparser.expression.SignedExpression;
import com.sqlparser.expression.StringValue;
import com.sqlparser.expression.TimeKeyExpression;
import com.sqlparser.expression.TimeValue;
import com.sqlparser.expression.TimestampValue;
import com.sqlparser.expression.TimezoneExpression;
import com.sqlparser.expression.TranscodingFunction;
import com.sqlparser.expression.TrimFunction;
import com.sqlparser.expression.UserVariable;
import com.sqlparser.expression.VariableAssignment;
import com.sqlparser.expression.WhenClause;
import com.sqlparser.expression.WindowElement;
import com.sqlparser.expression.WindowOffset;
import com.sqlparser.expression.WindowRange;
import com.sqlparser.expression.XMLSerializeExpr;
import com.sqlparser.expression.operators.arithmetic.Addition;
import com.sqlparser.expression.operators.arithmetic.BitwiseAnd;
import com.sqlparser.expression.operators.arithmetic.BitwiseLeftShift;
import com.sqlparser.expression.operators.arithmetic.BitwiseOr;
import com.sqlparser.expression.operators.arithmetic.BitwiseRightShift;
import com.sqlparser.expression.operators.arithmetic.BitwiseXor;
import com.sqlparser.expression.operators.arithmetic.Concat;
import com.sqlparser.expression.operators.arithmetic.Division;
import com.sqlparser.expression.operators.arithmetic.IntegerDivision;
import com.sqlparser.expression.operators.arithmetic.Modulo;
import com.sqlparser.expression.operators.arithmetic.Multiplication;
import com.sqlparser.expression.operators.arithmetic.Subtraction;
import com.sqlparser.expression.operators.conditional.AndExpression;
import com.sqlparser.expression.operators.conditional.OrExpression;
import com.sqlparser.expression.operators.conditional.XorExpression;
import com.sqlparser.expression.operators.relational.Between;
import com.sqlparser.expression.operators.relational.ContainedBy;
import com.sqlparser.expression.operators.relational.Contains;
import com.sqlparser.expression.operators.relational.DoubleAnd;
import com.sqlparser.expression.operators.relational.EqualsTo;
import com.sqlparser.expression.operators.relational.ExistsExpression;
import com.sqlparser.expression.operators.relational.ExpressionList;
import com.sqlparser.expression.operators.relational.FullTextSearch;
import com.sqlparser.expression.operators.relational.GeometryDistance;
import com.sqlparser.expression.operators.relational.GreaterThan;
import com.sqlparser.expression.operators.relational.GreaterThanEquals;
import com.sqlparser.expression.operators.relational.InExpression;
import com.sqlparser.expression.operators.relational.IsBooleanExpression;
import com.sqlparser.expression.operators.relational.IsDistinctExpression;
import com.sqlparser.expression.operators.relational.IsNullExpression;
import com.sqlparser.expression.operators.relational.JsonOperator;
import com.sqlparser.expression.operators.relational.LikeExpression;
import com.sqlparser.expression.operators.relational.Matches;
import com.sqlparser.expression.operators.relational.MemberOfExpression;
import com.sqlparser.expression.operators.relational.MinorThan;
import com.sqlparser.expression.operators.relational.MinorThanEquals;
import com.sqlparser.expression.operators.relational.NotEqualsTo;
import com.sqlparser.expression.operators.relational.OldOracleJoinBinaryExpression;
import com.sqlparser.expression.operators.relational.RegExpMatchOperator;
import com.sqlparser.expression.operators.relational.SimilarToExpression;
import com.sqlparser.expression.operators.relational.TSQLLeftJoin;
import com.sqlparser.expression.operators.relational.TSQLRightJoin;
import com.sqlparser.parser.feature.Feature;
import com.sqlparser.schema.Column;
import com.sqlparser.statement.select.AllColumns;
import com.sqlparser.statement.select.AllTableColumns;
import com.sqlparser.statement.select.ParenthesedSelect;
import com.sqlparser.statement.select.Select;
import com.sqlparser.util.validation.ValidationCapability;
import com.sqlparser.util.validation.metadata.NamedObject;
import com.sqlparser.util.validation.validator.AbstractValidator;

public class ExpressionValidator
extends AbstractValidator<Expression>
implements ExpressionVisitor {
    @Override
    public void visit(Addition addition) {
        this.visitBinaryExpression(addition, " + ");
    }

    @Override
    public void visit(AndExpression andExpression) {
        this.visitBinaryExpression(andExpression, andExpression.isUseOperator() ? " && " : " AND ");
    }

    @Override
    public void visit(Between between) {
        between.getLeftExpression().accept(this);
        between.getBetweenExpressionStart().accept(this);
        between.getBetweenExpressionEnd().accept(this);
    }

    @Override
    public void visit(OverlapsCondition overlapsCondition) {
        this.validateOptionalExpressionList(overlapsCondition.getLeft());
        this.validateOptionalExpressionList(overlapsCondition.getRight());
    }

    @Override
    public void visit(EqualsTo equalsTo) {
        this.visitOldOracleJoinBinaryExpression(equalsTo, " = ");
    }

    @Override
    public void visit(Division division) {
        this.visitBinaryExpression(division, " / ");
    }

    @Override
    public void visit(IntegerDivision division) {
        this.visitBinaryExpression(division, " DIV ");
    }

    @Override
    public void visit(DoubleValue doubleValue) {
    }

    @Override
    public void visit(HexValue hexValue) {
    }

    @Override
    public void visit(NotExpression notExpr) {
        notExpr.getExpression().accept(this);
    }

    @Override
    public void visit(BitwiseRightShift expr) {
        this.visitBinaryExpression(expr, " >> ");
    }

    @Override
    public void visit(BitwiseLeftShift expr) {
        this.visitBinaryExpression(expr, " << ");
    }

    public void visitOldOracleJoinBinaryExpression(OldOracleJoinBinaryExpression expression, String operator) {
        for (ValidationCapability c : this.getCapabilities()) {
            this.validateOptionalExpression(expression.getLeftExpression(), this);
            if (expression.getOldOracleJoinSyntax() != 0) {
                this.validateFeature(c, Feature.oracleOldJoinSyntax);
            }
            this.validateOptionalExpression(expression.getRightExpression(), this);
            if (expression.getOraclePriorPosition() == 0) continue;
            this.validateFeature(c, Feature.oraclePriorPosition);
        }
    }

    @Override
    public void visit(GreaterThan greaterThan) {
        this.visitOldOracleJoinBinaryExpression(greaterThan, " > ");
    }

    @Override
    public void visit(GreaterThanEquals greaterThanEquals) {
        this.visitOldOracleJoinBinaryExpression(greaterThanEquals, " >= ");
    }

    @Override
    public void visit(InExpression inExpression) {
        for (ValidationCapability c : this.getCapabilities()) {
            this.validateOptionalExpression(inExpression.getLeftExpression(), this);
            if (inExpression.getOldOracleJoinSyntax() == 0) continue;
            this.validateFeature(c, Feature.oracleOldJoinSyntax);
        }
        this.validateOptionalExpression(inExpression.getRightExpression(), this);
    }

    @Override
    public void visit(FullTextSearch fullTextSearch) {
        this.validateOptionalExpressions(fullTextSearch.getMatchColumns());
    }

    @Override
    public void visit(SignedExpression signedExpression) {
        signedExpression.getExpression().accept(this);
    }

    @Override
    public void visit(IsNullExpression isNullExpression) {
        isNullExpression.getLeftExpression().accept(this);
    }

    @Override
    public void visit(IsBooleanExpression isBooleanExpression) {
        isBooleanExpression.getLeftExpression().accept(this);
    }

    @Override
    public void visit(JdbcParameter jdbcParameter) {
        this.validateFeature(Feature.jdbcParameter);
    }

    @Override
    public void visit(LikeExpression likeExpression) {
        this.validateFeature(Feature.exprLike);
        this.visitBinaryExpression(likeExpression, (likeExpression.isNot() ? " NOT" : "") + (likeExpression.isCaseInsensitive() ? " ILIKE " : " LIKE "));
    }

    @Override
    public void visit(ExistsExpression existsExpression) {
        existsExpression.getRightExpression().accept(this);
    }

    @Override
    public void visit(MemberOfExpression memberOfExpression) {
        memberOfExpression.getLeftExpression().accept(this);
        memberOfExpression.getRightExpression().accept(this);
    }

    @Override
    public void visit(LongValue longValue) {
    }

    @Override
    public void visit(MinorThan minorThan) {
        this.visitOldOracleJoinBinaryExpression(minorThan, " < ");
    }

    @Override
    public void visit(MinorThanEquals minorThanEquals) {
        this.visitOldOracleJoinBinaryExpression(minorThanEquals, " <= ");
    }

    @Override
    public void visit(Multiplication multiplication) {
        this.visitBinaryExpression(multiplication, " * ");
    }

    @Override
    public void visit(NotEqualsTo notEqualsTo) {
        this.visitOldOracleJoinBinaryExpression(notEqualsTo, " " + notEqualsTo.getStringExpression() + " ");
    }

    @Override
    public void visit(DoubleAnd doubleAnd) {
    }

    @Override
    public void visit(Contains contains) {
    }

    @Override
    public void visit(ContainedBy containedBy) {
    }

    @Override
    public void visit(NullValue nullValue) {
    }

    @Override
    public void visit(OrExpression orExpression) {
        this.visitBinaryExpression(orExpression, " OR ");
    }

    @Override
    public void visit(XorExpression xorExpression) {
        this.visitBinaryExpression(xorExpression, " XOR ");
    }

    @Override
    public void visit(Parenthesis parenthesis) {
        parenthesis.getExpression().accept(this);
    }

    @Override
    public void visit(StringValue stringValue) {
    }

    @Override
    public void visit(Subtraction subtraction) {
        this.visitBinaryExpression(subtraction, " - ");
    }

    protected void visitBinaryExpression(BinaryExpression binaryExpression, String operator) {
        binaryExpression.getLeftExpression().accept(this);
        binaryExpression.getRightExpression().accept(this);
    }

    @Override
    public void visit(ParenthesedSelect selectBody) {
        this.validateOptionalFromItem(selectBody);
    }

    @Override
    public void visit(Column tableColumn) {
        this.validateName(NamedObject.column, tableColumn.getFullyQualifiedName());
    }

    @Override
    public void visit(Function function) {
        this.validateFeature(Feature.function);
        this.validateOptionalExpressionList(function.getNamedParameters());
        this.validateOptionalExpressionList(function.getParameters());
        Object attribute = function.getAttribute();
        if (attribute instanceof Expression) {
            this.validateOptionalExpression((Expression)attribute, this);
        }
        this.validateOptionalExpression(function.getKeep(), this);
        this.validateOptionalOrderByElements(function.getOrderByElements());
    }

    @Override
    public void visit(DateValue dateValue) {
    }

    @Override
    public void visit(TimestampValue timestampValue) {
    }

    @Override
    public void visit(TimeValue timeValue) {
    }

    @Override
    public void visit(CaseExpression caseExpression) {
        Expression switchExp = caseExpression.getSwitchExpression();
        if (switchExp != null) {
            switchExp.accept(this);
        }
        caseExpression.getWhenClauses().forEach(wc -> wc.accept(this));
        Expression elseExp = caseExpression.getElseExpression();
        if (elseExp != null) {
            elseExp.accept(this);
        }
    }

    @Override
    public void visit(WhenClause whenClause) {
        whenClause.getWhenExpression().accept(this);
        whenClause.getThenExpression().accept(this);
    }

    @Override
    public void visit(AnyComparisonExpression anyComparisonExpression) {
        anyComparisonExpression.getSelect().accept(this);
    }

    @Override
    public void visit(Concat concat) {
        this.visitBinaryExpression(concat, " || ");
    }

    @Override
    public void visit(Matches matches) {
        this.visitOldOracleJoinBinaryExpression(matches, " @@ ");
    }

    @Override
    public void visit(BitwiseAnd bitwiseAnd) {
        this.visitBinaryExpression(bitwiseAnd, " & ");
    }

    @Override
    public void visit(BitwiseOr bitwiseOr) {
        this.visitBinaryExpression(bitwiseOr, " | ");
    }

    @Override
    public void visit(BitwiseXor bitwiseXor) {
        this.visitBinaryExpression(bitwiseXor, " ^ ");
    }

    @Override
    public void visit(CastExpression cast) {
        cast.getLeftExpression().accept(this);
    }

    @Override
    public void visit(Modulo modulo) {
        this.visitBinaryExpression(modulo, " % ");
    }

    @Override
    public void visit(AnalyticExpression aexpr) {
        this.validateOptionalExpression(aexpr.getExpression(), this);
        this.validateOptionalExpression(aexpr.getOffset(), this);
        this.validateOptionalExpression(aexpr.getDefaultValue(), this);
        this.validateOptionalExpression(aexpr.getKeep(), this);
        this.validateOptionalExpressionList(aexpr.getPartitionExpressionList());
        this.validateOptionalOrderByElements(aexpr.getOrderByElements());
        WindowElement windowElement = aexpr.getWindowElement();
        if (windowElement != null) {
            this.validateOptionalWindowOffset(windowElement.getOffset());
            WindowRange range = windowElement.getRange();
            if (range != null) {
                this.validateOptionalWindowOffset(range.getStart());
                this.validateOptionalWindowOffset(range.getEnd());
            }
        }
        this.validateOptionalExpression(aexpr.getFilterExpression());
    }

    private void validateOptionalWindowOffset(WindowOffset offset) {
        if (offset != null) {
            this.validateOptionalExpression(offset.getExpression());
        }
    }

    @Override
    public void visit(ExtractExpression eexpr) {
        eexpr.getExpression().accept(this);
    }

    @Override
    public void visit(IntervalExpression iexpr) {
        this.validateOptionalExpression(iexpr.getExpression());
    }

    @Override
    public void visit(JdbcNamedParameter jdbcNamedParameter) {
        this.validateFeature(Feature.jdbcNamedParameter);
    }

    @Override
    public void visit(OracleHierarchicalExpression oexpr) {
        this.validateFeature(Feature.oracleHierarchicalExpression);
    }

    @Override
    public void visit(RegExpMatchOperator rexpr) {
        this.visitBinaryExpression(rexpr, " " + rexpr.getStringExpression() + " ");
    }

    @Override
    public void visit(JsonExpression jsonExpr) {
        this.validateOptionalExpression(jsonExpr.getExpression());
    }

    @Override
    public void visit(JsonOperator jsonExpr) {
        this.visitBinaryExpression(jsonExpr, " " + jsonExpr.getStringExpression() + " ");
    }

    @Override
    public void visit(UserVariable var) {
    }

    @Override
    public void visit(NumericBind bind) {
    }

    @Override
    public void visit(KeepExpression aexpr) {
        this.validateOptionalOrderByElements(aexpr.getOrderByElements());
    }

    @Override
    public void visit(MySQLGroupConcat groupConcat) {
        this.validateOptionalExpressionList(groupConcat.getExpressionList());
        this.validateOptionalOrderByElements(groupConcat.getOrderByElements());
    }

    private void validateOptionalExpressionList(ExpressionList<?> expressionList) {
        if (expressionList != null) {
            for (Expression expression : expressionList) {
                expression.accept(this);
            }
        }
    }

    @Override
    public void visit(ExpressionList<?> expressionList) {
        this.validateOptionalExpressionList(expressionList);
    }

    public void visit(RowConstructor rowConstructor) {
        this.validateOptionalExpressionList(rowConstructor);
    }

    @Override
    public void visit(RowGetExpression rowGetExpression) {
        rowGetExpression.getExpression().accept(this);
    }

    @Override
    public void visit(OracleHint hint) {
    }

    @Override
    public void visit(TimeKeyExpression timeKeyExpression) {
    }

    @Override
    public void visit(DateTimeLiteralExpression literal) {
    }

    @Override
    public void visit(NextValExpression nextVal) {
        this.validateName(NamedObject.sequence, nextVal.getName());
    }

    @Override
    public void visit(CollateExpression col) {
        this.validateOptionalExpression(col.getLeftExpression());
    }

    @Override
    public void visit(SimilarToExpression expr) {
        this.validateFeature(Feature.exprSimilarTo);
        this.visitBinaryExpression(expr, (expr.isNot() ? " NOT" : "") + " SIMILAR TO ");
    }

    @Override
    public void visit(ArrayExpression array) {
        array.getObjExpression().accept(this);
        if (array.getIndexExpression() != null) {
            array.getIndexExpression().accept(this);
        }
        if (array.getStartIndexExpression() != null) {
            array.getStartIndexExpression().accept(this);
        }
        if (array.getStopIndexExpression() != null) {
            array.getStopIndexExpression().accept(this);
        }
    }

    @Override
    public void visit(ArrayConstructor aThis) {
        for (Expression expression : aThis.getExpressions()) {
            expression.accept(this);
        }
    }

    @Override
    public void validate(Expression expression) {
        expression.accept(this);
    }

    @Override
    public void visit(VariableAssignment a) {
        this.validateOptionalExpression(a.getExpression());
        if (a.getVariable() != null) {
            a.getVariable().accept(this);
        }
    }

    @Override
    public void visit(TimezoneExpression a) {
        this.validateOptionalExpression(a.getLeftExpression());
    }

    @Override
    public void visit(XMLSerializeExpr xml) {
    }

    @Override
    public void visit(JsonAggregateFunction expression) {
    }

    @Override
    public void visit(JsonFunction expression) {
    }

    @Override
    public void visit(ConnectByRootOperator connectByRootOperator) {
        connectByRootOperator.getColumn().accept(this);
    }

    @Override
    public void visit(OracleNamedFunctionParameter oracleNamedFunctionParameter) {
        oracleNamedFunctionParameter.getExpression().accept(this);
    }

    @Override
    public void visit(AllColumns allColumns) {
    }

    @Override
    public void visit(AllTableColumns allTableColumns) {
    }

    @Override
    public void visit(AllValue allValue) {
    }

    @Override
    public void visit(IsDistinctExpression isDistinctExpression) {
        isDistinctExpression.getLeftExpression().accept(this);
        isDistinctExpression.getRightExpression().accept(this);
    }

    @Override
    public void visit(GeometryDistance geometryDistance) {
        this.visitOldOracleJoinBinaryExpression(geometryDistance, " <-> ");
    }

    @Override
    public void visit(Select selectBody) {
    }

    @Override
    public void visit(TranscodingFunction transcodingFunction) {
        transcodingFunction.getExpression().accept(this);
    }

    @Override
    public void visit(TrimFunction trimFunction) {
        if (trimFunction.getExpression() != null) {
            trimFunction.getExpression().accept(this);
        }
        if (trimFunction.getFromExpression() != null) {
            trimFunction.getFromExpression().accept(this);
        }
    }

    @Override
    public void visit(RangeExpression rangeExpression) {
        rangeExpression.getStartExpression().accept(this);
        rangeExpression.getEndExpression().accept(this);
    }

    @Override
    public void visit(TSQLLeftJoin tsqlLeftJoin) {
        tsqlLeftJoin.getLeftExpression().accept(this);
        tsqlLeftJoin.getRightExpression().accept(this);
    }

    @Override
    public void visit(TSQLRightJoin tsqlRightJoin) {
        tsqlRightJoin.getLeftExpression().accept(this);
        tsqlRightJoin.getRightExpression().accept(this);
    }
}

