/*
 * Decompiled with CFR 0.152.
 */
package com.sqlparser.util.validation.validator;

import com.sqlparser.parser.feature.Feature;
import com.sqlparser.statement.Block;
import com.sqlparser.statement.Commit;
import com.sqlparser.statement.CreateFunctionalStatement;
import com.sqlparser.statement.DeclareStatement;
import com.sqlparser.statement.DescribeStatement;
import com.sqlparser.statement.ExplainStatement;
import com.sqlparser.statement.IfElseStatement;
import com.sqlparser.statement.PurgeStatement;
import com.sqlparser.statement.ResetStatement;
import com.sqlparser.statement.RollbackStatement;
import com.sqlparser.statement.SavepointStatement;
import com.sqlparser.statement.SetStatement;
import com.sqlparser.statement.ShowColumnsStatement;
import com.sqlparser.statement.ShowStatement;
import com.sqlparser.statement.Statement;
import com.sqlparser.statement.StatementVisitor;
import com.sqlparser.statement.Statements;
import com.sqlparser.statement.UnsupportedStatement;
import com.sqlparser.statement.UseStatement;
import com.sqlparser.statement.alter.Alter;
import com.sqlparser.statement.alter.AlterSession;
import com.sqlparser.statement.alter.AlterSystemStatement;
import com.sqlparser.statement.alter.RenameTableStatement;
import com.sqlparser.statement.alter.sequence.AlterSequence;
import com.sqlparser.statement.analyze.Analyze;
import com.sqlparser.statement.comment.Comment;
import com.sqlparser.statement.create.function.CreateFunction;
import com.sqlparser.statement.create.index.CreateIndex;
import com.sqlparser.statement.create.procedure.CreateProcedure;
import com.sqlparser.statement.create.schema.CreateSchema;
import com.sqlparser.statement.create.sequence.CreateSequence;
import com.sqlparser.statement.create.synonym.CreateSynonym;
import com.sqlparser.statement.create.table.CreateTable;
import com.sqlparser.statement.create.view.AlterView;
import com.sqlparser.statement.create.view.CreateView;
import com.sqlparser.statement.delete.Delete;
import com.sqlparser.statement.drop.Drop;
import com.sqlparser.statement.execute.Execute;
import com.sqlparser.statement.grant.Grant;
import com.sqlparser.statement.insert.Insert;
import com.sqlparser.statement.merge.Merge;
import com.sqlparser.statement.refresh.RefreshMaterializedViewStatement;
import com.sqlparser.statement.select.Select;
import com.sqlparser.statement.show.ShowIndexStatement;
import com.sqlparser.statement.show.ShowTablesStatement;
import com.sqlparser.statement.truncate.Truncate;
import com.sqlparser.statement.update.Update;
import com.sqlparser.statement.upsert.Upsert;
import com.sqlparser.util.validation.ValidationCapability;
import com.sqlparser.util.validation.metadata.NamedObject;
import com.sqlparser.util.validation.validator.AbstractValidator;
import com.sqlparser.util.validation.validator.AlterSequenceValidator;
import com.sqlparser.util.validation.validator.AlterValidator;
import com.sqlparser.util.validation.validator.AlterViewValidator;
import com.sqlparser.util.validation.validator.AnalyzeValidator;
import com.sqlparser.util.validation.validator.CreateIndexValidator;
import com.sqlparser.util.validation.validator.CreateSequenceValidator;
import com.sqlparser.util.validation.validator.CreateSynonymValidator;
import com.sqlparser.util.validation.validator.CreateTableValidator;
import com.sqlparser.util.validation.validator.CreateViewValidator;
import com.sqlparser.util.validation.validator.DeclareStatementValidator;
import com.sqlparser.util.validation.validator.DeleteValidator;
import com.sqlparser.util.validation.validator.DropValidator;
import com.sqlparser.util.validation.validator.ExecuteValidator;
import com.sqlparser.util.validation.validator.GrantValidator;
import com.sqlparser.util.validation.validator.InsertValidator;
import com.sqlparser.util.validation.validator.MergeValidator;
import com.sqlparser.util.validation.validator.RefreshMaterializedViewStatementValidator;
import com.sqlparser.util.validation.validator.ResetStatementValidator;
import com.sqlparser.util.validation.validator.SelectValidator;
import com.sqlparser.util.validation.validator.SetStatementValidator;
import com.sqlparser.util.validation.validator.ShowColumnsStatementValidator;
import com.sqlparser.util.validation.validator.ShowIndexStatementValidator;
import com.sqlparser.util.validation.validator.ShowStatementValidator;
import com.sqlparser.util.validation.validator.ShowTablesStatementValidator;
import com.sqlparser.util.validation.validator.UpdateValidator;
import com.sqlparser.util.validation.validator.UpsertValidator;
import com.sqlparser.util.validation.validator.UseStatementValidator;

public class StatementValidator
extends AbstractValidator<Statement>
implements StatementVisitor {
    @Override
    public void visit(CreateIndex createIndex) {
        this.getValidator(CreateIndexValidator.class).validate(createIndex);
    }

    @Override
    public void visit(CreateTable createTable) {
        this.getValidator(CreateTableValidator.class).validate(createTable);
    }

    @Override
    public void visit(CreateView createView) {
        this.getValidator(CreateViewValidator.class).validate(createView);
    }

    @Override
    public void visit(AlterView alterView) {
        this.getValidator(AlterViewValidator.class).validate(alterView);
    }

    @Override
    public void visit(RefreshMaterializedViewStatement materializedView) {
        this.getValidator(RefreshMaterializedViewStatementValidator.class).validate(materializedView);
    }

    @Override
    public void visit(Delete delete) {
        this.getValidator(DeleteValidator.class).validate(delete);
    }

    @Override
    public void visit(Drop drop) {
        this.getValidator(DropValidator.class).validate(drop);
    }

    @Override
    public void visit(Insert insert) {
        this.getValidator(InsertValidator.class).validate(insert);
    }

    @Override
    public void visit(Select select) {
        this.validateFeature(Feature.select);
        SelectValidator selectValidator = this.getValidator(SelectValidator.class);
        select.accept(selectValidator);
    }

    @Override
    public void visit(Truncate truncate) {
        this.validateFeature(Feature.truncate);
        this.validateOptionalFromItem(truncate.getTable());
    }

    @Override
    public void visit(Update update) {
        this.getValidator(UpdateValidator.class).validate(update);
    }

    @Override
    public void visit(Alter alter) {
        this.getValidator(AlterValidator.class).validate(alter);
    }

    @Override
    public void visit(Statements stmts) {
        stmts.getStatements().forEach(s -> s.accept(this));
    }

    @Override
    public void visit(Execute execute) {
        this.getValidator(ExecuteValidator.class).validate(execute);
    }

    @Override
    public void visit(SetStatement set) {
        this.getValidator(SetStatementValidator.class).validate(set);
    }

    @Override
    public void visit(ResetStatement reset) {
        this.getValidator(ResetStatementValidator.class).validate(reset);
    }

    @Override
    public void visit(Merge merge) {
        this.getValidator(MergeValidator.class).validate(merge);
    }

    @Override
    public void visit(Commit commit) {
        this.validateFeature(Feature.commit);
    }

    @Override
    public void visit(Upsert upsert) {
        this.getValidator(UpsertValidator.class).validate(upsert);
    }

    @Override
    public void visit(UseStatement use) {
        this.getValidator(UseStatementValidator.class).validate(use);
    }

    @Override
    public void visit(ShowStatement show) {
        this.getValidator(ShowStatementValidator.class).validate(show);
    }

    @Override
    public void visit(ShowColumnsStatement show) {
        this.getValidator(ShowColumnsStatementValidator.class).validate(show);
    }

    @Override
    public void visit(ShowIndexStatement show) {
        this.getValidator(ShowIndexStatementValidator.class).validate(show);
    }

    @Override
    public void visit(ShowTablesStatement showTables) {
        this.getValidator(ShowTablesStatementValidator.class).validate(showTables);
    }

    @Override
    public void visit(Block block) {
        this.validateFeature(Feature.block);
        block.getStatements().accept(this);
    }

    @Override
    public void visit(Comment comment) {
        for (ValidationCapability c : this.getCapabilities()) {
            this.validateFeature(c, Feature.comment);
            this.validateOptionalFeature(c, comment.getTable(), Feature.commentOnTable);
            this.validateOptionalFeature(c, comment.getColumn(), Feature.commentOnColumn);
            this.validateOptionalFeature(c, comment.getView(), Feature.commentOnView);
        }
    }

    @Override
    public void visit(DescribeStatement describe) {
        this.validateFeature(Feature.describe);
        this.validateFeature(Feature.desc);
        this.validateOptionalFromItem(describe.getTable());
    }

    @Override
    public void visit(ExplainStatement explain) {
        this.validateFeature(Feature.explain);
        if (explain.getStatement() != null) {
            explain.getStatement().accept(this);
        }
    }

    @Override
    public void visit(DeclareStatement declare) {
        this.getValidator(DeclareStatementValidator.class).validate(declare);
    }

    @Override
    public void visit(Grant grant) {
        this.getValidator(GrantValidator.class).validate(grant);
    }

    @Override
    public void visit(CreateSchema aThis) {
        this.validateFeatureAndName(Feature.createSchema, NamedObject.schema, aThis.getSchemaName());
        aThis.getStatements().forEach(s -> s.accept(this));
    }

    @Override
    public void visit(CreateSequence createSequence) {
        this.getValidator(CreateSequenceValidator.class).validate(createSequence);
    }

    @Override
    public void visit(AlterSequence alterSequence) {
        this.getValidator(AlterSequenceValidator.class).validate(alterSequence);
    }

    @Override
    public void visit(CreateFunctionalStatement createFunctionalStatement) {
        this.validateFeature(Feature.functionalStatement);
        if (createFunctionalStatement instanceof CreateFunction) {
            this.validateFeature(Feature.createFunction);
        } else if (createFunctionalStatement instanceof CreateProcedure) {
            this.validateFeature(Feature.createProcedure);
        }
    }

    @Override
    public void validate(Statement statement) {
        statement.accept(this);
    }

    @Override
    public void visit(CreateSynonym createSynonym) {
        this.getValidator(CreateSynonymValidator.class).validate(createSynonym);
    }

    @Override
    public void visit(Analyze analyze) {
        this.getValidator(AnalyzeValidator.class).validate(analyze);
    }

    @Override
    public void visit(SavepointStatement savepointStatement) {
    }

    @Override
    public void visit(RollbackStatement rollbackStatement) {
    }

    @Override
    public void visit(AlterSession alterSession) {
    }

    @Override
    public void visit(IfElseStatement ifElseStatement) {
        ifElseStatement.getIfStatement().accept(this);
        if (ifElseStatement.getElseStatement() != null) {
            ifElseStatement.getElseStatement().accept(this);
        }
    }

    @Override
    public void visit(RenameTableStatement renameTableStatement) {
    }

    @Override
    public void visit(PurgeStatement purgeStatement) {
    }

    @Override
    public void visit(AlterSystemStatement alterSystemStatement) {
    }

    @Override
    public void visit(UnsupportedStatement unsupportedStatement) {
    }
}

