/*
 * Decompiled with CFR 0.152.
 */
package com.sqlparser.util.validation.validator;

import com.sqlparser.parser.feature.Feature;
import com.sqlparser.statement.select.Join;
import com.sqlparser.statement.update.Update;
import com.sqlparser.util.validation.ValidationCapability;
import com.sqlparser.util.validation.validator.AbstractValidator;
import com.sqlparser.util.validation.validator.LimitValidator;
import com.sqlparser.util.validation.validator.SelectValidator;
import java.util.List;

public class UpdateValidator
extends AbstractValidator<Update> {
    @Override
    public void validate(Update update) {
        for (ValidationCapability c2 : this.getCapabilities()) {
            this.validateFeature(c2, Feature.update);
            this.validateOptionalFeature(c2, update.getFromItem(), Feature.updateFrom);
            this.validateOptionalFeature(c2, update.getStartJoins(), Feature.updateJoins);
            this.validateFeature(c2, update.isUseSelect(), Feature.updateUseSelect);
            this.validateOptionalFeature(c2, update.getOrderByElements(), Feature.updateOrderBy);
            this.validateOptionalFeature(c2, update.getLimit(), Feature.updateLimit);
            this.validateOptionalFeature(c2, update.getReturningClause(), Feature.updateReturning);
        }
        this.validateOptionalFromItem(update.getTable());
        this.validateOptional(update.getStartJoins(), j -> this.getValidator(SelectValidator.class).validateOptionalJoins((List<Join>)j));
        if (update.isUseSelect()) {
            this.validateOptionalExpressions(update.getColumns());
            this.validateOptional(update.getSelect(), e -> e.accept(this.getValidator(SelectValidator.class)));
        } else {
            this.validateOptionalExpressions(update.getColumns());
            this.validateOptionalExpressions(update.getExpressions());
        }
        if (update.getFromItem() != null) {
            this.validateOptionalFromItem(update.getFromItem());
            this.validateOptional(update.getJoins(), j -> this.getValidator(SelectValidator.class).validateOptionalJoins((List<Join>)j));
        }
        this.validateOptionalExpression(update.getWhere());
        this.validateOptionalOrderByElements(update.getOrderByElements());
        if (update.getLimit() != null) {
            this.getValidator(LimitValidator.class).validate(update.getLimit());
        }
        if (update.getReturningClause() != null) {
            SelectValidator v = this.getValidator(SelectValidator.class);
            update.getReturningClause().forEach(c -> c.accept(v));
        }
    }
}

