/*
 * Decompiled with CFR 0.152.
 */
package com.sqlparser.util.validation.validator;

import com.sqlparser.parser.feature.Feature;
import com.sqlparser.statement.select.Select;
import com.sqlparser.statement.update.UpdateSet;
import com.sqlparser.statement.upsert.Upsert;
import com.sqlparser.util.validation.ValidationCapability;
import com.sqlparser.util.validation.validator.AbstractValidator;
import com.sqlparser.util.validation.validator.SelectValidator;

public class UpsertValidator
extends AbstractValidator<Upsert> {
    @Override
    public void validate(Upsert upsert) {
        for (ValidationCapability c : this.getCapabilities()) {
            this.validateFeature(c, Feature.upsert);
        }
        this.validateOptionalFromItem(upsert.getTable());
        this.validateOptionalExpressions(upsert.getColumns());
        this.validateOptionalExpressions(upsert.getExpressions());
        this.validateOptionalSelect(upsert.getSelect());
        this.validateDuplicate(upsert);
    }

    private void validateOptionalSelect(Select select) {
        if (select != null) {
            SelectValidator v = this.getValidator(SelectValidator.class);
            select.accept(v);
        }
    }

    private void validateDuplicate(Upsert upsert) {
        if (upsert.getDuplicateUpdateSets() != null) {
            for (UpdateSet updateSet : upsert.getDuplicateUpdateSets()) {
                this.validateOptionalExpressions(updateSet.getColumns());
                this.validateOptionalExpressions(updateSet.getValues());
            }
        }
    }
}

