/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.processor.builder;

import com.mybatisflex.processor.entity.ColumnInfo;
import com.mybatisflex.processor.entity.TableInfo;
import com.mybatisflex.processor.util.StrUtil;
import java.util.Collection;
import java.util.List;
import java.util.StringJoiner;

public class ContentBuilder {
    private ContentBuilder() {
    }

    public static String buildMapper(TableInfo tableInfo, String mappersPackage, String mapperClassName, String baseMapperClass, boolean mapperAnnotationEnable) {
        String entityClass = tableInfo.getEntityName();
        StringBuilder content = new StringBuilder("package ");
        content.append(mappersPackage).append(";\n\n");
        content.append("import ").append(baseMapperClass).append(";\n");
        content.append("import ").append(entityClass).append(";\n\n");
        if (mapperAnnotationEnable) {
            content.append("import org.apache.ibatis.annotations.Mapper;\n\n");
            content.append("@Mapper\n");
        }
        String realEntityClassName = StrUtil.getClassName(entityClass);
        String baseMapperClassName = StrUtil.getClassName(baseMapperClass);
        content.append("public interface ").append(mapperClassName).append(" extends ").append(baseMapperClassName).append("<").append(realEntityClassName).append("> {\n}");
        return content.toString();
    }

    public static String buildTableDef(TableInfo tableInfo, boolean allInTablesEnable, String tableDefPackage, String tableDefClassName, String tableDefPropertiesNameStyle, String tableDefInstanceSuffix, Collection<ColumnInfo> columnInfos, List<String> defaultColumns) {
        StringBuilder content = new StringBuilder("package ");
        content.append(tableDefPackage).append(";\n\n");
        content.append("import com.mybatisflex.core.query.QueryColumn;\n");
        content.append("import com.mybatisflex.core.table.TableDef;\n\n");
        content.append("// Auto generate by mybatis-flex, do not modify it.\n");
        content.append("public class ").append(tableDefClassName).append(" extends TableDef {\n\n");
        if (!allInTablesEnable) {
            String entityComment = tableInfo.getEntityComment();
            if (!StrUtil.isBlank(entityComment)) {
                content.append("    /**\n").append("     * ").append(entityComment.trim()).append("\n").append("     */\n");
            }
            content.append("    public static final ").append(tableDefClassName).append(' ').append(StrUtil.buildFieldName(tableInfo.getEntitySimpleName().concat(tableDefInstanceSuffix != null ? tableDefInstanceSuffix.trim() : ""), tableDefPropertiesNameStyle)).append(" = new ").append(tableDefClassName).append("();\n\n");
        }
        columnInfos.forEach(columnInfo -> {
            String comment = columnInfo.getComment();
            if (!StrUtil.isBlank(comment)) {
                content.append("    /**\n").append("     * ").append(comment.trim()).append("\n").append("     */\n");
            }
            content.append("    public final QueryColumn ").append(StrUtil.buildFieldName(columnInfo.getProperty(), tableDefPropertiesNameStyle)).append(" = new QueryColumn(this, \"").append(columnInfo.getColumn()).append("\"");
            if (columnInfo.getAlias() != null && columnInfo.getAlias().length > 0) {
                content.append(", \"").append(columnInfo.getAlias()[0]).append("\"");
            }
            content.append(");\n\n");
        });
        content.append("    /**\n").append("     * \u6240\u6709\u5b57\u6bb5\u3002\n").append("     */\n");
        content.append("    public final QueryColumn ").append(StrUtil.buildFieldName("allColumns", tableDefPropertiesNameStyle)).append(" = new QueryColumn(this, \"*\");\n");
        StringJoiner defaultColumnJoiner = new StringJoiner(", ");
        columnInfos.forEach(columnInfo -> {
            if (defaultColumns.contains(columnInfo.getColumn())) {
                defaultColumnJoiner.add(StrUtil.buildFieldName(columnInfo.getProperty(), tableDefPropertiesNameStyle));
            }
        });
        content.append("\n    /**\n").append("     * \u9ed8\u8ba4\u5b57\u6bb5\uff0c\u4e0d\u5305\u542b\u903b\u8f91\u5220\u9664\u6216\u8005 large \u7b49\u5b57\u6bb5\u3002\n").append("     */\n");
        content.append("    public final QueryColumn[] ").append(StrUtil.buildFieldName("defaultColumns", tableDefPropertiesNameStyle)).append(" = new QueryColumn[]{").append(defaultColumnJoiner).append("};\n\n");
        String schema = !StrUtil.isBlank(tableInfo.getSchema()) ? tableInfo.getSchema() : "";
        String tableName = !StrUtil.isBlank(tableInfo.getTableName()) ? tableInfo.getTableName() : StrUtil.firstCharToLowerCase(tableInfo.getEntitySimpleName());
        content.append("    public ").append(tableDefClassName).append("() {\n").append("        super").append("(\"").append(schema).append("\", \"").append(tableName).append("\");\n").append("    }\n\n}\n");
        return content.toString();
    }

    public static String buildTables(StringBuilder importBuilder, StringBuilder fieldBuilder, String tablesPackage, String tablesClassName) {
        return "package " + tablesPackage + ";\n\n" + importBuilder.toString() + "\n// Auto generate by mybatis-flex, do not modify it.\npublic class " + tablesClassName + " {\n\n    private " + tablesClassName + "() {\n    }\n\n" + fieldBuilder.toString() + "\n}\n";
    }

    public static void buildTablesField(StringBuilder importBuilder, StringBuilder fieldBuilder, TableInfo tableInfo, String tableDefClassSuffix, String tableDefPropertiesNameStyle, String tableDefInstanceSuffix) {
        String tableDefPackage = StrUtil.buildTableDefPackage(tableInfo.getEntityName());
        String tableDefClassName = tableInfo.getEntitySimpleName().concat(tableDefClassSuffix);
        importBuilder.append("import ").append(tableDefPackage).append('.').append(tableDefClassName).append(";\n");
        String entityComment = tableInfo.getEntityComment();
        if (!StrUtil.isBlank(entityComment)) {
            fieldBuilder.append("    /**\n").append("    * ").append(entityComment).append("\n").append("    */\n");
        }
        fieldBuilder.append("    public static final ").append(tableDefClassName).append(' ').append(StrUtil.buildFieldName(tableInfo.getEntitySimpleName().concat(tableDefInstanceSuffix != null ? tableDefInstanceSuffix.trim() : ""), tableDefPropertiesNameStyle)).append(" = new ").append(tableDefClassName).append("();\n");
    }
}

