/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.storage;

import com.qiniu.common.QiniuException;
import com.qiniu.http.Client;
import com.qiniu.http.Response;
import com.qiniu.storage.Region;
import com.qiniu.storage.RegionGroup;
import com.qiniu.storage.RegionReqInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class AutoRegion
extends Region {
    private String ucServer;
    private Map<String, Region> regions;
    private static Map<String, UCRet> globalRegionCache = new ConcurrentHashMap<String, UCRet>();
    private Client client;

    private AutoRegion() {
    }

    AutoRegion(String ucServer) {
        this.ucServer = ucServer;
        this.client = new Client();
        this.regions = new ConcurrentHashMap<String, Region>();
    }

    private UCRet queryRegionInfoFromServerIfNeeded(RegionIndex index) throws QiniuException {
        String cacheKey = index.accessKey + index.bucket;
        UCRet ret = globalRegionCache.get(cacheKey);
        if (ret != null && ret.isValid()) {
            return ret;
        }
        String address = this.ucServer + "/v3/query?ak=" + index.accessKey + "&bucket=" + index.bucket;
        Response r = this.client.get(address);
        ret = r.jsonToObject(UCRet.class);
        if (ret != null) {
            ret.setupDeadline();
            globalRegionCache.put(cacheKey, ret);
        }
        return ret;
    }

    static Region regionGroup(UCRet ret) {
        if (ret == null || ret.hosts == null || ret.hosts.length == 0) {
            return null;
        }
        RegionGroup group = new RegionGroup();
        for (ServerRets host : ret.hosts) {
            Region region = host.createRegion();
            group.addRegion(region);
        }
        return group;
    }

    private Region queryRegionInfo(String accessKey, String bucket) throws QiniuException {
        RegionIndex index = new RegionIndex(accessKey, bucket);
        String cacheKey = index.accessKey + "::" + index.bucket;
        Region region = this.regions.get(cacheKey);
        Exception ex = null;
        if (region == null || !region.isValid()) {
            for (int i = 0; i < 2; ++i) {
                try {
                    UCRet ret = this.queryRegionInfoFromServerIfNeeded(index);
                    region = AutoRegion.regionGroup(ret);
                    if (region == null) continue;
                    this.regions.put(cacheKey, region);
                    break;
                }
                catch (Exception e) {
                    ex = e;
                }
            }
        }
        if (region == null) {
            if (ex instanceof QiniuException) {
                throw (QiniuException)ex;
            }
            throw new QiniuException(ex, "auto region get region info from uc failed.");
        }
        return region;
    }

    private Region queryRegionInfo(RegionReqInfo regionReqInfo) throws QiniuException {
        return this.queryRegionInfo(regionReqInfo.getAccessKey(), regionReqInfo.getBucket());
    }

    @Override
    boolean switchRegion(RegionReqInfo regionReqInfo) {
        Region currentRegion = this.getCurrentRegion(regionReqInfo);
        if (currentRegion == null) {
            return false;
        }
        return currentRegion.switchRegion(regionReqInfo);
    }

    @Override
    String getRegion(RegionReqInfo regionReqInfo) {
        Region currentRegion = this.getCurrentRegion(regionReqInfo);
        if (currentRegion == null) {
            return "";
        }
        return currentRegion.getRegion(regionReqInfo);
    }

    @Override
    boolean isValid() {
        return true;
    }

    @Override
    Region getCurrentRegion(RegionReqInfo regionReqInfo) {
        try {
            Region region = this.queryRegionInfo(regionReqInfo);
            return region.getCurrentRegion(regionReqInfo);
        }
        catch (QiniuException e) {
            return null;
        }
    }

    @Override
    List<String> getSrcUpHost(RegionReqInfo regionReqInfo) throws QiniuException {
        if (regionReqInfo == null) {
            return null;
        }
        Region region = this.queryRegionInfo(regionReqInfo);
        return region.getSrcUpHost(regionReqInfo);
    }

    @Override
    List<String> getAccUpHost(RegionReqInfo regionReqInfo) throws QiniuException {
        if (regionReqInfo == null) {
            return null;
        }
        Region region = this.queryRegionInfo(regionReqInfo);
        return region.getAccUpHost(regionReqInfo);
    }

    @Override
    String getIovipHost(RegionReqInfo regionReqInfo) throws QiniuException {
        if (regionReqInfo == null) {
            return "";
        }
        Region region = this.queryRegionInfo(regionReqInfo);
        return region.getIovipHost(regionReqInfo);
    }

    @Override
    String getRsHost(RegionReqInfo regionReqInfo) throws QiniuException {
        if (regionReqInfo == null) {
            return "";
        }
        Region region = this.queryRegionInfo(regionReqInfo);
        return region.getRsHost(regionReqInfo);
    }

    @Override
    String getRsfHost(RegionReqInfo regionReqInfo) throws QiniuException {
        if (regionReqInfo == null) {
            return "";
        }
        Region region = this.queryRegionInfo(regionReqInfo);
        return region.getRsfHost(regionReqInfo);
    }

    @Override
    String getApiHost(RegionReqInfo regionReqInfo) throws QiniuException {
        if (regionReqInfo == null) {
            return "";
        }
        Region region = this.queryRegionInfo(regionReqInfo);
        return region.getApiHost(regionReqInfo);
    }

    @Override
    String getUcHost(RegionReqInfo regionReqInfo) throws QiniuException {
        String host = this.ucServer.replace("http://", "");
        host = host.replace("https://", "");
        return host;
    }

    @Override
    public Object clone() {
        AutoRegion newRegion = new AutoRegion();
        newRegion.ucServer = this.ucServer;
        newRegion.regions = this.regions;
        newRegion.client = this.client;
        return newRegion;
    }

    private class HostInfoRet {
        List<String> main;
        List<String> backup;

        private HostInfoRet() {
        }

        private String getOneHost() {
            if (this.main != null && this.main.size() > 0) {
                return this.main.get(0);
            }
            if (this.backup != null && this.backup.size() > 0) {
                return this.backup.get(0);
            }
            return null;
        }

        private List<String> allHosts() {
            ArrayList<String> hosts = new ArrayList<String>();
            if (this.main != null && this.main.size() > 0) {
                hosts.addAll(this.main);
            }
            if (this.backup != null && this.backup.size() > 0) {
                hosts.addAll(this.backup);
            }
            return hosts;
        }
    }

    private class ServerRet {
        HostInfoRet src;
        HostInfoRet acc;

        private ServerRet() {
        }

        private String getOneHost() {
            String host = null;
            if (this.src != null) {
                host = this.src.getOneHost();
            }
            if (host == null && this.acc != null) {
                host = this.acc.getOneHost();
            }
            return host;
        }

        private List<String> allSrcHosts() {
            if (this.src != null) {
                return this.src.allHosts();
            }
            return new ArrayList<String>();
        }

        private List<String> allAccHosts() {
            if (this.acc != null) {
                return this.acc.allHosts();
            }
            return new ArrayList<String>();
        }
    }

    private class ServerRets {
        long ttl;
        String region;
        ServerRet up;
        ServerRet rs;
        ServerRet rsf;
        ServerRet uc;
        ServerRet api;
        ServerRet io;

        private ServerRets() {
        }

        Region createRegion() {
            String regionId;
            long timestamp = this.ttl + System.currentTimeMillis() / 1000L;
            ArrayList<String> srcUpHosts = new ArrayList();
            ArrayList<String> accUpHosts = new ArrayList();
            if (this.up != null) {
                srcUpHosts = this.up.allSrcHosts();
                accUpHosts = this.up.allAccHosts();
            }
            String iovipHost = null;
            if (this.io != null) {
                iovipHost = this.io.getOneHost();
            }
            String rsHost = null;
            if (this.rs != null) {
                rsHost = this.rs.getOneHost();
            }
            String rsfHost = null;
            if (this.rsf != null) {
                rsfHost = this.rsf.getOneHost();
            }
            String apiHost = null;
            if (this.api != null) {
                apiHost = this.api.getOneHost();
            }
            String ucHost = null;
            if (this.uc != null) {
                ucHost = this.uc.getOneHost();
            }
            if ((regionId = this.region) == null) {
                regionId = "";
            }
            return new Region(timestamp, regionId, srcUpHosts, accUpHosts, iovipHost, rsHost, rsfHost, apiHost, ucHost);
        }
    }

    private class UCRet {
        long deadline;
        ServerRets[] hosts;

        private UCRet() {
        }

        private boolean isValid() {
            return System.currentTimeMillis() < this.deadline * 1000L;
        }

        private void setupDeadline() {
            long ttl = Integer.MAX_VALUE;
            if (this.hosts != null && this.hosts.length > 0) {
                for (ServerRets hostRet : this.hosts) {
                    if (hostRet == null || hostRet.ttl >= ttl) continue;
                    ttl = hostRet.ttl;
                }
            }
            this.deadline = System.currentTimeMillis() / 1000L + ttl;
        }
    }

    private static class RegionIndex {
        private final String accessKey;
        private final String bucket;

        RegionIndex(String accessKey, String bucket) {
            this.accessKey = accessKey;
            this.bucket = bucket;
        }

        public int hashCode() {
            return this.accessKey.hashCode() * 37 + this.bucket.hashCode();
        }

        public boolean equals(Object obj) {
            return obj == this || obj != null && obj instanceof RegionIndex && ((RegionIndex)obj).accessKey.equals(this.accessKey) && ((RegionIndex)obj).bucket.equals(this.bucket);
        }
    }
}

