/*
 * Decompiled with CFR 0.152.
 */
package com.unfbx.chatgpt;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.ContentType;
import cn.hutool.json.JSONUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.unfbx.chatgpt.OpenAiApi;
import com.unfbx.chatgpt.entity.billing.BillingUsage;
import com.unfbx.chatgpt.entity.billing.CreditGrantsResponse;
import com.unfbx.chatgpt.entity.billing.Subscription;
import com.unfbx.chatgpt.entity.chat.BaseChatCompletion;
import com.unfbx.chatgpt.entity.chat.ChatCompletion;
import com.unfbx.chatgpt.entity.chat.Functions;
import com.unfbx.chatgpt.entity.chat.Message;
import com.unfbx.chatgpt.entity.common.OpenAiResponse;
import com.unfbx.chatgpt.entity.completions.Completion;
import com.unfbx.chatgpt.exception.BaseException;
import com.unfbx.chatgpt.exception.CommonError;
import com.unfbx.chatgpt.function.KeyRandomStrategy;
import com.unfbx.chatgpt.function.KeyStrategyFunction;
import com.unfbx.chatgpt.interceptor.DefaultOpenAiAuthInterceptor;
import com.unfbx.chatgpt.interceptor.OpenAiAuthInterceptor;
import com.unfbx.chatgpt.plugin.PluginAbstract;
import com.unfbx.chatgpt.plugin.PluginParam;
import com.unfbx.chatgpt.sse.DefaultPluginListener;
import com.unfbx.chatgpt.sse.PluginListener;
import io.reactivex.Single;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import okhttp3.sse.EventSources;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class OpenAiStreamClient {
    private static final Logger log = LoggerFactory.getLogger(OpenAiStreamClient.class);
    @NotNull
    private List<String> apiKey;
    private String apiHost;
    private OkHttpClient okHttpClient;
    private KeyStrategyFunction<List<String>, String> keyStrategy;
    private OpenAiApi openAiApi;
    private OpenAiAuthInterceptor authInterceptor;

    private OpenAiStreamClient(Builder builder) {
        if (CollectionUtil.isEmpty((Collection)builder.apiKey)) {
            throw new BaseException(CommonError.API_KEYS_NOT_NUL);
        }
        this.apiKey = builder.apiKey;
        if (StrUtil.isBlank((CharSequence)builder.apiHost)) {
            builder.apiHost = "https://api.openai.com/";
        }
        this.apiHost = builder.apiHost;
        if (Objects.isNull(builder.keyStrategy)) {
            builder.keyStrategy = new KeyRandomStrategy();
        }
        this.keyStrategy = builder.keyStrategy;
        if (Objects.isNull(builder.authInterceptor)) {
            builder.authInterceptor = new DefaultOpenAiAuthInterceptor();
        }
        this.authInterceptor = builder.authInterceptor;
        this.authInterceptor.setApiKey(this.apiKey);
        this.authInterceptor.setKeyStrategy(this.keyStrategy);
        if (Objects.isNull(builder.okHttpClient)) {
            builder.okHttpClient = this.okHttpClient();
        } else {
            builder.okHttpClient = builder.okHttpClient.newBuilder().addInterceptor((Interceptor)this.authInterceptor).build();
        }
        this.okHttpClient = builder.okHttpClient;
        this.openAiApi = (OpenAiApi)new Retrofit.Builder().baseUrl(this.apiHost).client(this.okHttpClient).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).addConverterFactory((Converter.Factory)JacksonConverterFactory.create()).build().create(OpenAiApi.class);
    }

    private OkHttpClient okHttpClient() {
        if (Objects.isNull(this.authInterceptor)) {
            this.authInterceptor = new DefaultOpenAiAuthInterceptor();
        }
        this.authInterceptor.setApiKey(this.apiKey);
        this.authInterceptor.setKeyStrategy(this.keyStrategy);
        return new OkHttpClient.Builder().addInterceptor((Interceptor)this.authInterceptor).connectTimeout(10L, TimeUnit.SECONDS).writeTimeout(50L, TimeUnit.SECONDS).readTimeout(50L, TimeUnit.SECONDS).build();
    }

    public void streamCompletions(Completion completion, EventSourceListener eventSourceListener) {
        if (Objects.isNull(eventSourceListener)) {
            log.error("\u53c2\u6570\u5f02\u5e38\uff1aEventSourceListener\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u53ef\u4ee5\u53c2\u8003\uff1acom.unfbx.chatgpt.sse.ConsoleEventSourceListener");
            throw new BaseException(CommonError.PARAM_ERROR);
        }
        if (StrUtil.isBlank((CharSequence)completion.getPrompt())) {
            log.error("\u53c2\u6570\u5f02\u5e38\uff1aPrompt\u4e0d\u80fd\u4e3a\u7a7a");
            throw new BaseException(CommonError.PARAM_ERROR);
        }
        if (!completion.isStream()) {
            completion.setStream(true);
        }
        try {
            EventSource.Factory factory = EventSources.createFactory((OkHttpClient)this.okHttpClient);
            ObjectMapper mapper = new ObjectMapper();
            String requestBody = mapper.writeValueAsString((Object)completion);
            Request request = new Request.Builder().url(this.apiHost + "v1/completions").post(RequestBody.create((MediaType)MediaType.parse((String)ContentType.JSON.getValue()), (String)requestBody)).build();
            EventSource eventSource = factory.newEventSource(request, eventSourceListener);
        }
        catch (JsonProcessingException e) {
            log.error("\u8bf7\u6c42\u53c2\u6570\u89e3\u6790\u5f02\u5e38\uff1a{}", (Throwable)e);
            e.printStackTrace();
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u53c2\u6570\u89e3\u6790\u5f02\u5e38\uff1a{}", (Throwable)e);
            e.printStackTrace();
        }
    }

    public void streamCompletions(String question, EventSourceListener eventSourceListener) {
        Completion q = Completion.builder().prompt(question).stream(true).build();
        this.streamCompletions(q, eventSourceListener);
    }

    public <T extends BaseChatCompletion> void streamChatCompletion(T chatCompletion, EventSourceListener eventSourceListener) {
        if (Objects.isNull(eventSourceListener)) {
            log.error("\u53c2\u6570\u5f02\u5e38\uff1aEventSourceListener\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u53ef\u4ee5\u53c2\u8003\uff1acom.unfbx.chatgpt.sse.ConsoleEventSourceListener");
            throw new BaseException(CommonError.PARAM_ERROR);
        }
        if (!chatCompletion.isStream()) {
            chatCompletion.setStream(true);
        }
        try {
            EventSource.Factory factory = EventSources.createFactory((OkHttpClient)this.okHttpClient);
            ObjectMapper mapper = new ObjectMapper();
            String requestBody = mapper.writeValueAsString(chatCompletion);
            Request request = new Request.Builder().url(this.apiHost + "v1/chat/completions").post(RequestBody.create((MediaType)MediaType.parse((String)ContentType.JSON.getValue()), (String)requestBody)).build();
            EventSource eventSource = factory.newEventSource(request, eventSourceListener);
        }
        catch (JsonProcessingException e) {
            log.error("\u8bf7\u6c42\u53c2\u6570\u89e3\u6790\u5f02\u5e38\uff1a{}", (Throwable)e);
            e.printStackTrace();
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u53c2\u6570\u89e3\u6790\u5f02\u5e38\uff1a{}", (Throwable)e);
            e.printStackTrace();
        }
    }

    public void streamChatCompletion(List<Message> messages, EventSourceListener eventSourceListener) {
        BaseChatCompletion chatCompletion = ((ChatCompletion.ChatCompletionBuilder)((BaseChatCompletion.BaseChatCompletionBuilder)ChatCompletion.builder().messages(messages)).stream(true)).build();
        this.streamChatCompletion(chatCompletion, eventSourceListener);
    }

    public <R extends PluginParam, T> void streamChatCompletionWithPlugin(ChatCompletion chatCompletion, EventSourceListener eventSourceListener, PluginListener pluginEventSourceListener, PluginAbstract<R, T> plugin) {
        if (Objects.isNull(plugin)) {
            this.streamChatCompletion(chatCompletion, eventSourceListener);
            return;
        }
        if (CollectionUtil.isEmpty(chatCompletion.getMessages())) {
            throw new BaseException(CommonError.MESSAGE_NOT_NUL);
        }
        Functions functions = Functions.builder().name(plugin.getFunction()).description(plugin.getDescription()).parameters(plugin.getParameters()).build();
        if (Objects.isNull(chatCompletion.getFunctionCall())) {
            chatCompletion.setFunctionCall("auto");
        }
        chatCompletion.setFunctions(Collections.singletonList(functions));
        if (Objects.isNull((Object)pluginEventSourceListener)) {
            pluginEventSourceListener = new DefaultPluginListener(this, eventSourceListener, (PluginAbstract)plugin, chatCompletion);
        }
        this.streamChatCompletion(chatCompletion, (EventSourceListener)pluginEventSourceListener);
    }

    public <R extends PluginParam, T> void streamChatCompletionWithPlugin(ChatCompletion chatCompletion, EventSourceListener eventSourceListener, PluginAbstract<R, T> plugin) {
        DefaultPluginListener pluginEventSourceListener = new DefaultPluginListener(this, eventSourceListener, (PluginAbstract)plugin, chatCompletion);
        this.streamChatCompletionWithPlugin(chatCompletion, eventSourceListener, pluginEventSourceListener, plugin);
    }

    public <R extends PluginParam, T> void streamChatCompletionWithPlugin(List<Message> messages, EventSourceListener eventSourceListener, PluginAbstract<R, T> plugin) {
        this.streamChatCompletionWithPlugin(messages, BaseChatCompletion.Model.GPT_3_5_TURBO_16K_0613.getName(), eventSourceListener, plugin);
    }

    public <R extends PluginParam, T> void streamChatCompletionWithPlugin(List<Message> messages, String model, EventSourceListener eventSourceListener, PluginAbstract<R, T> plugin) {
        BaseChatCompletion chatCompletion = ((ChatCompletion.ChatCompletionBuilder)((BaseChatCompletion.BaseChatCompletionBuilder)ChatCompletion.builder().messages(messages)).model(model)).build();
        this.streamChatCompletionWithPlugin((ChatCompletion)chatCompletion, eventSourceListener, plugin);
    }

    @Deprecated
    public CreditGrantsResponse creditGrants() {
        Request request = new Request.Builder().url(this.apiHost + "dashboard/billing/credit_grants").get().build();
        Response response = this.okHttpClient.newCall(request).execute();
        ResponseBody body = response.body();
        String bodyStr = body.string();
        if (!response.isSuccessful()) {
            if (response.code() == CommonError.OPENAI_AUTHENTICATION_ERROR.code() || response.code() == CommonError.OPENAI_LIMIT_ERROR.code() || response.code() == CommonError.OPENAI_SERVER_ERROR.code()) {
                OpenAiResponse openAiResponse = (OpenAiResponse)JSONUtil.toBean((String)bodyStr, OpenAiResponse.class);
                log.error(openAiResponse.getError().getMessage());
                throw new BaseException(openAiResponse.getError().getMessage());
            }
            log.error("\u8be2\u4f59\u989d\u8bf7\u6c42\u5f02\u5e38\uff1a{}", (Object)bodyStr);
            OpenAiResponse openAiResponse = (OpenAiResponse)JSONUtil.toBean((String)bodyStr, OpenAiResponse.class);
            if (Objects.nonNull(openAiResponse.getError())) {
                log.error(openAiResponse.getError().getMessage());
                throw new BaseException(openAiResponse.getError().getMessage());
            }
            throw new BaseException(CommonError.RETRY_ERROR);
        }
        ObjectMapper mapper = new ObjectMapper();
        return (CreditGrantsResponse)mapper.readValue(bodyStr, CreditGrantsResponse.class);
    }

    public Subscription subscription() {
        Single<Subscription> subscription = this.openAiApi.subscription();
        return (Subscription)subscription.blockingGet();
    }

    public BillingUsage billingUsage(@NotNull LocalDate starDate, @NotNull LocalDate endDate) {
        Single<BillingUsage> billingUsage = this.openAiApi.billingUsage(starDate, endDate);
        return (BillingUsage)billingUsage.blockingGet();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotNull
    public List<String> getApiKey() {
        return this.apiKey;
    }

    public String getApiHost() {
        return this.apiHost;
    }

    public OkHttpClient getOkHttpClient() {
        return this.okHttpClient;
    }

    public KeyStrategyFunction<List<String>, String> getKeyStrategy() {
        return this.keyStrategy;
    }

    public OpenAiApi getOpenAiApi() {
        return this.openAiApi;
    }

    public OpenAiAuthInterceptor getAuthInterceptor() {
        return this.authInterceptor;
    }

    public static final class Builder {
        @NotNull
        private List<String> apiKey;
        private String apiHost;
        private OkHttpClient okHttpClient;
        private KeyStrategyFunction keyStrategy;
        private OpenAiAuthInterceptor authInterceptor;

        public Builder apiKey(@NotNull List<String> val) {
            this.apiKey = val;
            return this;
        }

        public Builder apiHost(String val) {
            this.apiHost = val;
            return this;
        }

        public Builder keyStrategy(KeyStrategyFunction val) {
            this.keyStrategy = val;
            return this;
        }

        public Builder okHttpClient(OkHttpClient val) {
            this.okHttpClient = val;
            return this;
        }

        public Builder authInterceptor(OpenAiAuthInterceptor val) {
            this.authInterceptor = val;
            return this;
        }

        public OpenAiStreamClient build() {
            return new OpenAiStreamClient(this);
        }
    }
}

