/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.mysql.source.utils;

import com.ververica.cdc.connectors.mysql.schema.MySqlSchema;
import com.ververica.cdc.connectors.mysql.source.config.MySqlSourceConfig;
import com.ververica.cdc.connectors.mysql.source.utils.StatementUtils;
import io.debezium.connector.mysql.MySqlConnection;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.relational.RelationalTableFilters;
import io.debezium.relational.TableId;
import io.debezium.relational.history.TableChanges;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.util.FlinkRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableDiscoveryUtils {
    private static final Logger LOG = LoggerFactory.getLogger(TableDiscoveryUtils.class);

    public static List<TableId> listTables(JdbcConnection jdbc, RelationalTableFilters tableFilters) throws SQLException {
        ArrayList<TableId> capturedTableIds = new ArrayList<TableId>();
        LOG.info("Read list of available databases");
        ArrayList databaseNames = new ArrayList();
        jdbc.query("SHOW DATABASES", rs -> {
            while (rs.next()) {
                databaseNames.add(rs.getString(1));
            }
        });
        LOG.info("\t list of available databases is: {}", databaseNames);
        LOG.info("Read list of available tables in each database");
        for (String dbName : databaseNames) {
            try {
                jdbc.query("SHOW FULL TABLES IN " + StatementUtils.quote(dbName) + " where Table_Type = 'BASE TABLE'", rs -> {
                    while (rs.next()) {
                        TableId tableId = new TableId(dbName, null, rs.getString(1));
                        if (tableFilters.dataCollectionFilter().isIncluded(tableId)) {
                            capturedTableIds.add(tableId);
                            LOG.info("\t including '{}' for further processing", (Object)tableId);
                            continue;
                        }
                        LOG.info("\t '{}' is filtered out of capturing", (Object)tableId);
                    }
                });
            }
            catch (SQLException e) {
                LOG.warn("\t skipping database '{}' due to error reading tables: {}", (Object)dbName, (Object)e.getMessage());
            }
        }
        return capturedTableIds;
    }

    public static Map<TableId, TableChanges.TableChange> discoverCapturedTableSchemas(MySqlSourceConfig sourceConfig, MySqlConnection jdbc) {
        List<TableId> capturedTableIds;
        try {
            capturedTableIds = TableDiscoveryUtils.listTables(jdbc, sourceConfig.getTableFilters());
        }
        catch (SQLException e) {
            throw new FlinkRuntimeException("Failed to discover captured tables", (Throwable)e);
        }
        if (capturedTableIds.isEmpty()) {
            throw new IllegalArgumentException(String.format("Can't find any matched tables, please check your configured database-name: %s and table-name: %s", sourceConfig.getDatabaseList(), sourceConfig.getTableList()));
        }
        MySqlSchema mySqlSchema = new MySqlSchema(sourceConfig, jdbc.isTableIdCaseSensitive());
        HashMap<TableId, TableChanges.TableChange> tableSchemas = new HashMap<TableId, TableChanges.TableChange>();
        for (TableId tableId : capturedTableIds) {
            TableChanges.TableChange tableSchema = mySqlSchema.getTableSchema(jdbc, tableId);
            tableSchemas.put(tableId, tableSchema);
        }
        return tableSchemas;
    }
}

