/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.mysql.table;

import com.ververica.cdc.connectors.mysql.MySqlSource;
import com.ververica.cdc.connectors.mysql.table.MySqlDeserializationConverterFactory;
import com.ververica.cdc.connectors.mysql.table.MySqlReadableMetadata;
import com.ververica.cdc.connectors.mysql.table.StartupOptions;
import com.ververica.cdc.debezium.DebeziumSourceFunction;
import com.ververica.cdc.debezium.table.MetadataConverter;
import com.ververica.cdc.debezium.table.RowDataDebeziumDeserializeSchema;
import java.time.Duration;
import java.time.ZoneId;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.ScanTableSource;
import org.apache.flink.table.connector.source.SourceFunctionProvider;
import org.apache.flink.table.connector.source.SourceProvider;
import org.apache.flink.table.connector.source.abilities.SupportsReadingMetadata;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Preconditions;

public class MySqlTableSource
implements ScanTableSource,
SupportsReadingMetadata {
    private final ResolvedSchema physicalSchema;
    private final int port;
    private final String hostname;
    private final String database;
    private final String username;
    private final String password;
    private final String serverId;
    private final String tableName;
    private final ZoneId serverTimeZone;
    private final Properties dbzProperties;
    private final boolean enableParallelRead;
    private final int splitSize;
    private final int splitMetaGroupSize;
    private final int fetchSize;
    private final Duration connectTimeout;
    private final int connectionPoolSize;
    private final int connectMaxRetries;
    private final double distributionFactorUpper;
    private final double distributionFactorLower;
    private final StartupOptions startupOptions;
    private final boolean scanNewlyAddedTableEnabled;
    private final Properties jdbcProperties;
    private final Duration heartbeatInterval;
    private final String chunkKeyColumn;
    protected DataType producedDataType;
    protected List<String> metadataKeys;

    public MySqlTableSource(ResolvedSchema physicalSchema, int port, String hostname, String database, String tableName, String username, String password, ZoneId serverTimeZone, Properties dbzProperties, @Nullable String serverId, boolean enableParallelRead, int splitSize, int splitMetaGroupSize, int fetchSize, Duration connectTimeout, int connectMaxRetries, int connectionPoolSize, double distributionFactorUpper, double distributionFactorLower, StartupOptions startupOptions, boolean scanNewlyAddedTableEnabled, Properties jdbcProperties, Duration heartbeatInterval, @Nullable String chunkKeyColumn) {
        this.physicalSchema = physicalSchema;
        this.port = port;
        this.hostname = (String)Preconditions.checkNotNull((Object)hostname);
        this.database = (String)Preconditions.checkNotNull((Object)database);
        this.tableName = (String)Preconditions.checkNotNull((Object)tableName);
        this.username = (String)Preconditions.checkNotNull((Object)username);
        this.password = (String)Preconditions.checkNotNull((Object)password);
        this.serverId = serverId;
        this.serverTimeZone = serverTimeZone;
        this.dbzProperties = dbzProperties;
        this.enableParallelRead = enableParallelRead;
        this.splitSize = splitSize;
        this.splitMetaGroupSize = splitMetaGroupSize;
        this.fetchSize = fetchSize;
        this.connectTimeout = connectTimeout;
        this.connectMaxRetries = connectMaxRetries;
        this.connectionPoolSize = connectionPoolSize;
        this.distributionFactorUpper = distributionFactorUpper;
        this.distributionFactorLower = distributionFactorLower;
        this.startupOptions = startupOptions;
        this.scanNewlyAddedTableEnabled = scanNewlyAddedTableEnabled;
        this.jdbcProperties = jdbcProperties;
        this.producedDataType = physicalSchema.toPhysicalRowDataType();
        this.metadataKeys = Collections.emptyList();
        this.heartbeatInterval = heartbeatInterval;
        this.chunkKeyColumn = chunkKeyColumn;
    }

    public ChangelogMode getChangelogMode() {
        return ChangelogMode.newBuilder().addContainedKind(RowKind.INSERT).addContainedKind(RowKind.UPDATE_BEFORE).addContainedKind(RowKind.UPDATE_AFTER).addContainedKind(RowKind.DELETE).build();
    }

    public ScanTableSource.ScanRuntimeProvider getScanRuntimeProvider(ScanTableSource.ScanContext scanContext) {
        RowType physicalDataType = (RowType)this.physicalSchema.toPhysicalRowDataType().getLogicalType();
        MetadataConverter[] metadataConverters = this.getMetadataConverters();
        TypeInformation typeInfo = scanContext.createTypeInformation(this.producedDataType);
        RowDataDebeziumDeserializeSchema deserializer = RowDataDebeziumDeserializeSchema.newBuilder().setPhysicalRowType(physicalDataType).setMetadataConverters(metadataConverters).setResultTypeInfo(typeInfo).setServerTimeZone(this.serverTimeZone).setUserDefinedConverterFactory(MySqlDeserializationConverterFactory.instance()).build();
        if (this.enableParallelRead) {
            com.ververica.cdc.connectors.mysql.source.MySqlSource parallelSource = com.ververica.cdc.connectors.mysql.source.MySqlSource.builder().hostname(this.hostname).port(this.port).databaseList(this.database).tableList(this.database + "." + this.tableName).username(this.username).password(this.password).serverTimeZone(this.serverTimeZone.toString()).serverId(this.serverId).splitSize(this.splitSize).splitMetaGroupSize(this.splitMetaGroupSize).distributionFactorUpper(this.distributionFactorUpper).distributionFactorLower(this.distributionFactorLower).fetchSize(this.fetchSize).connectTimeout(this.connectTimeout).connectMaxRetries(this.connectMaxRetries).connectionPoolSize(this.connectionPoolSize).debeziumProperties(this.dbzProperties).startupOptions(this.startupOptions).deserializer(deserializer).scanNewlyAddedTableEnabled(this.scanNewlyAddedTableEnabled).jdbcProperties(this.jdbcProperties).heartbeatInterval(this.heartbeatInterval).chunkKeyColumn(this.chunkKeyColumn).build();
            return SourceProvider.of(parallelSource);
        }
        MySqlSource.Builder builder = MySqlSource.builder().hostname(this.hostname).port(this.port).databaseList(this.database).tableList(this.database + "." + this.tableName).username(this.username).password(this.password).serverTimeZone(this.serverTimeZone.toString()).debeziumProperties(this.dbzProperties).startupOptions(this.startupOptions).deserializer(deserializer);
        Optional.ofNullable(this.serverId).ifPresent(serverId -> builder.serverId(Integer.parseInt(serverId)));
        DebeziumSourceFunction sourceFunction = builder.build();
        return SourceFunctionProvider.of(sourceFunction, (boolean)false);
    }

    protected MetadataConverter[] getMetadataConverters() {
        if (this.metadataKeys.isEmpty()) {
            return new MetadataConverter[0];
        }
        return (MetadataConverter[])this.metadataKeys.stream().map(key -> Stream.of(MySqlReadableMetadata.values()).filter(m -> m.getKey().equals(key)).findFirst().orElseThrow(IllegalStateException::new)).map(MySqlReadableMetadata::getConverter).toArray(MetadataConverter[]::new);
    }

    public Map<String, DataType> listReadableMetadata() {
        return Stream.of(MySqlReadableMetadata.values()).collect(Collectors.toMap(MySqlReadableMetadata::getKey, MySqlReadableMetadata::getDataType));
    }

    public void applyReadableMetadata(List<String> metadataKeys, DataType producedDataType) {
        this.metadataKeys = metadataKeys;
        this.producedDataType = producedDataType;
    }

    public DynamicTableSource copy() {
        MySqlTableSource source = new MySqlTableSource(this.physicalSchema, this.port, this.hostname, this.database, this.tableName, this.username, this.password, this.serverTimeZone, this.dbzProperties, this.serverId, this.enableParallelRead, this.splitSize, this.splitMetaGroupSize, this.fetchSize, this.connectTimeout, this.connectMaxRetries, this.connectionPoolSize, this.distributionFactorUpper, this.distributionFactorLower, this.startupOptions, this.scanNewlyAddedTableEnabled, this.jdbcProperties, this.heartbeatInterval, this.chunkKeyColumn);
        source.metadataKeys = this.metadataKeys;
        source.producedDataType = this.producedDataType;
        return source;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MySqlTableSource)) {
            return false;
        }
        MySqlTableSource that = (MySqlTableSource)o;
        return this.port == that.port && this.enableParallelRead == that.enableParallelRead && this.splitSize == that.splitSize && this.splitMetaGroupSize == that.splitMetaGroupSize && this.fetchSize == that.fetchSize && this.distributionFactorUpper == that.distributionFactorUpper && this.distributionFactorLower == that.distributionFactorLower && this.scanNewlyAddedTableEnabled == that.scanNewlyAddedTableEnabled && Objects.equals(this.physicalSchema, that.physicalSchema) && Objects.equals(this.hostname, that.hostname) && Objects.equals(this.database, that.database) && Objects.equals(this.username, that.username) && Objects.equals(this.password, that.password) && Objects.equals(this.serverId, that.serverId) && Objects.equals(this.tableName, that.tableName) && Objects.equals(this.serverTimeZone, that.serverTimeZone) && Objects.equals(this.dbzProperties, that.dbzProperties) && Objects.equals(this.connectTimeout, that.connectTimeout) && Objects.equals(this.connectMaxRetries, that.connectMaxRetries) && Objects.equals(this.connectionPoolSize, that.connectionPoolSize) && Objects.equals(this.startupOptions, that.startupOptions) && Objects.equals(this.producedDataType, that.producedDataType) && Objects.equals(this.metadataKeys, that.metadataKeys) && Objects.equals(this.jdbcProperties, that.jdbcProperties) && Objects.equals(this.heartbeatInterval, that.heartbeatInterval) && Objects.equals(this.chunkKeyColumn, that.chunkKeyColumn);
    }

    public int hashCode() {
        return Objects.hash(this.physicalSchema, this.port, this.hostname, this.database, this.username, this.password, this.serverId, this.tableName, this.serverTimeZone, this.dbzProperties, this.enableParallelRead, this.splitSize, this.splitMetaGroupSize, this.fetchSize, this.connectTimeout, this.connectMaxRetries, this.connectionPoolSize, this.distributionFactorUpper, this.distributionFactorLower, this.startupOptions, this.producedDataType, this.metadataKeys, this.scanNewlyAddedTableEnabled, this.jdbcProperties, this.heartbeatInterval, this.chunkKeyColumn);
    }

    public String asSummaryString() {
        return "MySQL-CDC";
    }
}

