/*
 * Decompiled with CFR 0.152.
 */
package com.hitrust.trustpay.client;

public class DataVerifier {
    public static boolean isValidDate(String aString) {
        boolean tResult;
        block7: {
            int tDD;
            block6: {
                tResult = false;
                if (aString.length() != 10) {
                    return false;
                }
                if (aString.charAt(4) != '/' || aString.charAt(7) != '/') {
                    return false;
                }
                int tYYYY = Integer.parseInt(aString.substring(0, 4));
                int tMM = Integer.parseInt(aString.substring(5, 7));
                tDD = Integer.parseInt(aString.substring(8, 10));
                if (tMM >= 1 && tMM <= 12) break block6;
                return false;
            }
            if (tDD >= 1 && tDD <= 31) break block7;
            return false;
        }
        try {
            tResult = true;
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return tResult;
    }

    public static boolean isValidTime(String aString) {
        boolean tResult;
        block9: {
            int tSS;
            block8: {
                int tMM;
                block7: {
                    tResult = false;
                    if (aString.length() != 8) {
                        return false;
                    }
                    if (aString.charAt(2) != ':' || aString.charAt(5) != ':') {
                        return false;
                    }
                    int tHH = Integer.parseInt(aString.substring(0, 2));
                    tMM = Integer.parseInt(aString.substring(3, 5));
                    tSS = Integer.parseInt(aString.substring(6, 8));
                    if (tHH >= 0 && tHH <= 23) break block7;
                    return false;
                }
                if (tMM >= 0 && tMM <= 59) break block8;
                return false;
            }
            if (tSS >= 0 && tSS <= 59) break block9;
            return false;
        }
        try {
            tResult = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tResult;
    }

    public static boolean isValidURL(String aString) {
        if (aString.length() < 20) {
            return false;
        }
        return aString.indexOf("http://") == 0 || aString.indexOf("https://") == 0;
    }

    public static boolean isValidAmount(double aAmount, int aExp) {
        String tAmountStr;
        boolean tResult = false;
        if (aExp >= 0 && (tAmountStr = new Double(aAmount).toString()).indexOf(46) >= tAmountStr.length() - aExp - 1) {
            tResult = true;
        }
        return tResult;
    }

    public static void main(String[] argc) {
        String tAmountStr;
        int i = 0;
        while (i < 9) {
            tAmountStr = "0.0" + i;
            if (!DataVerifier.isValidAmount(Double.parseDouble(tAmountStr), 2)) {
                System.out.println("Error!");
                return;
            }
            ++i;
        }
        i = 10;
        while (i < 100) {
            tAmountStr = "0." + i;
            if (!DataVerifier.isValidAmount(Double.parseDouble(tAmountStr), 2)) {
                System.out.println("Error!");
                return;
            }
            ++i;
        }
        i = 0;
        while (i < 9) {
            tAmountStr = "99999.0" + i;
            if (!DataVerifier.isValidAmount(Double.parseDouble(tAmountStr), 2)) {
                System.out.println("Error!");
                return;
            }
            ++i;
        }
        i = 1;
        while (i < 100) {
            tAmountStr = "0.00" + i;
            if (DataVerifier.isValidAmount(Double.parseDouble(tAmountStr), 2)) {
                System.out.println("Error!");
                return;
            }
            ++i;
        }
        System.out.println("Testing Completed!");
    }

    public static boolean isValidString(String sValue) {
        if (sValue == null) {
            return false;
        }
        return !"".equals(sValue);
    }

    public static boolean isValidString(String sValue, int len) {
        if (sValue == null) {
            return false;
        }
        return !"".equals(sValue) && sValue.length() <= len;
    }

    public static boolean isValidCertificate(String sCertificateType, String sCertificateNo) {
        if ("|I|P|S|J|K|T|F|D|W|U|R|B|A|C|E|G|H|L|M|".indexOf("|" + sCertificateType + "|") == -1) {
            return false;
        }
        if (sCertificateNo == null) {
            return false;
        }
        int len = sCertificateNo.length();
        if (!"I".equals(sCertificateType)) {
            return true;
        }
        return len == 15 || len == 18;
    }

    public static boolean isValidCertificateNo(String sCertificateNo) {
        if (sCertificateNo == null) {
            return false;
        }
        int len = sCertificateNo.length();
        return len == 15 || len == 18;
    }

    public static boolean isValidBankCardNo(String iBankCardNo) {
        if (!DataVerifier.isValidString(iBankCardNo, 20)) {
            return false;
        }
        String numeric = "1234567890";
        int i = 0;
        while (i < iBankCardNo.length()) {
            String character = iBankCardNo.substring(i, i + 1);
            if (numeric.indexOf(character) == -1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isValidDate8(String sDate) {
        boolean tResult;
        block13: {
            int tDD;
            block14: {
                int tMM;
                int tYYYY;
                block12: {
                    block11: {
                        block10: {
                            tResult = false;
                            if (sDate == null) {
                                return false;
                            }
                            if (sDate.length() != 8) {
                                return false;
                            }
                            try {
                                tYYYY = Integer.parseInt(sDate.substring(0, 4));
                                tMM = Integer.parseInt(sDate.substring(4, 6));
                                tDD = Integer.parseInt(sDate.substring(6, 8));
                                if (tMM >= 1 && tMM <= 12) break block10;
                                return false;
                            }
                            catch (Exception e) {
                                return false;
                            }
                        }
                        if (tDD >= 1 && tDD <= 31) break block11;
                        return false;
                    }
                    if (tMM != 4 && tMM != 6 && tMM != 9 && tMM != 11 || tDD <= 30) break block12;
                    return false;
                }
                if (tMM != 2) break block13;
                if ((tYYYY % 4 != 0 || tYYYY % 100 == 0) && tYYYY % 400 != 0) break block14;
                if (tDD > 29) {
                    return false;
                }
                break block13;
            }
            if (tDD <= 28) break block13;
            return false;
        }
        tResult = true;
        return tResult;
    }

    public static boolean isValidDateTime(String aString) {
        boolean tResult;
        block13: {
            int tSS;
            block12: {
                int MM;
                int tMM;
                block11: {
                    int tHH;
                    block10: {
                        int tDD;
                        block9: {
                            tResult = false;
                            if (aString.length() != 19) {
                                return false;
                            }
                            if (aString.charAt(4) != '-' || aString.charAt(7) != '-' || aString.charAt(10) != ' ' || aString.charAt(13) != ':' || aString.charAt(16) != ':') {
                                return false;
                            }
                            int tYYYY = Integer.parseInt(aString.substring(0, 4));
                            tMM = Integer.parseInt(aString.substring(5, 7));
                            tDD = Integer.parseInt(aString.substring(8, 10));
                            tHH = Integer.parseInt(aString.substring(11, 13));
                            MM = Integer.parseInt(aString.substring(14, 16));
                            tSS = Integer.parseInt(aString.substring(17, 19));
                            if (tMM >= 1 && tMM <= 12) break block9;
                            return false;
                        }
                        if (tDD >= 1 && tDD <= 31) break block10;
                        return false;
                    }
                    if (tHH >= 0 && tHH <= 23) break block11;
                    return false;
                }
                if (MM >= 0 && tMM <= 59) break block12;
                return false;
            }
            if (tSS >= 0 && tSS <= 59) break block13;
            return false;
        }
        try {
            tResult = true;
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return tResult;
    }
}

