/*
 * Decompiled with CFR 0.152.
 */
package com.hitrust.trustpay.client;

import com.hitrust.trustpay.client.Base64;
import com.hitrust.trustpay.client.LogWriter;
import com.hitrust.trustpay.client.MerchantConfig;
import com.hitrust.trustpay.client.TrxException;
import com.hitrust.trustpay.client.TrxResponse;
import com.hitrust.trustpay.client.XMLDocument;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import javax.net.ssl.SSLSocket;

public abstract class TrxRequest {
    private LogWriter iLogWriter = null;
    private String iECMerchantType = "";
    public static final String EC_MERCHANT_TYPE_B2C = "B2C";
    public static final String EC_MERCHANT_TYPE_B2B = "B2B";
    protected MerchantConfig tMerchantConfig = null;
    private String tRequestMesg = "";

    public TrxRequest(String aECMerchantType) {
        this.iECMerchantType = aECMerchantType;
    }

    public TrxResponse postRequest() {
        return this.extendPostRequest(1);
    }

    public TrxResponse extendPostRequest(int i) {
        TrxResponse tTrxResponse;
        block19: {
            tTrxResponse = null;
            try {
                try {
                    this.iLogWriter = new LogWriter();
                    this.iLogWriter.logNewLine("TrustPayClient Java V2.0 \u4ea4\u6613\u5f00\u59cb==========================");
                    this.iLogWriter.logNewLine("\u68c0\u67e5\u4ea4\u6613\u8bf7\u6c42\u662f\u5426\u5408\u6cd5\uff1a");
                    this.checkRequest();
                    this.iLogWriter.logNewLine("\u6b63\u786e");
                    this.tMerchantConfig = MerchantConfig.getUniqueInstance();
                    this.iLogWriter.logNewLine("\u4ea4\u6613\u62a5\u6587\uff1a");
                    XMLDocument tRequestMessage = this.getRequestMessage();
                    this.iLogWriter.logNewLine("\u5b8c\u6574\u4ea4\u6613\u62a5\u6587\uff1a");
                    tRequestMessage = this.composeRequestMessage(i, tRequestMessage);
                    this.iLogWriter.logNewLine("\u7b7e\u540d\u540e\u7684\u62a5\u6587\uff1a");
                    tRequestMessage = this.tMerchantConfig.signMessage(i, tRequestMessage);
                    this.iLogWriter.logNewLine("\u53d1\u9001\u4ea4\u6613\u62a5\u6587\u81f3\u7f51\u4e0a\u652f\u4ed8\u5e73\u53f0\uff1a");
                    XMLDocument tResponseMessage = this.sendMessage(tRequestMessage);
                    this.iLogWriter.logNewLine("\u9a8c\u8bc1\u7f51\u4e0a\u652f\u4ed8\u5e73\u53f0\u54cd\u5e94\u62a5\u6587\u7684\u7b7e\u540d\uff1a");
                    tResponseMessage = this.tMerchantConfig.verifySign(tResponseMessage);
                    this.iLogWriter.log("\u6b63\u786e");
                    this.iLogWriter.logNewLine("\u751f\u6210\u4ea4\u6613\u54cd\u5e94\u5bf9\u8c61\uff1a");
                    tTrxResponse = this.constructResponse(tResponseMessage);
                    this.iLogWriter.logNewLine("\u4ea4\u6613\u7ed3\u679c\uff1a[" + tTrxResponse.getReturnCode() + "]");
                    this.iLogWriter.logNewLine("\u9519\u8bef\u4fe1\u606f\uff1a[" + tTrxResponse.getErrorMessage() + "]");
                }
                catch (TrxException e) {
                    tTrxResponse = new TrxResponse(e.getCode(), String.valueOf(e.getMessage()) + " - " + e.getDetailMessage());
                    if (this.iLogWriter != null) {
                        this.iLogWriter.logNewLine("\u9519\u8bef\u4ee3\u7801\uff1a[" + tTrxResponse.getReturnCode() + "]    \u9519\u8bef\u4fe1\u606f\uff1a[" + tTrxResponse.getErrorMessage() + "]");
                    }
                    if (this.iLogWriter != null) {
                        this.iLogWriter.logNewLine("\u4ea4\u6613\u7ed3\u675f==================================================");
                        try {
                            this.iLogWriter.closeWriter(MerchantConfig.getTrxLogFile());
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (Exception e) {
                    tTrxResponse = new TrxResponse("1999", "\u7cfb\u7edf\u53d1\u751f\u65e0\u6cd5\u9884\u671f\u7684\u9519\u8bef - " + e.getMessage());
                    e.printStackTrace(System.err);
                    if (this.iLogWriter != null) {
                        this.iLogWriter.logNewLine("\u9519\u8bef\u4ee3\u7801\uff1a[" + tTrxResponse.getReturnCode() + "]    \u9519\u8bef\u4fe1\u606f\uff1a[" + tTrxResponse.getErrorMessage() + "]");
                    }
                    if (this.iLogWriter == null) break block19;
                    this.iLogWriter.logNewLine("\u4ea4\u6613\u7ed3\u675f==================================================");
                    try {
                        this.iLogWriter.closeWriter(MerchantConfig.getTrxLogFile());
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                if (this.iLogWriter != null) {
                    this.iLogWriter.logNewLine("\u4ea4\u6613\u7ed3\u675f==================================================");
                    try {
                        this.iLogWriter.closeWriter(MerchantConfig.getTrxLogFile());
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return tTrxResponse;
    }

    public TrxResponse extendPostCBPRequest(int i, String TrustPayCBPTrxURL) {
        TrxResponse tTrxResponse;
        block19: {
            tTrxResponse = null;
            try {
                try {
                    this.iLogWriter = new LogWriter();
                    this.iLogWriter.logNewLine("CBPTrustPayClient Java V2.0 \u4ea4\u6613\u5f00\u59cb==========================");
                    this.iLogWriter.logNewLine("CBP\u68c0\u67e5\u4ea4\u6613\u8bf7\u6c42\u662f\u5426\u5408\u6cd5\uff1a");
                    this.checkRequest();
                    this.iLogWriter.logNewLine("\u6b63\u786e");
                    this.tMerchantConfig = MerchantConfig.getUniqueInstance();
                    this.iLogWriter.logNewLine("CBP\u4ea4\u6613\u62a5\u6587\uff1a");
                    XMLDocument tRequestMessage = this.getRequestMessage();
                    this.iLogWriter.logNewLine("CBP\u5b8c\u6574\u4ea4\u6613\u62a5\u6587\uff1a");
                    tRequestMessage = this.composeCBPRequestMessage(i, tRequestMessage);
                    this.iLogWriter.logNewLine("CBP\u7b7e\u540d\u540e\u7684\u62a5\u6587\uff1a");
                    tRequestMessage = this.tMerchantConfig.signMessage(i, tRequestMessage);
                    this.iLogWriter.logNewLine("CBP\u53d1\u9001\u4ea4\u6613\u62a5\u6587\u81f3\u7f51\u4e0a\u652f\u4ed8\u5e73\u53f0\uff1a");
                    XMLDocument tResponseMessage = this.sendCBPMessage(tRequestMessage, TrustPayCBPTrxURL);
                    this.iLogWriter.logNewLine("\u63a5\u6536\u62a5\u6587\uff1a");
                    this.iLogWriter.logNewLine(tResponseMessage.toString());
                    this.iLogWriter.logNewLine("\u751f\u6210\u4ea4\u6613\u54cd\u5e94\u5bf9\u8c61\uff1a");
                    tTrxResponse = this.constructResponse(tResponseMessage);
                    this.iLogWriter.logNewLine("\u4ea4\u6613\u7ed3\u679c\uff1a[" + tTrxResponse.getReturnCode() + "]");
                    this.iLogWriter.logNewLine("\u9519\u8bef\u4fe1\u606f\uff1a[" + tTrxResponse.getErrorMessage() + "]");
                }
                catch (TrxException e) {
                    tTrxResponse = new TrxResponse(e.getCode(), String.valueOf(e.getMessage()) + " - " + e.getDetailMessage());
                    if (this.iLogWriter != null) {
                        this.iLogWriter.logNewLine("CBP\u9519\u8bef\u4ee3\u7801\uff1a[" + tTrxResponse.getReturnCode() + "]    \u9519\u8bef\u4fe1\u606f\uff1a[" + tTrxResponse.getErrorMessage() + "]");
                    }
                    if (this.iLogWriter != null) {
                        this.iLogWriter.logNewLine("CBP\u4ea4\u6613\u7ed3\u675f==================================================");
                        try {
                            this.iLogWriter.closeWriter(MerchantConfig.getTrxLogFile());
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (Exception e) {
                    tTrxResponse = new TrxResponse("1999", "\u7cfb\u7edf\u53d1\u751f\u65e0\u6cd5\u9884\u671f\u7684\u9519\u8bef - " + e.getMessage());
                    e.printStackTrace(System.err);
                    if (this.iLogWriter != null) {
                        this.iLogWriter.logNewLine("CBP\u9519\u8bef\u4ee3\u7801\uff1a[" + tTrxResponse.getReturnCode() + "]    \u9519\u8bef\u4fe1\u606f\uff1a[" + tTrxResponse.getErrorMessage() + "]");
                    }
                    if (this.iLogWriter == null) break block19;
                    this.iLogWriter.logNewLine("CBP\u4ea4\u6613\u7ed3\u675f==================================================");
                    try {
                        this.iLogWriter.closeWriter(MerchantConfig.getTrxLogFile());
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                if (this.iLogWriter != null) {
                    this.iLogWriter.logNewLine("CBP\u4ea4\u6613\u7ed3\u675f==================================================");
                    try {
                        this.iLogWriter.closeWriter(MerchantConfig.getTrxLogFile());
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return tTrxResponse;
    }

    public String genSignature(int i) throws TrxException {
        try {
            try {
                this.iLogWriter = new LogWriter();
                this.iLogWriter.logNewLine("TrustPayClient Java V2.0 \u4ea4\u6613\u5f00\u59cb==========================");
                this.iLogWriter.logNewLine("\u68c0\u67e5\u4ea4\u6613\u8bf7\u6c42\u662f\u5426\u5408\u6cd5\uff1a");
                this.checkRequest();
                this.iLogWriter.logNewLine("\u6b63\u786e");
                this.tMerchantConfig = MerchantConfig.getUniqueInstance();
                this.iLogWriter.logNewLine("\u4ea4\u6613\u62a5\u6587\uff1a");
                XMLDocument tRequestMessage = this.getRequestMessage();
                this.iLogWriter.logNewLine(tRequestMessage.toString());
                this.iLogWriter.logNewLine("\u5b8c\u6574\u4ea4\u6613\u62a5\u6587\uff1a");
                tRequestMessage = this.composeRequestMessage(i, tRequestMessage);
                this.iLogWriter.logNewLine(tRequestMessage.toString());
                this.iLogWriter.logNewLine("\u7b7e\u540d\u540e\u7684\u62a5\u6587\uff1a");
                tRequestMessage = this.tMerchantConfig.signMessage(i, tRequestMessage);
                StringBuffer tTempStringBuffer = new StringBuffer("").append("<MSG>").append(tRequestMessage.toString()).append("</MSG>");
                this.tRequestMesg = tTempStringBuffer.toString();
                this.iLogWriter.logNewLine("\u63d0\u4ea4\u7f51\u4e0a\u652f\u4ed8\u5e73\u53f0\u7684\u62a5\u6587\uff1a\n" + tRequestMessage);
            }
            catch (TrxException e) {
                if (this.iLogWriter != null) {
                    this.iLogWriter.logNewLine("\u9519\u8bef\u4ee3\u7801\uff1a[" + e.getCode() + "]    \u9519\u8bef\u4fe1\u606f\uff1a[" + e.getMessage() + " - " + e.getDetailMessage() + "]");
                }
                throw new TrxException(e.getCode(), String.valueOf(e.getMessage()) + " - " + e.getDetailMessage());
            }
            catch (Exception e) {
                if (this.iLogWriter != null) {
                    this.iLogWriter.logNewLine("\u9519\u8bef\u4ee3\u7801\uff1a[1999]    \u9519\u8bef\u4fe1\u606f\uff1a[\u7cfb\u7edf\u53d1\u751f\u65e0\u6cd5\u9884\u671f\u7684\u9519\u8bef - " + e.getMessage() + "]");
                }
                throw new TrxException("1999", "\u7cfb\u7edf\u53d1\u751f\u65e0\u6cd5\u9884\u671f\u7684\u9519\u8bef - " + e.getMessage());
            }
        }
        finally {
            if (this.iLogWriter != null) {
                this.iLogWriter.logNewLine("\u4ea4\u6613\u7ed3\u675f==================================================");
                try {
                    this.iLogWriter.closeWriter(MerchantConfig.getTrxLogFile());
                }
                catch (Exception exception) {}
            }
        }
        return this.tRequestMesg;
    }

    public String genCBPSignature(int i) throws TrxException {
        try {
            try {
                this.iLogWriter = new LogWriter();
                this.iLogWriter.logNewLine("TrustPayClient Java V2.0 \u4ea4\u6613\u5f00\u59cb==========================");
                this.iLogWriter.logNewLine("\u68c0\u67e5\u4ea4\u6613\u8bf7\u6c42\u662f\u5426\u5408\u6cd5\uff1a");
                this.checkRequest();
                this.iLogWriter.logNewLine("\u6b63\u786e");
                this.tMerchantConfig = MerchantConfig.getUniqueInstance();
                this.iLogWriter.logNewLine("\u4ea4\u6613\u62a5\u6587\uff1a");
                XMLDocument tRequestMessage = this.getRequestMessage();
                this.iLogWriter.logNewLine(tRequestMessage.toString());
                this.iLogWriter.logNewLine("\u5b8c\u6574\u4ea4\u6613\u62a5\u6587\uff1a");
                tRequestMessage = this.composeCBPRequestMessage(i, tRequestMessage);
                this.iLogWriter.logNewLine(tRequestMessage.toString());
                this.iLogWriter.logNewLine("\u7b7e\u540d\u540e\u7684\u62a5\u6587\uff1a");
                tRequestMessage = this.tMerchantConfig.signMessage(i, tRequestMessage);
                StringBuffer tTempStringBuffer = new StringBuffer("").append("<MSG>").append(tRequestMessage.toString()).append("</MSG>");
                this.tRequestMesg = tTempStringBuffer.toString();
                this.iLogWriter.logNewLine("\u63d0\u4ea4\u7f51\u4e0a\u652f\u4ed8\u5e73\u53f0\u7684\u62a5\u6587\uff1a\n" + tRequestMessage);
            }
            catch (TrxException e) {
                if (this.iLogWriter != null) {
                    this.iLogWriter.logNewLine("\u9519\u8bef\u4ee3\u7801\uff1a[" + e.getCode() + "]    \u9519\u8bef\u4fe1\u606f\uff1a[" + e.getMessage() + " - " + e.getDetailMessage() + "]");
                }
                throw new TrxException(e.getCode(), String.valueOf(e.getMessage()) + " - " + e.getDetailMessage());
            }
            catch (Exception e) {
                if (this.iLogWriter != null) {
                    this.iLogWriter.logNewLine("\u9519\u8bef\u4ee3\u7801\uff1a[1999]    \u9519\u8bef\u4fe1\u606f\uff1a[\u7cfb\u7edf\u53d1\u751f\u65e0\u6cd5\u9884\u671f\u7684\u9519\u8bef - " + e.getMessage() + "]");
                }
                throw new TrxException("1999", "\u7cfb\u7edf\u53d1\u751f\u65e0\u6cd5\u9884\u671f\u7684\u9519\u8bef - " + e.getMessage());
            }
        }
        finally {
            if (this.iLogWriter != null) {
                this.iLogWriter.logNewLine("\u4ea4\u6613\u7ed3\u675f==================================================");
                try {
                    this.iLogWriter.closeWriter(MerchantConfig.getTrxLogFile());
                }
                catch (Exception exception) {}
            }
        }
        return this.tRequestMesg;
    }

    protected abstract void checkRequest() throws TrxException;

    protected abstract XMLDocument getRequestMessage() throws TrxException;

    private XMLDocument composeRequestMessage(int i, XMLDocument aMessage) throws TrxException {
        StringBuffer tMessage = new StringBuffer("");
        tMessage.append("<Merchant>").append("<ECMerchantType>").append(this.iECMerchantType).append("</ECMerchantType>").append("<MerchantID>").append(this.tMerchantConfig.getMerchantID(i)).append("</MerchantID>").append("</Merchant>").append(aMessage.toString());
        return new XMLDocument(tMessage.toString());
    }

    private XMLDocument composeCBPRequestMessage(int i, XMLDocument aMessage) throws TrxException {
        StringBuffer tMessage = new StringBuffer("");
        tMessage.append("<TrxRequest>").append("<MerchantID>").append(this.tMerchantConfig.getMerchantID(i)).append("</MerchantID>").append(aMessage.toString()).append("</TrxRequest>");
        return new XMLDocument(tMessage.toString());
    }

    private XMLDocument sendMessage(XMLDocument aMessage) throws TrxException {
        StringBuffer tTempStringBuffer = new StringBuffer("").append("<MSG>").append(aMessage.toString()).append("</MSG>");
        String tMessage = tTempStringBuffer.toString();
        this.iLogWriter.logNewLine("\u63d0\u4ea4\u7f51\u4e0a\u652f\u4ed8\u5e73\u53f0\u7684\u62a5\u6587\uff1a\n" + tMessage);
        int tContentLength = 0;
        try {
            tContentLength = tMessage.getBytes("UTF-8").length;
            this.iLogWriter.logNewLine("\u62a5\u6587\u957f\u5ea6\uff1a" + tContentLength);
            if (tContentLength > 8000) {
                throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u62a5\u6587\u957f\u5ea6\u8d85\u8fc78000Bytes");
            }
        }
        catch (TrxException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            throw new TrxException("1999", "\u7cfb\u7edf\u53d1\u751f\u65e0\u6cd5\u9884\u671f\u7684\u9519\u8bef", e.getMessage());
        }
        String tResponseMessage = "";
        XMLDocument tTrxResponse = null;
        Socket tSocket = null;
        PrintWriter tOut = null;
        BufferedReader tIn = null;
        try {
            try {
                this.iLogWriter.logNewLine("\u8fde\u7ebf\u7f51\u4e0a\u652f\u4ed8\u5e73\u53f0\uff1a");
                if (this.tMerchantConfig.getTrustPayConnectMethod().equals("https")) {
                    SSLSocket tSSLSocket = (SSLSocket)this.tMerchantConfig.getSSLSocketFactory().createSocket(InetAddress.getByName(this.tMerchantConfig.getTrustPayServerName()), this.tMerchantConfig.getTrustPayServerPort());
                    tSSLSocket.startHandshake();
                    tSocket = tSSLSocket;
                } else {
                    tSocket = new Socket(InetAddress.getByName(this.tMerchantConfig.getTrustPayServerName()), this.tMerchantConfig.getTrustPayServerPort());
                }
                this.iLogWriter.log("\u6210\u529f");
                this.iLogWriter.logNewLine("\u63d0\u4ea4\u4ea4\u6613\u62a5\u6587\uff1a");
                StringBuffer tHttpRequest = new StringBuffer("").append("POST ").append(this.tMerchantConfig.getTrustPayTrxURL()).append(" HTTP/1.1").append(this.tMerchantConfig.getTrustPayNewLine()).append("User-Agent: Java/1.3.1").append(this.tMerchantConfig.getTrustPayNewLine()).append("Host: ").append(this.tMerchantConfig.getTrustPayServerName()).append(this.tMerchantConfig.getTrustPayNewLine()).append("Accept: text/html, image/gif, image/jpeg, *; q=.2, * /*; q=.2").append(this.tMerchantConfig.getTrustPayNewLine()).append("Connection: keep-alive").append(this.tMerchantConfig.getTrustPayNewLine()).append("Content-Type: application/x-www-form-urlencoded").append(this.tMerchantConfig.getTrustPayNewLine()).append("Content-Length: ").append(tContentLength).append(this.tMerchantConfig.getTrustPayNewLine()).append(this.tMerchantConfig.getTrustPayNewLine()).append(tMessage);
                tOut = new PrintWriter(new BufferedWriter(new OutputStreamWriter(tSocket.getOutputStream(), "UTF-8")));
                tOut.write(tHttpRequest.toString());
                tOut.println();
                tOut.flush();
                this.iLogWriter.log("\u6210\u529f");
                this.iLogWriter.logNewLine("\u7b49\u5f85\u7f51\u4e0a\u652f\u4ed8\u5e73\u53f0\u8fd4\u56de\u4ea4\u6613\u7ed3\u679c\uff1a");
                tIn = new BufferedReader(new InputStreamReader(tSocket.getInputStream(), "GB2312"));
                String tLine = null;
                while ((tLine = tIn.readLine()) != null) {
                    tResponseMessage = String.valueOf(tResponseMessage) + tLine;
                    if (tLine.indexOf("</MSG>") != -1) break;
                }
                this.iLogWriter.log("\u6210\u529f");
                this.iLogWriter.logNewLine("\u8fd4\u56de\u62a5\u6587\uff1a");
                this.iLogWriter.log("\n" + tResponseMessage.toString());
                if (tResponseMessage.indexOf("HTTP/1.1 200") == -1) {
                    throw new TrxException("1206", "\u7f51\u4e0a\u652f\u4ed8\u5e73\u53f0\u670d\u52a1\u6682\u65f6\u505c\u6b62");
                }
                tTrxResponse = new XMLDocument(tResponseMessage).getValue("MSG");
                if (tTrxResponse == null) {
                    throw new TrxException("1205", "\u65e0\u6cd5\u8fa8\u8bc6\u7f51\u4e0a\u652f\u4ed8\u5e73\u53f0\u7684\u54cd\u5e94\u62a5\u6587", "\u65e0[MSG]\u6bb5\uff01");
                }
            }
            catch (TrxException e) {
                throw e;
            }
            catch (UnknownHostException e) {
                e.printStackTrace(System.out);
                throw new TrxException("1201", "\u65e0\u6cd5\u8fde\u7ebf\u7f51\u4e0a\u652f\u4ed8\u5e73\u53f0", "\u65e0\u6cd5\u53d6\u5f97[" + this.tMerchantConfig.getTrustPayServerName() + "]\u7684IP\u5730\u5740!");
            }
            catch (ConnectException e) {
                e.printStackTrace(System.out);
                throw new TrxException("1201", "\u65e0\u6cd5\u8fde\u7ebf\u7f51\u4e0a\u652f\u4ed8\u5e73\u53f0", "\u65e0\u6cd5\u8fde\u7ebf" + this.tMerchantConfig.getTrustPayServerName() + "\u7684" + this.tMerchantConfig.getTrustPayServerPort() + "\u7aef\u53e3!");
            }
            catch (SocketException e) {
                e.printStackTrace(System.out);
                throw new TrxException("1202", "\u63d0\u4ea4\u4ea4\u6613\u65f6\u53d1\u751f\u7f51\u7edc\u9519\u8bef", "\u8fde\u7ebf\u4e2d\u65ad\uff01");
            }
            catch (IOException e) {
                e.printStackTrace(System.out);
                throw new TrxException("1202", "\u63d0\u4ea4\u4ea4\u6613\u65f6\u53d1\u751f\u7f51\u7edc\u9519\u8bef", "\u8fde\u7ebf\u4e2d\u65ad\uff01");
            }
        }
        finally {
            if (tIn != null) {
                try {
                    tIn.close();
                }
                catch (Exception exception) {}
            }
            if (tOut != null) {
                try {
                    tOut.close();
                }
                catch (Exception exception) {}
            }
            if (tSocket != null) {
                try {
                    tSocket.close();
                }
                catch (Exception exception) {}
            }
        }
        return tTrxResponse;
    }

    private XMLDocument sendCBPMessage(XMLDocument aMessage, String TrustPayCBPTrxURL) throws TrxException, UnsupportedEncodingException {
        StringBuffer tTempStringBuffer = new StringBuffer("").append("<MSG>").append(aMessage.toString()).append("</MSG>");
        String tMessage = tTempStringBuffer.toString();
        this.iLogWriter.logNewLine("CBP\u63d0\u4ea4\u7f51\u4e0a\u652f\u4ed8\u5e73\u53f0\u7684\u62a5\u6587\uff1a\n" + tMessage);
        Base64 tBase64 = new Base64();
        String tData = tBase64.encode(tMessage.getBytes("gb2312"));
        tData = URLEncoder.encode(tData);
        this.iLogWriter.logNewLine("CBP\u63d0\u4ea4\u7f51\u4e0a\u652f\u4ed8\u5e73\u53f0\u7ecf\u8fc7Base64\u52a0\u5bc6\u7684\u62a5\u6587\uff1a\n" + tData);
        tData = "MSG=" + tData;
        int tContentLength = 0;
        try {
            tContentLength = tData.length();
            this.iLogWriter.logNewLine("CBP\u62a5\u6587\u957f\u5ea6\uff1a" + tContentLength);
            if (tContentLength > 8000) {
                throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u62a5\u6587\u957f\u5ea6\u8d85\u8fc78000Bytes");
            }
        }
        catch (TrxException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            throw new TrxException("1999", "\u7cfb\u7edf\u53d1\u751f\u65e0\u6cd5\u9884\u671f\u7684\u9519\u8bef", e.getMessage());
        }
        Socket tSocket = null;
        PrintWriter tOut = null;
        BufferedReader tIn = null;
        XMLDocument tTrxResponse = null;
        try {
            try {
                this.iLogWriter.logNewLine("CBP\u8fde\u7ebf\u7f51\u4e0a\u652f\u4ed8\u5e73\u53f0\uff1a");
                if (this.tMerchantConfig.getTrustPayConnectMethod().equals("https")) {
                    SSLSocket tSSLSocket = (SSLSocket)this.tMerchantConfig.getSSLSocketFactory().createSocket(InetAddress.getByName(this.tMerchantConfig.getTrustPayServerName()), this.tMerchantConfig.getTrustPayServerPort());
                    tSSLSocket.startHandshake();
                    tSocket = tSSLSocket;
                } else {
                    tSocket = new Socket(InetAddress.getByName(this.tMerchantConfig.getTrustPayServerName()), this.tMerchantConfig.getTrustPayServerPort());
                }
                this.iLogWriter.log("CBP\u6210\u529f");
                this.iLogWriter.logNewLine("CBP\u63d0\u4ea4\u4ea4\u6613\u62a5\u6587\uff1a");
                String tResponseMessage = "";
                int start = TrustPayCBPTrxURL.indexOf("://") + 3;
                int end = TrustPayCBPTrxURL.indexOf("/", start);
                String str = TrustPayCBPTrxURL.substring(end, TrustPayCBPTrxURL.length());
                StringBuffer tHttpRequest = new StringBuffer("").append("POST ").append(str).append(" HTTP/1.1").append(this.tMerchantConfig.getTrustPayNewLine()).append("User-Agent: Java/1.3.1").append(this.tMerchantConfig.getTrustPayNewLine()).append("Host: ").append(this.tMerchantConfig.getTrustPayServerName()).append(this.tMerchantConfig.getTrustPayNewLine()).append("Accept: text/html, image/gif, image/jpeg, *; q=.2, * /*; q=.2").append(this.tMerchantConfig.getTrustPayNewLine()).append("Connection: keep-alive").append(this.tMerchantConfig.getTrustPayNewLine()).append("Content-Type: application/x-www-form-urlencoded").append(this.tMerchantConfig.getTrustPayNewLine()).append("Content-Length: ").append(tContentLength).append(this.tMerchantConfig.getTrustPayNewLine()).append(this.tMerchantConfig.getTrustPayNewLine()).append(tData);
                tOut = new PrintWriter(new BufferedWriter(new OutputStreamWriter(tSocket.getOutputStream(), "UTF-8")));
                tOut.write(tHttpRequest.toString());
                tOut.println();
                tOut.flush();
                this.iLogWriter.log("CBP\u6210\u529f");
                this.iLogWriter.logNewLine("\u7b49\u5f85\u7f51\u4e0a\u652f\u4ed8\u5e73\u53f0\u8fd4\u56de\u4ea4\u6613\u7ed3\u679c\uff1a");
                tIn = new BufferedReader(new InputStreamReader(tSocket.getInputStream(), "GB2312"));
                String tLine = null;
                while ((tLine = tIn.readLine()) != null) {
                    if (tLine.indexOf("<NotifyStatus>") != -1) {
                        tResponseMessage = String.valueOf(tResponseMessage) + tLine;
                    }
                    if (tLine.indexOf("</NotifyStatus>") != -1) break;
                }
                this.iLogWriter.log("\u6210\u529f");
                this.iLogWriter.logNewLine("\u8fd4\u56de\u62a5\u6587\uff1a");
                this.iLogWriter.log("\n" + tResponseMessage.toString());
                if (tResponseMessage.indexOf("<NotifyStatus>") == -1) {
                    throw new TrxException("1203", "\u65e0\u6cd5\u63a5\u6536\u5230\u7f51\u4e0a\u652f\u4ed8\u5e73\u53f0\u7684\u54cd\u5e94");
                }
                tTrxResponse = new XMLDocument(tResponseMessage);
            }
            catch (TrxException e) {
                throw e;
            }
            catch (UnknownHostException e) {
                e.printStackTrace(System.out);
                throw new TrxException("1201", "\u65e0\u6cd5\u8fde\u7ebf\u7f51\u4e0a\u652f\u4ed8\u5e73\u53f0", "\u65e0\u6cd5\u53d6\u5f97[" + this.tMerchantConfig.getTrustPayServerName() + "]\u7684IP\u5730\u5740!");
            }
            catch (ConnectException e) {
                e.printStackTrace(System.out);
                throw new TrxException("1201", "\u65e0\u6cd5\u8fde\u7ebf\u7f51\u4e0a\u652f\u4ed8\u5e73\u53f0", "\u65e0\u6cd5\u8fde\u7ebf" + this.tMerchantConfig.getTrustPayServerName() + "\u7684" + this.tMerchantConfig.getTrustPayServerPort() + "\u7aef\u53e3!");
            }
            catch (SocketException e) {
                e.printStackTrace(System.out);
                throw new TrxException("1202", "\u63d0\u4ea4\u4ea4\u6613\u65f6\u53d1\u751f\u7f51\u7edc\u9519\u8bef", "\u8fde\u7ebf\u4e2d\u65ad\uff01");
            }
            catch (IOException e) {
                e.printStackTrace(System.out);
                throw new TrxException("1202", "\u63d0\u4ea4\u4ea4\u6613\u65f6\u53d1\u751f\u7f51\u7edc\u9519\u8bef", "\u8fde\u7ebf\u4e2d\u65ad\uff01");
            }
        }
        finally {
            if (tIn != null) {
                try {
                    tIn.close();
                }
                catch (Exception exception) {}
            }
            if (tOut != null) {
                try {
                    tOut.close();
                }
                catch (Exception exception) {}
            }
            if (tSocket != null) {
                try {
                    tSocket.close();
                }
                catch (Exception exception) {}
            }
        }
        return tTrxResponse;
    }

    protected abstract TrxResponse constructResponse(XMLDocument var1) throws TrxException;
}

