/*
 * Decompiled with CFR 0.152.
 */
package com.hitrust.trustpay.client.b2c;

import com.hitrust.trustpay.client.DoubleUtil;
import com.hitrust.trustpay.client.TrxException;
import com.hitrust.trustpay.client.TrxRequest;
import com.hitrust.trustpay.client.TrxResponse;
import com.hitrust.trustpay.client.XMLDocument;
import com.hitrust.trustpay.client.b2c.AgentBatch;
import com.hitrust.trustpay.client.b2c.AgentBatchDetail;
import java.util.Vector;

public class B2CAgentBatchRequest
extends TrxRequest {
    private final int MAXSUMCOUNT = 100;
    int iSumCount = 0;
    private double iSumAmount = 0.0;
    private AgentBatch iAgentBatch = null;
    private AgentBatchDetail iAgentBatchDetail = null;
    private Vector iAgentBatchDetailList = new Vector();

    public B2CAgentBatchRequest() {
        super("B2C");
    }

    public void addAgentBatchDetail(AgentBatchDetail iAgentBatchDetail) {
        this.iAgentBatchDetailList.add(iAgentBatchDetail);
        ++this.iSumCount;
        this.iSumAmount += iAgentBatchDetail.getOrderAmount();
    }

    protected void checkRequest() throws TrxException {
        if (this.iAgentBatch == null) {
            throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u6279\u6b21\u4fe1\u606f\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        if (this.iAgentBatch.getAgentCount() != this.iSumCount) {
            throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u6279\u5185\u660e\u7ec6\u5408\u8ba1\u7b14\u6570(" + this.iAgentBatch.getAgentCount() + ")\u4e0e\u6279\u6b21\u7684\u603b\u7b14\u6570(" + this.iSumCount + ")\u4e0d\u7b26");
        }
        if (this.iSumCount > 100) {
            throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u6279\u6b21\u7684\u603b\u7b14\u6570(" + this.iSumCount + ")\u8d85\u8fc7\u6700\u5927\u9650\u5236(" + 100 + ")");
        }
        String sAgentAmount = "";
        String sSumAmount = "";
        try {
            sAgentAmount = DoubleUtil.getFormatDoubletoString(this.iAgentBatch.getAgentAmount());
            sSumAmount = DoubleUtil.getFormatDoubletoString(this.iSumAmount);
        }
        catch (Exception e) {
            throw new TrxException("\u7cfb\u7edf\u53d1\u751f\u65e0\u6cd5\u9884\u671f\u7684\u9519\u8bef", "\u7cfb\u7edf\u53d1\u751f\u65e0\u6cd5\u9884\u671f\u7684\u9519\u8bef");
        }
        if (!sAgentAmount.equals(sSumAmount)) {
            throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u6279\u5185\u660e\u7ec6\u5408\u8ba1\u91d1\u989d(" + this.iAgentBatch.getAgentAmount() + ")\u4e0e\u6279\u6b21\u7684\u603b\u91d1\u989d(" + this.iSumAmount + ")\u4e0d\u7b26");
        }
        this.iAgentBatch.checkRequest();
        int iSize = this.iAgentBatchDetailList.size();
        int i = 0;
        while (i < iSize) {
            AgentBatchDetail aAgentBatchDetail = (AgentBatchDetail)this.iAgentBatchDetailList.get(i);
            aAgentBatchDetail.checkRequest();
            ++i;
        }
    }

    protected TrxResponse constructResponse(XMLDocument aResponseMessage) throws TrxException {
        return new TrxResponse(aResponseMessage);
    }

    public Vector getBatchItems() {
        return this.iAgentBatchDetailList;
    }

    protected String getAgentBatchDetailMessage() {
        StringBuffer tMessage = new StringBuffer();
        tMessage.append("<Details>");
        int i = 0;
        while (i < this.iAgentBatchDetailList.size()) {
            tMessage.append("<Detail>").append("<ON>").append(((AgentBatchDetail)this.iAgentBatchDetailList.get(i)).getOrderNo()).append("</ON>").append("<OA>").append(((AgentBatchDetail)this.iAgentBatchDetailList.get(i)).getOrderAmount()).append("</OA>").append("<CertNo>").append(((AgentBatchDetail)this.iAgentBatchDetailList.get(i)).getCertificateNo()).append("</CertNo>").append("<CID>").append(((AgentBatchDetail)this.iAgentBatchDetailList.get(i)).getContractID()).append("</CID>").append("<PID>").append(((AgentBatchDetail)this.iAgentBatchDetailList.get(i)).getProductID()).append("</PID>").append("<PName>").append(((AgentBatchDetail)this.iAgentBatchDetailList.get(i)).getProductName()).append("</PName>").append("<PNum>").append(((AgentBatchDetail)this.iAgentBatchDetailList.get(i)).getProductNum()).append("</PNum>").append("<ExpiredDate>").append(((AgentBatchDetail)this.iAgentBatchDetailList.get(i)).getExpiredDate()).append("</ExpiredDate>").append("</Detail>");
            ++i;
        }
        tMessage.append("</Details>");
        return tMessage.toString();
    }

    protected XMLDocument getRequestMessage() {
        StringBuffer tMessage = new StringBuffer("").append("<TrxRequest>").append("<TrxType>").append("AgentBatch").append("</TrxType>").append("<AgentBatch>").append("<BatchNo>").append(this.iAgentBatch.getBatchNo()).append("</BatchNo>").append("<BatchDate>").append(this.iAgentBatch.getBatchDate()).append("</BatchDate>").append("<BatchTime>").append(System.currentTimeMillis()).append("</BatchTime>").append("<AgentAmount>").append(this.iAgentBatch.getAgentAmount()).append("</AgentAmount>").append("<AgentCount>").append(this.iAgentBatch.getAgentCount()).append("</AgentCount>").append("</AgentBatch>").append(this.getAgentBatchDetailMessage()).append("</TrxRequest>");
        System.out.println(tMessage.toString());
        return new XMLDocument(tMessage.toString());
    }

    public Vector getAgentBatchDetail() {
        return this.iAgentBatchDetailList;
    }

    public AgentBatch getAgentBatch() {
        return this.iAgentBatch;
    }

    public void setAgentBatch(AgentBatch aAgentBatch) {
        this.iAgentBatch = aAgentBatch;
    }

    public static void main(String[] args) {
    }
}

