/*
 * Decompiled with CFR 0.152.
 */
package com.hitrust.trustpay.client.b2c;

import com.hitrust.trustpay.client.DataVerifier;
import com.hitrust.trustpay.client.TrxException;
import com.hitrust.trustpay.client.TrxRequest;
import com.hitrust.trustpay.client.TrxResponse;
import com.hitrust.trustpay.client.XMLDocument;

public class B2CAgentUnsignContractRequest
extends TrxRequest {
    public static final String NOTIFY_TYPE_URL = "0";
    public static final String NOTIFY_TYPE_SERVER = "1";
    private String iResultNotifyURL = null;
    private String iCertificateNo = "";
    private String iCertificateType = "";
    private String iRequestDate = "";
    private String iRequestTime = "";
    private String iOrderNo = "";
    private String iNotifyType = "";
    private String iAgentSignNo = "";
    public static final int RESULT_NOTIFY_URL_LEN = 200;

    public B2CAgentUnsignContractRequest() {
        super("B2C");
    }

    public B2CAgentUnsignContractRequest(XMLDocument aXMLDocument) {
        super("B2C");
        this.setICertificateType(aXMLDocument.getValueNoNull("CertificateType"));
        this.setICertificateNo(aXMLDocument.getValueNoNull("CertificateNo"));
        this.setIResultNotifyURL(aXMLDocument.getValueNoNull("ResultNotifyURL"));
        this.setINotifyType(aXMLDocument.getValueNoNull("NotifyType"));
        this.setIRequestDate(aXMLDocument.getValueNoNull("OrderDate"));
        this.setIRequestTime(aXMLDocument.getValueNoNull("OrderTime"));
        this.setIOrderNo(aXMLDocument.getValueNoNull("OrderNo"));
        this.setIAgentSignNo(aXMLDocument.getValueNoNull("AgentSignNo"));
    }

    public String getIResultNotifyURL() {
        return this.iResultNotifyURL;
    }

    public void setIResultNotifyURL(String resultNotifyURL) {
        this.iResultNotifyURL = resultNotifyURL;
    }

    public String getICertificateNo() {
        return this.iCertificateNo;
    }

    public void setICertificateNo(String certificateNo) {
        this.iCertificateNo = certificateNo;
    }

    public String getICertificateType() {
        return this.iCertificateType;
    }

    public void setICertificateType(String certificateType) {
        this.iCertificateType = certificateType;
    }

    public String getIRequestDate() {
        return this.iRequestDate;
    }

    public void setIRequestDate(String requestDate) {
        this.iRequestDate = requestDate;
    }

    public String getIRequestTime() {
        return this.iRequestTime;
    }

    public void setIRequestTime(String requestTime) {
        this.iRequestTime = requestTime;
    }

    public String getIOrderNo() {
        return this.iOrderNo;
    }

    public void setIOrderNo(String orderNo) {
        this.iOrderNo = orderNo;
    }

    public String getINotifyType() {
        return this.iNotifyType;
    }

    public void setINotifyType(String notifyType) {
        this.iNotifyType = notifyType;
    }

    public String getIAgentSignNo() {
        return this.iAgentSignNo;
    }

    public void setIAgentSignNo(String agentSignNo) {
        this.iAgentSignNo = agentSignNo;
    }

    protected void checkRequest() throws TrxException {
        if (!DataVerifier.isValidString(this.iResultNotifyURL)) {
            throw new TrxException("1100", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u9a8c\u8bc1\u7ed3\u679c\u56de\u4f20\u7f51\u5740\u4e0d\u5408\u6cd5");
        }
        if (!DataVerifier.isValidString(this.iOrderNo)) {
            throw new TrxException("1100", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u8ba2\u5355\u53f7\u4e0d\u5408\u6cd5");
        }
        if (!DataVerifier.isValidString(this.iRequestDate)) {
            throw new TrxException("1100", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u8ba2\u5355\u65e5\u671f\u4e0d\u5408\u6cd5");
        }
        if (!DataVerifier.isValidString(this.iRequestTime)) {
            throw new TrxException("1100", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u8ba2\u5355\u65f6\u95f4\u4e0d\u5408\u6cd5");
        }
        if (!DataVerifier.isValidString(this.iAgentSignNo)) {
            throw new TrxException("1100", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u7b7e\u7ea6\u534f\u8bae\u53f7\u4e0d\u5408\u6cd5");
        }
        if (!DataVerifier.isValidString(this.iCertificateType)) {
            throw new TrxException("1100", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u5ba2\u6237\u8bc1\u4ef6\u7c7b\u578b\u4e0d\u5408\u6cd5");
        }
        if (!DataVerifier.isValidString(this.iCertificateNo)) {
            throw new TrxException("1100", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u5ba2\u6237\u8bc1\u4ef6\u53f7\u7801\u4e0d\u5408\u6cd5");
        }
        if (!DataVerifier.isValidString(this.iNotifyType)) {
            throw new TrxException("1100", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u901a\u77e5\u7c7b\u578b\u4e0d\u5408\u6cd5");
        }
        if (!this.iNotifyType.equals(NOTIFY_TYPE_URL) && !this.iNotifyType.equals(NOTIFY_TYPE_SERVER)) {
            throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u901a\u77e5\u7c7b\u578b\u672a\u5b9a\u4e49\uff01");
        }
        if (!DataVerifier.isValidCertificate(this.iCertificateType, this.iCertificateNo)) {
            throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u8bc1\u4ef6\u7c7b\u578b\u3001\u8bc1\u4ef6\u53f7\u7801\u4e0d\u5408\u6cd5");
        }
        if (!this.iCertificateType.equals("I")) {
            throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u8bc1\u4ef6\u7c7b\u578b\u5fc5\u987b\u4e3a\u516c\u6c11\u8eab\u4efd\u8bc1");
        }
        if (!DataVerifier.isValidURL(this.iResultNotifyURL)) {
            throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u7ed3\u679c\u56de\u4f20\u7f51\u5740\u4e0d\u5408\u6cd5");
        }
        if (this.iResultNotifyURL.getBytes().length > 200) {
            throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u9a8c\u8bc1\u7ed3\u679c\u56de\u4f20\u7f51\u5740\u4e0d\u5408\u6cd5\uff01");
        }
        if (!DataVerifier.isValidDate(this.iRequestDate)) {
            throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u8ba2\u5355\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        if (!DataVerifier.isValidTime(this.iRequestTime)) {
            throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u8ba2\u5355\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
    }

    protected TrxResponse constructResponse(XMLDocument aResponseMessage) throws TrxException {
        return new TrxResponse(aResponseMessage);
    }

    protected XMLDocument getRequestMessage() throws TrxException {
        StringBuffer tMessage = new StringBuffer("").append("<TrxRequest>").append("<TrxType>").append("AgentSign").append("</TrxType>").append("<CertificateType>").append(this.iCertificateType).append("</CertificateType>").append("<CertificateNo>").append(this.iCertificateNo).append("</CertificateNo>").append("<ResultNotifyURL>").append(this.iResultNotifyURL).append("</ResultNotifyURL>").append("<NotifyType>").append(this.iNotifyType).append("</NotifyType>").append("<OrderNo>").append(this.iOrderNo).append("</OrderNo>").append("<AgentSignNo>").append(this.iAgentSignNo).append("</AgentSignNo>").append("<OrderDate>").append(this.iRequestDate).append("</OrderDate>").append("<OrderTime>").append(this.iRequestTime).append("</OrderTime>").append("<IsSign>").append("Unsign").append("</IsSign>").append("</TrxRequest>");
        return new XMLDocument(tMessage.toString());
    }
}

