/*
 * Decompiled with CFR 0.152.
 */
package com.hitrust.trustpay.client.b2c;

import com.hitrust.trustpay.client.DataVerifier;
import com.hitrust.trustpay.client.TrxException;
import com.hitrust.trustpay.client.TrxRequest;
import com.hitrust.trustpay.client.TrxResponse;
import com.hitrust.trustpay.client.XMLDocument;

public class IdentityVerifyRequest
extends TrxRequest {
    private String iResultNotifyURL = "";
    private String iBankCardNo = "";
    private String iCertificateType = "";
    private String iCertificateNo = "";
    private String iRequestDate = "";
    private String iRequestTime = "";
    public static final int RESULT_NOTIFY_URL_LEN = 200;

    public IdentityVerifyRequest() {
        super("B2C");
    }

    public IdentityVerifyRequest(XMLDocument aXMLDocument) {
        super("B2C");
        this.setCertificateType(aXMLDocument.getValueNoNull("CertificateType"));
        this.setCertificateNo(aXMLDocument.getValueNoNull("CertificateNo"));
        this.setBankCardNo(aXMLDocument.getValueNoNull("BankCardNo"));
        this.setResultNotifyURL(aXMLDocument.getValueNoNull("ResultNotifyURL"));
        this.setRequestDate(aXMLDocument.getValueNoNull("OrderDate"));
        this.setRequestTime(aXMLDocument.getValueNoNull("OrderTime"));
    }

    protected XMLDocument getRequestMessage() {
        StringBuffer tMessage = new StringBuffer("").append("<TrxRequest>").append("<TrxType>").append("IdentityVerifyReq").append("</TrxType>").append("<CertificateType>").append(this.iCertificateType).append("</CertificateType>").append("<CertificateNo>").append(this.iCertificateNo).append("</CertificateNo>").append("<BankCardNo>").append(this.iBankCardNo).append("</BankCardNo>").append("<ResultNotifyURL>").append(this.iResultNotifyURL).append("</ResultNotifyURL>").append("<OrderDate>").append(this.iRequestDate).append("</OrderDate>").append("<OrderTime>").append(this.iRequestTime).append("</OrderTime>").append("</TrxRequest>");
        System.out.println("\u56de\u4f20\u4fe1\u606f\uff1a" + tMessage.toString());
        return new XMLDocument(tMessage.toString());
    }

    protected void checkRequest() throws TrxException {
        if (!DataVerifier.isValidString(this.iResultNotifyURL)) {
            throw new TrxException("1100", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u9a8c\u8bc1\u7ed3\u679c\u56de\u4f20\u7f51\u5740\u4e0d\u5408\u6cd5");
        }
        if (!DataVerifier.isValidString(this.iRequestDate)) {
            throw new TrxException("1100", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u8ba2\u5355\u65e5\u671f\u4e0d\u5408\u6cd5");
        }
        if (!DataVerifier.isValidString(this.iRequestTime)) {
            throw new TrxException("1100", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u8ba2\u5355\u65f6\u95f4\u4e0d\u5408\u6cd5");
        }
        if (!DataVerifier.isValidBankCardNo(this.iBankCardNo)) {
            throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u94f6\u884c\u5361\u53f7\u4e0d\u5408\u6cd5");
        }
        if (!DataVerifier.isValidCertificate(this.iCertificateType, this.iCertificateNo)) {
            throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u8bc1\u4ef6\u7c7b\u578b\u3001\u8bc1\u4ef6\u53f7\u7801\u4e0d\u5408\u6cd5");
        }
        if (!DataVerifier.isValidURL(this.iResultNotifyURL)) {
            throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u7ed3\u679c\u56de\u4f20\u7f51\u5740\u4e0d\u5408\u6cd5");
        }
        if (this.iResultNotifyURL.getBytes().length > 200) {
            throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u9a8c\u8bc1\u7ed3\u679c\u56de\u4f20\u7f51\u5740\u4e0d\u5408\u6cd5\uff01");
        }
        if (!DataVerifier.isValidDate(this.iRequestDate)) {
            throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u8ba2\u5355\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        if (!DataVerifier.isValidTime(this.iRequestTime)) {
            throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u8ba2\u5355\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
    }

    protected TrxResponse constructResponse(XMLDocument aResponseMessage) throws TrxException {
        return new TrxResponse(aResponseMessage);
    }

    public IdentityVerifyRequest setResultNotifyURL(String aResultNotifyURL) {
        this.iResultNotifyURL = aResultNotifyURL.trim();
        return this;
    }

    public String getResultNotifyURL() {
        return this.iResultNotifyURL;
    }

    public String getBankCardNo() {
        return this.iBankCardNo;
    }

    public String getCertificateNo() {
        return this.iCertificateNo;
    }

    public String getCertificateType() {
        return this.iCertificateType;
    }

    public String getRequestDate() {
        return this.iRequestDate;
    }

    public String getRequestTime() {
        return this.iRequestTime;
    }

    public void setBankCardNo(String string) {
        this.iBankCardNo = string;
    }

    public void setCertificateNo(String string) {
        this.iCertificateNo = string;
    }

    public void setCertificateType(String string) {
        this.iCertificateType = string;
    }

    public void setRequestDate(String string) {
        this.iRequestDate = string;
    }

    public void setRequestTime(String string) {
        this.iRequestTime = string;
    }
}

