/*
 * Decompiled with CFR 0.152.
 */
package com.hitrust.trustpay.client.b2c;

import com.hitrust.trustpay.client.Base64;
import com.hitrust.trustpay.client.LogWriter;
import com.hitrust.trustpay.client.MerchantConfig;
import com.hitrust.trustpay.client.TrxException;
import com.hitrust.trustpay.client.XMLDocument;
import java.io.UnsupportedEncodingException;

public class MerchantCBPReceiverPay {
    private LogWriter iLogWriter;
    protected MerchantConfig tMerchantConfig;
    private String iCBPOrderNo;
    private String iClientIP;
    private String iIsSuppCredit;
    private String iOrderDate;
    private String iResultURL;
    private double iOrderAmt;
    private String iReturnCode;
    private String iErrorMsg;

    public MerchantCBPReceiverPay setCBPOrdId(String aOrdId) {
        this.iCBPOrderNo = aOrdId;
        return this;
    }

    public String getCBPOrdId() {
        return this.iCBPOrderNo;
    }

    public MerchantCBPReceiverPay setClientIP(String aClientIP) {
        this.iClientIP = aClientIP;
        return this;
    }

    public String getClientIP() {
        return this.iClientIP;
    }

    public MerchantCBPReceiverPay setSupportCredit(String aSupportCredit) {
        this.iIsSuppCredit = aSupportCredit;
        return this;
    }

    public String getSupportCredit() {
        return this.iIsSuppCredit;
    }

    public MerchantCBPReceiverPay setOrderDate(String aOrderDate) {
        this.iOrderDate = aOrderDate;
        return this;
    }

    public String getOrderDate() {
        return this.iOrderDate;
    }

    public MerchantCBPReceiverPay setResultURL(String aResultURL) {
        this.iResultURL = aResultURL;
        return this;
    }

    public String getResultURL() {
        return this.iResultURL;
    }

    public MerchantCBPReceiverPay setOrderAmount(double aOrderAmount) {
        this.iOrderAmt = aOrderAmount;
        return this;
    }

    public double getOrderAmount() {
        return this.iOrderAmt;
    }

    public MerchantCBPReceiverPay setReturnCode(String aReturnCode) {
        this.iReturnCode = aReturnCode.trim();
        return this;
    }

    public String getReturnCode() {
        return this.iReturnCode;
    }

    public MerchantCBPReceiverPay setErrorMessage(String aErrorMessage) {
        this.iErrorMsg = aErrorMessage.trim();
        return this;
    }

    public String getErrorMessage() {
        return this.iErrorMsg;
    }

    public MerchantCBPReceiverPay(String aMessage) throws TrxException, UnsupportedEncodingException {
        block12: {
            this.iLogWriter = null;
            this.tMerchantConfig = null;
            this.iCBPOrderNo = "";
            this.iClientIP = "";
            this.iIsSuppCredit = "";
            this.iOrderDate = "";
            this.iResultURL = "";
            this.iOrderAmt = 0.0;
            this.iReturnCode = "";
            this.iErrorMsg = "";
            LogWriter tLogWriter = null;
            try {
                try {
                    tLogWriter = new LogWriter();
                    tLogWriter.logNewLine("CBPTrustPayClient Java V2.0\u9a8c\u8bc1\u519c\u884c\u652f\u4ed8\u5e73\u53f0\u652f\u4ed8\u8bf7\u6c42\u5f00\u59cb==========================");
                    tLogWriter.logNewLine("CBP\u63a5\u6536\u5230\u7684\u519c\u884c\u652f\u4ed8\u5e73\u53f0\u652f\u4ed8\u8bf7\u6c42\uff1a\n[" + aMessage + "]");
                    Base64 tBase64 = new Base64();
                    String tMessage = new String(tBase64.decode(aMessage), "gb2312");
                    tLogWriter.logNewLine("\u7ecf\u8fc7Base64\u89e3\u7801\u540e\u7684\u652f\u4ed8\u8bf7\u6c42\uff1a\n[" + tMessage + "]");
                    tLogWriter.logNewLine("\u9a8c\u8bc1\u652f\u4ed8\u8bf7\u6c42\u7684\u7b7e\u540d\uff1a");
                    XMLDocument tResult = MerchantConfig.getUniqueInstance().verifySign(new XMLDocument(tMessage));
                    tLogWriter.logNewLine("\u9a8c\u8bc1\u901a\u8fc7\uff01\n \u7ecf\u8fc7\u9a8c\u8bc1\u7684\u652f\u4ed8\u8bf7\u6c42\uff1a\n[" + tResult.toString() + "]");
                    this.initCBP(tResult);
                    this.setReturnCode("0000");
                    this.setErrorMessage("\u4ea4\u6613\u6210\u529f");
                }
                catch (TrxException e) {
                    tLogWriter.log("\u9a8c\u8bc1\u5931\u8d25\uff01\n");
                    this.setReturnCode(e.getCode());
                    this.setErrorMessage(String.valueOf(e.getMessage()) + "-" + e.getDetailMessage());
                    if (tLogWriter == null) break block12;
                    tLogWriter.logNewLine("\u4ea4\u6613\u7ed3\u675f==================================================");
                    try {
                        tLogWriter.closeWriter(MerchantConfig.getTrxLogFile("CBPRefundLog"));
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                if (tLogWriter != null) {
                    tLogWriter.logNewLine("\u4ea4\u6613\u7ed3\u675f==================================================");
                    try {
                        tLogWriter.closeWriter(MerchantConfig.getTrxLogFile("CBPRefundLog"));
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    protected void initCBP(XMLDocument aXMLDocument) throws TrxException {
        XMLDocument tOrdId = aXMLDocument.getValue("CBPOrderNo");
        if (tOrdId == null) {
            throw new TrxException("1303", "\u65e0\u6cd5\u8fa8\u8bc6\u7f51\u4e0a\u652f\u4ed8\u5e73\u53f0\u7684\u4ea4\u6613\u7ed3\u679c", "\u65e0\u6cd5\u53d6\u5f97[CBPOrderNo]!");
        }
        this.setCBPOrdId(tOrdId.toString());
        XMLDocument tOrderAmount = aXMLDocument.getValue("OrderAmount");
        if (tOrderAmount == null) {
            throw new TrxException("1303", "\u65e0\u6cd5\u8fa8\u8bc6\u7f51\u4e0a\u652f\u4ed8\u5e73\u53f0\u7684\u4ea4\u6613\u7ed3\u679c", "\u65e0\u6cd5\u53d6\u5f97[OrderAmount]!");
        }
        this.setOrderAmount(Double.parseDouble(tOrderAmount.toString()));
        XMLDocument tOrderDate = aXMLDocument.getValue("OrderDate");
        if (tOrderDate == null) {
            throw new TrxException("1303", "\u65e0\u6cd5\u8fa8\u8bc6\u7f51\u4e0a\u652f\u4ed8\u5e73\u53f0\u7684\u4ea4\u6613\u7ed3\u679c", "\u65e0\u6cd5\u53d6\u5f97[OrderDate]!");
        }
        this.setOrderDate(tOrderDate.toString());
        XMLDocument tClientIP = aXMLDocument.getValue("ClientIP");
        if (tClientIP == null) {
            throw new TrxException("1303", "\u65e0\u6cd5\u8fa8\u8bc6\u7f51\u4e0a\u652f\u4ed8\u5e73\u53f0\u7684\u4ea4\u6613\u7ed3\u679c", "\u65e0\u6cd5\u53d6\u5f97[tClientIP]!");
        }
        this.setClientIP(tClientIP.toString());
        XMLDocument IsSuppCredit = aXMLDocument.getValue("IsSuppCredit");
        if (IsSuppCredit == null) {
            throw new TrxException("1303", "\u65e0\u6cd5\u8fa8\u8bc6\u7f51\u4e0a\u652f\u4ed8\u5e73\u53f0\u7684\u4ea4\u6613\u7ed3\u679c", "\u65e0\u6cd5\u53d6\u5f97[IsSuppCredit]!");
        }
        this.setSupportCredit(IsSuppCredit.toString());
        XMLDocument tResultURL = aXMLDocument.getValue("ResultURL");
        if (tResultURL == null) {
            throw new TrxException("1303", "\u65e0\u6cd5\u8fa8\u8bc6\u7f51\u4e0a\u652f\u4ed8\u5e73\u53f0\u7684\u4ea4\u6613\u7ed3\u679c", "\u65e0\u6cd5\u53d6\u5f97[ResultURL]!");
        }
        this.setResultURL(tResultURL.toString());
    }
}

