/*
 * Decompiled with CFR 0.152.
 */
package com.hitrust.trustpay.client.b2c;

import com.hitrust.trustpay.client.DataVerifier;
import com.hitrust.trustpay.client.XMLDocument;
import com.hitrust.trustpay.client.b2c.OrderItem;
import java.util.ArrayList;

public class Order {
    private String iOrderNo = "";
    private int iExpiredDate = 30;
    private String iOrderDesc = "";
    private String iOrderDate = "";
    private String iOrderTime = "";
    private double iOrderAmount = 0.0;
    private ArrayList iOrderItems = new ArrayList();
    private String iOrderURL = "";
    private double iPayAmount = 0.0;
    private double iRefundAmount = 0.0;
    private String iBuyIP = "";
    private String iOrderStatus = "01";
    public static final String ORDER_STATUS_CANCEL = "00";
    public static final String ORDER_STATUS_NEW = "01";
    public static final String ORDER_STATUS_WAIT = "02";
    public static final String ORDER_STATUS_PAY = "03";
    public static final String ORDER_STATUS_SETTLED = "04";
    public static final String ORDER_STATUS_REFUND = "05";
    public static final String ORDER_STATUS_ISSUE = "99";
    public static final int ORDER_NO_LEN = 50;
    public static final int ORDER_DESC_LEN = 100;
    public static final int ORDER_URL_LEN = 200;

    public Order() {
    }

    public Order(XMLDocument aXMLDocument) {
        this.setOrderNo(aXMLDocument.getValueNoNull("OrderNo"));
        try {
            this.setExpiredDate(Integer.parseInt(aXMLDocument.getValueNoNull("ExpiredDate")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setOrderDesc(aXMLDocument.getValueNoNull("OrderDesc"));
        this.setOrderDate(aXMLDocument.getValueNoNull("OrderDate"));
        this.setOrderTime(aXMLDocument.getValueNoNull("OrderTime"));
        this.setOrderURL(aXMLDocument.getValueNoNull("OrderURL"));
        this.setOrderStatus(aXMLDocument.getValueNoNull("OrderStatus"));
        try {
            this.setOrderAmount(Double.parseDouble(aXMLDocument.getValueNoNull("OrderAmount")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.setPayAmount(Double.parseDouble(aXMLDocument.getValueNoNull("PayAmount")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.setRefundAmount(Double.parseDouble(aXMLDocument.getValueNoNull("RefundAmount")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        ArrayList tOrderItems = aXMLDocument.getDocuments("OrderItem");
        int i = 0;
        while (i < tOrderItems.size()) {
            this.addOrderItem(new OrderItem((XMLDocument)tOrderItems.get(i)));
            ++i;
        }
    }

    public Order setOrderNo(String aOrderNo) {
        this.iOrderNo = aOrderNo.trim();
        return this;
    }

    public String getOrderNo() {
        return this.iOrderNo;
    }

    public Order setExpiredDate(int aExpiredDate) {
        this.iExpiredDate = aExpiredDate;
        return this;
    }

    public int getExpiredDate() {
        return this.iExpiredDate;
    }

    public Order setOrderDesc(String aOrderDesc) {
        this.iOrderDesc = aOrderDesc.trim();
        return this;
    }

    public String getOrderDesc() {
        return this.iOrderDesc;
    }

    public Order setOrderDate(String aOrderDate) {
        this.iOrderDate = aOrderDate.trim();
        return this;
    }

    public String getOrderDate() {
        return this.iOrderDate;
    }

    public Order setOrderTime(String aOrderTime) {
        this.iOrderTime = aOrderTime.trim();
        return this;
    }

    public String getOrderTime() {
        return this.iOrderTime;
    }

    public Order setOrderAmount(double aOrderAmount) {
        this.iOrderAmount = aOrderAmount;
        return this;
    }

    public double getOrderAmount() {
        return this.iOrderAmount;
    }

    public Order setPayAmount(double aPayAmount) {
        this.iPayAmount = aPayAmount;
        return this;
    }

    public double getPayAmount() {
        return this.iPayAmount;
    }

    public Order setRefundAmount(double aRefundAmount) {
        this.iRefundAmount = aRefundAmount;
        return this;
    }

    public double getRefundAmount() {
        return this.iRefundAmount;
    }

    public Order addOrderItem(OrderItem aOrderItem) {
        this.iOrderItems.add(aOrderItem);
        return this;
    }

    public Order clearOrderItems() {
        this.iOrderItems = new ArrayList();
        return this;
    }

    public ArrayList getOrderItems() {
        return this.iOrderItems;
    }

    public Order setOrderURL(String aOrderURL) {
        this.iOrderURL = aOrderURL.trim();
        return this;
    }

    public String getOrderURL() {
        return this.iOrderURL;
    }

    public Order setBuyIP(String aBuyIP) {
        this.iBuyIP = aBuyIP.trim();
        return this;
    }

    public String getBuyIP() {
        return this.iBuyIP;
    }

    public Order setOrderStatus(String aOrderStatus) {
        this.iOrderStatus = aOrderStatus;
        return this;
    }

    public String getOrderStatus() {
        return this.iOrderStatus;
    }

    public boolean isValid() {
        if (this.iOrderNo == null) {
            return false;
        }
        if (this.iOrderDate == null) {
            return false;
        }
        if (this.iOrderTime == null) {
            return false;
        }
        if (this.iOrderAmount <= 0.0) {
            return false;
        }
        if (this.iOrderNo.length() == 0) {
            return false;
        }
        if (this.iOrderNo.getBytes().length > 50) {
            return false;
        }
        if (this.iOrderDesc.getBytes().length > 100) {
            return false;
        }
        if (this.iOrderURL.getBytes().length > 200) {
            return false;
        }
        if (!DataVerifier.isValidDate(this.iOrderDate)) {
            return false;
        }
        if (!DataVerifier.isValidTime(this.iOrderTime)) {
            return false;
        }
        if (!DataVerifier.isValidAmount(this.iOrderAmount, 2)) {
            return false;
        }
        if (this.iOrderURL.length() > 0 && !DataVerifier.isValidURL(this.iOrderURL)) {
            return false;
        }
        int i = 0;
        while (i < this.iOrderItems.size()) {
            OrderItem tOrderItem = (OrderItem)this.iOrderItems.get(i);
            if (!tOrderItem.isValid()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public XMLDocument getXMLDocument(int aType) {
        StringBuffer tXML = new StringBuffer("").append("<Order>").append("<OrderNo>").append(this.iOrderNo).append("</OrderNo>").append("<ExpiredDate>").append(this.iExpiredDate).append("</ExpiredDate>").append("<OrderAmount>").append(this.iOrderAmount).append("</OrderAmount>");
        if (aType == 1 || aType == 3) {
            tXML.append("<OrderDesc>").append(this.iOrderDesc).append("</OrderDesc>").append("<OrderDate>").append(this.iOrderDate).append("</OrderDate>").append("<OrderTime>").append(this.iOrderTime).append("</OrderTime>").append("<OrderURL>").append(this.iOrderURL).append("</OrderURL>").append("<BuyIP>").append(this.iBuyIP).append("</BuyIP>").append("<OrderItems>");
            int i = 0;
            while (i < this.iOrderItems.size()) {
                OrderItem tOrderItem = (OrderItem)this.iOrderItems.get(i);
                tXML.append(tOrderItem.getXMLDocument().toString());
                ++i;
            }
            tXML.append("</OrderItems>");
        }
        if (aType == 2 || aType == 3) {
            tXML.append("<PayAmount>").append(this.iPayAmount).append("</PayAmount>").append("<RefundAmount>").append(this.iRefundAmount).append("</RefundAmount>").append("<OrderStatus>").append(this.iOrderStatus).append("</OrderStatus>");
        }
        tXML.append("</Order>");
        return new XMLDocument(tXML.toString());
    }
}

