/*
 * Decompiled with CFR 0.152.
 */
package com.hitrust.trustpay.client.b2c;

import com.hitrust.trustpay.client.DataVerifier;
import com.hitrust.trustpay.client.TrxException;
import com.hitrust.trustpay.client.TrxRequest;
import com.hitrust.trustpay.client.TrxResponse;
import com.hitrust.trustpay.client.XMLDocument;
import java.util.ArrayList;

public class OverdueRefundRequest
extends TrxRequest {
    private int iTotalCount = 0;
    private double iTotalAmount = 0.0;
    private String sRemark = "";
    private ArrayList iOrderlist = null;

    public OverdueRefundRequest() {
        super("B2C");
    }

    protected XMLDocument getRequestMessage() {
        StringBuffer tMessage = new StringBuffer("").append("<TrxRequest>").append("<TrxType>").append("OverdueRefund").append("</TrxType>").append("<TotalCount>").append(this.iTotalCount).append("</TotalCount>").append("<TotalAmount>").append(this.iTotalAmount).append("</TotalAmount>").append("<Remark>").append(this.sRemark).append("</Remark>");
        tMessage.append("<OrderData>");
        int i = 0;
        while (i < this.iTotalCount) {
            tMessage.append("<OrderNo>").append(((String[])this.iOrderlist.get(i))[0]).append("</OrderNo>").append("<RefundAmount>").append(((String[])this.iOrderlist.get(i))[1]).append("</RefundAmount>");
            ++i;
        }
        tMessage.append("</OrderData>").append("</TrxRequest>");
        return new XMLDocument(tMessage.toString());
    }

    protected void checkRequest() throws TrxException {
        if (this.iTotalCount <= 0) {
            throw new TrxException("1100", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u9000\u6b3e\u4ea4\u6613\u603b\u7b14\u6570\u4e0d\u80fd\u5c0f\u4e8e1\u7b14");
        }
        if (this.iTotalCount > 100) {
            throw new TrxException("1100", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u9000\u6b3e\u4ea4\u6613\u603b\u7b14\u6570\u4e0d\u80fd\u5927\u4e8e100\u7b14");
        }
        if (this.iTotalAmount <= 0.0) {
            throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u9000\u6b3e\u4ea4\u6613\u603b\u91d1\u989d\u4e0d\u5408\u6cd5\uff01");
        }
        if (!DataVerifier.isValidAmount(this.iTotalAmount, 2)) {
            throw new TrxException("1101", "\u5546\u6237\u63d0\u4ea4\u7684\u4ea4\u6613\u8d44\u6599\u4e0d\u5408\u6cd5", "\u9000\u6b3e\u4ea4\u6613\u603b\u91d1\u989d\u4e0d\u5408\u6cd5\uff01");
        }
    }

    protected TrxResponse constructResponse(XMLDocument aResponseMessage) throws TrxException {
        return new TrxResponse(aResponseMessage);
    }

    public OverdueRefundRequest setTotalCount(int aTotalCount) {
        this.iTotalCount = aTotalCount;
        return this;
    }

    public int getTotalCount() {
        return this.iTotalCount;
    }

    public OverdueRefundRequest setTotalAmount(double aTotalAmount) {
        this.iTotalAmount = aTotalAmount;
        return this;
    }

    public double getTotalAmount() {
        return this.iTotalAmount;
    }

    public OverdueRefundRequest setRemark(String aRemark) {
        this.sRemark = aRemark;
        return this;
    }

    public String getRemark() {
        return this.sRemark;
    }

    public OverdueRefundRequest setOrderDital(ArrayList aorderlist) {
        this.iOrderlist = aorderlist;
        return this;
    }
}

