/*
 * Decompiled with CFR 0.152.
 */
package com.hitrust.trustpay.client.b2c;

import com.hitrust.trustpay.client.TrxException;
import com.hitrust.trustpay.client.TrxResponse;
import com.hitrust.trustpay.client.XMLDocument;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;

public class SettleFile {
    public static final String SETTLE_TYPE_TRX = "TRX";
    public static final String SETTLE_TYPE_CREDIT_TRX = "CREDIT_TRX";
    public static final String SETTLE_TYPE_SETTLE = "SETTLE";
    public static final String SETTLE_TYPE_TRX_BYHOUR = "TRXBYHOUR";
    private String iSettleDate = "";
    private String iSettleType = "";
    private String iBatchNo = "";
    private int iNumOfPayments = 0;
    private double iSumOfPayAmount = 0.0;
    private int iNumOfRefunds = 0;
    private double iSumOfRefundAmount = 0.0;
    private double iSettleAmount = 0.0;
    private float iFee = 0.0f;
    private String[] iDetailRecords = new String[0];

    public SettleFile() {
    }

    public SettleFile(TrxResponse aTrxResponse) {
        this.init(aTrxResponse);
    }

    public void init(TrxResponse aTrxResponse) {
        this.setSettleDate(aTrxResponse.getValue("SettleDate"));
        this.setSettleType(aTrxResponse.getValue("SettleType"));
        this.setBatchNo(aTrxResponse.getValue("BatchNo"));
        this.setNumOfPayments(Integer.decode(aTrxResponse.getValue("NumOfPayments")));
        this.setSumOfPayAmount(Double.parseDouble(aTrxResponse.getValue("SumOfPayAmount")));
        this.setNumOfRefunds(Integer.decode(aTrxResponse.getValue("NumOfRefunds")));
        this.setSumOfRefundAmount(Double.parseDouble(aTrxResponse.getValue("SumOfRefundAmount")));
        if (this.iSettleType.equals(SETTLE_TYPE_SETTLE)) {
            this.setSettleAmount(Double.parseDouble(aTrxResponse.getValue("SettleAmount")));
            this.setFee(Float.parseFloat(aTrxResponse.getValue("Fee")));
        }
        XMLDocument tDetailRecords = new XMLDocument(aTrxResponse.getValue("DetailRecords"));
        ArrayList tRecords = tDetailRecords.getDocuments("Record");
        this.iDetailRecords = new String[tRecords.size()];
        int i = 0;
        while (i < tRecords.size()) {
            this.iDetailRecords[i] = ((XMLDocument)tRecords.get(i)).toString();
            ++i;
        }
    }

    public SettleFile setSettleDate(String aSettleDate) {
        this.iSettleDate = aSettleDate.trim();
        return this;
    }

    public String getSettleDate() {
        return this.iSettleDate;
    }

    public SettleFile setSettleType(String aSettleType) {
        this.iSettleType = aSettleType.trim();
        return this;
    }

    public String getSettleType() {
        return this.iSettleType;
    }

    public SettleFile setBatchNo(String aBatchNo) {
        this.iBatchNo = aBatchNo.trim();
        return this;
    }

    public String getBatchNo() {
        return this.iBatchNo;
    }

    public SettleFile setNumOfPayments(int aNumOfPayments) {
        this.iNumOfPayments = aNumOfPayments;
        return this;
    }

    public int getNumOfPayments() {
        return this.iNumOfPayments;
    }

    public SettleFile setSumOfPayAmount(double aSumOfPayAmount) {
        this.iSumOfPayAmount = aSumOfPayAmount;
        return this;
    }

    public double getSumOfPayAmount() {
        return this.iSumOfPayAmount;
    }

    public SettleFile setNumOfRefunds(int aNumOfRefunds) {
        this.iNumOfRefunds = aNumOfRefunds;
        return this;
    }

    public int getNumOfRefunds() {
        return this.iNumOfRefunds;
    }

    public SettleFile setSumOfRefundAmount(double aSumOfRefundAmount) {
        this.iSumOfRefundAmount = aSumOfRefundAmount;
        return this;
    }

    public double getSumOfRefundAmount() {
        return this.iSumOfRefundAmount;
    }

    public SettleFile setSettleAmount(double aSettleAmount) {
        this.iSettleAmount = aSettleAmount;
        return this;
    }

    public double getSettleAmount() {
        return this.iSettleAmount;
    }

    public SettleFile setFee(float aFee) {
        this.iFee = aFee;
        return this;
    }

    public float getFee() {
        return this.iFee;
    }

    public String[] getDetailRecords() {
        return this.iDetailRecords;
    }

    public SettleFile save(String aFileName) throws IOException {
        FileWriter tFile = null;
        try {
            tFile = new FileWriter(aFileName, false);
            tFile.write("<SettleFile>\n");
            tFile.write("<SettleDate>");
            tFile.write(this.iSettleDate);
            tFile.write("</SettleDate>\n");
            tFile.write("<SettleType>");
            tFile.write(this.iSettleType);
            tFile.write("</SettleType>\n");
            tFile.write("<BatchNo>");
            tFile.write(this.iBatchNo);
            tFile.write("</BatchNo>\n");
            tFile.write("<NumOfPayments>");
            tFile.write(Integer.toString(this.iNumOfPayments));
            tFile.write("</NumOfPayments>\n");
            tFile.write("<SumOfPayAmount>");
            tFile.write(Double.toString(this.iSumOfPayAmount));
            tFile.write("</SumOfPayAmount>\n");
            tFile.write("<NumOfRefunds>");
            tFile.write(Integer.toString(this.iNumOfRefunds));
            tFile.write("</NumOfRefunds>\n");
            tFile.write("<SumOfRefundAmount>");
            tFile.write(Double.toString(this.iSumOfRefundAmount));
            tFile.write("</SumOfRefundAmount>\n");
            if (this.iSettleType.equals(SETTLE_TYPE_SETTLE)) {
                tFile.write("<SettleAmount>");
                tFile.write(Double.toString(this.iSettleAmount));
                tFile.write("</SettleAmount>\n");
                tFile.write("<Fee>");
                tFile.write(Float.toString(this.iFee));
                tFile.write("</Fee>\n");
            }
            tFile.write("<DetailRecords>\n");
            int i = 0;
            while (i < this.iDetailRecords.length) {
                tFile.write(this.iDetailRecords[i]);
                tFile.write("\n");
                ++i;
            }
            tFile.write("</DetailRecords>\n");
            tFile.write("</SettleFile>\n");
        }
        finally {
            if (tFile != null) {
                try {
                    tFile.flush();
                }
                catch (Exception exception) {}
                try {
                    tFile.close();
                }
                catch (Exception exception) {}
            }
        }
        return this;
    }

    public SettleFile load(String aFileName) throws IOException, TrxException {
        FileReader tFile = null;
        BufferedReader tReader = null;
        try {
            try {
                tFile = new FileReader(aFileName);
                tReader = new BufferedReader(tFile);
                StringBuffer tStringBuffer = new StringBuffer("");
                String tLine = null;
                while ((tLine = tReader.readLine()) != null) {
                    tStringBuffer.append(tLine);
                }
                tStringBuffer.append("<ReturnCode>0000</ReturnCode>");
                this.init(new TrxResponse(new XMLDocument(tStringBuffer.toString())));
            }
            catch (IOException e) {
                throw e;
            }
            catch (TrxException e1) {
                throw e1;
            }
        }
        finally {
            if (tReader != null) {
                try {
                    tReader.close();
                }
                catch (Exception exception) {}
            }
            if (tFile != null) {
                try {
                    tFile.close();
                }
                catch (Exception exception) {}
            }
        }
        return this;
    }

    public static void main(String[] argc) {
        try {
            SettleFile tSettleFile = new SettleFile();
            tSettleFile.load("D:\\SettleFile.txt");
            System.out.println(tSettleFile.getNumOfPayments());
            System.out.println(tSettleFile.getNumOfRefunds());
            System.out.println(tSettleFile.getSettleAmount());
            System.out.println(tSettleFile.getSettleDate());
            System.out.println(tSettleFile.getSettleType());
            System.out.println(tSettleFile.getSumOfPayAmount());
            System.out.println(tSettleFile.getSumOfRefundAmount());
            System.out.println(tSettleFile.getBatchNo());
            System.out.println(tSettleFile.getFee());
            String[] tDetailRecords = tSettleFile.getDetailRecords();
            int i = 0;
            while (i < tDetailRecords.length) {
                System.out.println(tDetailRecords[i]);
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

