/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.web.client;

import de.codecentric.boot.admin.server.domain.entities.Instance;
import de.codecentric.boot.admin.server.web.client.HttpHeadersProvider;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.annotation.Nullable;
import org.springframework.http.HttpHeaders;
import org.springframework.util.Base64Utils;
import org.springframework.util.StringUtils;

public class BasicAuthHttpHeaderProvider
implements HttpHeadersProvider {
    private static final String[] USERNAME_KEYS = new String[]{"user.name", "user-name", "username"};
    private static final String[] PASSWORD_KEYS = new String[]{"user.password", "user-password", "userpassword"};

    @Override
    public HttpHeaders getHeaders(Instance instance) {
        String username = BasicAuthHttpHeaderProvider.getMetadataValue(instance, USERNAME_KEYS);
        String password = BasicAuthHttpHeaderProvider.getMetadataValue(instance, PASSWORD_KEYS);
        HttpHeaders headers = new HttpHeaders();
        if (StringUtils.hasText((String)username) && StringUtils.hasText((String)password)) {
            headers.set("Authorization", this.encode(username, password));
        }
        return headers;
    }

    protected String encode(String username, String password) {
        String token = Base64Utils.encodeToString((byte[])(username + ":" + password).getBytes(StandardCharsets.UTF_8));
        return "Basic " + token;
    }

    @Nullable
    private static String getMetadataValue(Instance instance, String[] keys) {
        Map<String, String> metadata = instance.getRegistration().getMetadata();
        for (String key : keys) {
            String value = metadata.get(key);
            if (value == null) continue;
            return value;
        }
        return null;
    }
}

