/*
 * Decompiled with CFR 0.152.
 */
package com.zgkxzx.modbus4And;

import com.zgkxzx.modbus4And.BatchRead;
import com.zgkxzx.modbus4And.BatchResults;
import com.zgkxzx.modbus4And.ExceptionResult;
import com.zgkxzx.modbus4And.Modbus;
import com.zgkxzx.modbus4And.NodeScanListener;
import com.zgkxzx.modbus4And.base.KeyedModbusLocator;
import com.zgkxzx.modbus4And.base.ReadFunctionGroup;
import com.zgkxzx.modbus4And.base.SlaveProfile;
import com.zgkxzx.modbus4And.exception.ErrorResponseException;
import com.zgkxzx.modbus4And.exception.InvalidDataConversionException;
import com.zgkxzx.modbus4And.exception.ModbusInitException;
import com.zgkxzx.modbus4And.exception.ModbusTransportException;
import com.zgkxzx.modbus4And.locator.BaseLocator;
import com.zgkxzx.modbus4And.locator.BinaryLocator;
import com.zgkxzx.modbus4And.locator.NumericLocator;
import com.zgkxzx.modbus4And.msg.ModbusRequest;
import com.zgkxzx.modbus4And.msg.ModbusResponse;
import com.zgkxzx.modbus4And.msg.ReadCoilsRequest;
import com.zgkxzx.modbus4And.msg.ReadDiscreteInputsRequest;
import com.zgkxzx.modbus4And.msg.ReadHoldingRegistersRequest;
import com.zgkxzx.modbus4And.msg.ReadInputRegistersRequest;
import com.zgkxzx.modbus4And.msg.ReadResponse;
import com.zgkxzx.modbus4And.msg.WriteCoilRequest;
import com.zgkxzx.modbus4And.msg.WriteCoilsRequest;
import com.zgkxzx.modbus4And.msg.WriteMaskRegisterRequest;
import com.zgkxzx.modbus4And.msg.WriteRegisterRequest;
import com.zgkxzx.modbus4And.msg.WriteRegistersRequest;
import com.zgkxzx.modbus4And.sero.epoll.InputStreamEPollWrapper;
import com.zgkxzx.modbus4And.sero.messaging.MessageControl;
import com.zgkxzx.modbus4And.sero.util.ArrayUtils;
import com.zgkxzx.modbus4And.sero.util.ProgressiveTask;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class ModbusMaster
extends Modbus {
    private int timeout = 500;
    private int retries = 2;
    protected boolean connected = false;
    private boolean multipleWritesOnly;
    private int discardDataDelay = 0;
    private InputStreamEPollWrapper ePoll;
    private final Map<Integer, SlaveProfile> slaveProfiles = new HashMap<Integer, SlaveProfile>();
    protected boolean initialized;

    public boolean isConnected() {
        return this.connected;
    }

    public void setConnected(boolean connected) {
        this.connected = connected;
    }

    public abstract void init() throws ModbusInitException;

    public boolean isInitialized() {
        return this.initialized;
    }

    public abstract void destroy();

    public final ModbusResponse send(ModbusRequest request) throws ModbusTransportException {
        request.validate(this);
        return this.sendImpl(request);
    }

    public abstract ModbusResponse sendImpl(ModbusRequest var1) throws ModbusTransportException;

    public <T> T getValue(BaseLocator<T> locator) throws ModbusTransportException, ErrorResponseException {
        BatchRead<String> batch = new BatchRead<String>();
        batch.addLocator("", locator);
        BatchResults<String> result = this.send(batch);
        return (T)result.getValue("");
    }

    public <T> void setValue(BaseLocator<T> locator, Object value) throws ModbusTransportException, ErrorResponseException {
        int slaveId = locator.getSlaveId();
        int registerRange = locator.getRange();
        int writeOffset = locator.getOffset();
        if (registerRange == 2 || registerRange == 4) {
            throw new RuntimeException("Cannot write to input status or input register ranges");
        }
        if (registerRange == 1) {
            if (!(value instanceof Boolean)) {
                throw new InvalidDataConversionException("Only boolean values can be written to coils");
            }
            if (this.multipleWritesOnly) {
                this.setValue(new WriteCoilsRequest(slaveId, writeOffset, new boolean[]{(Boolean)value}));
            } else {
                this.setValue(new WriteCoilRequest(slaveId, writeOffset, (Boolean)value));
            }
        } else if (locator.getDataType() == 1) {
            if (!(value instanceof Boolean)) {
                throw new InvalidDataConversionException("Only boolean values can be written to coils");
            }
            this.setHoldingRegisterBit(slaveId, writeOffset, ((BinaryLocator)locator).getBit(), (Boolean)value);
        } else {
            short[] data = locator.valueToShorts(value);
            if (data.length == 1 && !this.multipleWritesOnly) {
                this.setValue(new WriteRegisterRequest(slaveId, writeOffset, data[0]));
            } else {
                this.setValue(new WriteRegistersRequest(slaveId, writeOffset, data));
            }
        }
    }

    public List<Integer> scanForSlaveNodes() {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i = 1; i <= 240; ++i) {
            if (!this.testSlaveNode(i)) continue;
            result.add(i);
        }
        return result;
    }

    public ProgressiveTask scanForSlaveNodes(final NodeScanListener l) {
        l.progressUpdate(0.0f);
        ProgressiveTask task = new ProgressiveTask(l){
            private int node;
            {
                super(l2);
                this.node = 1;
            }

            @Override
            protected void runImpl() {
                if (ModbusMaster.this.testSlaveNode(this.node)) {
                    l.nodeFound(this.node);
                }
                this.declareProgress((float)this.node / 240.0f);
                ++this.node;
                if (this.node > 240) {
                    this.completed = true;
                }
            }
        };
        new Thread(task).start();
        return task;
    }

    public boolean testSlaveNode(int node) {
        try {
            this.send(new ReadHoldingRegistersRequest(node, 0, 1));
        }
        catch (ModbusTransportException e) {
            return false;
        }
        return true;
    }

    public int getRetries() {
        return this.retries;
    }

    public void setRetries(int retries) {
        this.retries = retries < 0 ? 0 : retries;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout < 1 ? 1 : timeout;
    }

    public boolean isMultipleWritesOnly() {
        return this.multipleWritesOnly;
    }

    public void setMultipleWritesOnly(boolean multipleWritesOnly) {
        this.multipleWritesOnly = multipleWritesOnly;
    }

    public int getDiscardDataDelay() {
        return this.discardDataDelay;
    }

    public void setDiscardDataDelay(int discardDataDelay) {
        this.discardDataDelay = discardDataDelay < 0 ? 0 : discardDataDelay;
    }

    public InputStreamEPollWrapper getePoll() {
        return this.ePoll;
    }

    public void setePoll(InputStreamEPollWrapper ePoll) {
        this.ePoll = ePoll;
    }

    public <K> BatchResults<K> send(BatchRead<K> batch) throws ModbusTransportException, ErrorResponseException {
        if (!this.initialized) {
            throw new ModbusTransportException("not initialized");
        }
        BatchResults results = new BatchResults();
        List<ReadFunctionGroup<K>> functionGroups = batch.getReadFunctionGroups(this);
        for (ReadFunctionGroup<K> functionGroup : functionGroups) {
            this.sendFunctionGroup(functionGroup, results, batch.isErrorsInResults(), batch.isExceptionsInResults());
            if (!batch.isCancel()) continue;
            break;
        }
        return results;
    }

    protected MessageControl getMessageControl() {
        MessageControl conn = new MessageControl();
        conn.setRetries(this.getRetries());
        conn.setTimeout(this.getTimeout());
        conn.setDiscardDataDelay(this.getDiscardDataDelay());
        conn.setExceptionHandler(this.getExceptionHandler());
        return conn;
    }

    protected void closeMessageControl(MessageControl conn) {
        if (conn != null) {
            conn.close();
        }
    }

    private <K> void sendFunctionGroup(ReadFunctionGroup<K> functionGroup, BatchResults<K> results, boolean errorsInResults, boolean exceptionsInResults) throws ModbusTransportException, ErrorResponseException {
        ReadResponse response;
        ModbusRequest request;
        int slaveId = functionGroup.getSlaveAndRange().getSlaveId();
        int startOffset = functionGroup.getStartOffset();
        int length = functionGroup.getLength();
        if (functionGroup.getFunctionCode() == 1) {
            request = new ReadCoilsRequest(slaveId, startOffset, length);
        } else if (functionGroup.getFunctionCode() == 2) {
            request = new ReadDiscreteInputsRequest(slaveId, startOffset, length);
        } else if (functionGroup.getFunctionCode() == 3) {
            request = new ReadHoldingRegistersRequest(slaveId, startOffset, length);
        } else if (functionGroup.getFunctionCode() == 4) {
            request = new ReadInputRegistersRequest(slaveId, startOffset, length);
        } else {
            throw new RuntimeException("Unsupported function");
        }
        try {
            response = (ReadResponse)this.send(request);
        }
        catch (ModbusTransportException e) {
            if (!exceptionsInResults) {
                throw e;
            }
            for (KeyedModbusLocator<K> locator : functionGroup.getLocators()) {
                results.addResult(locator.getKey(), e);
            }
            return;
        }
        byte[] data = null;
        if (!errorsInResults && response.isException()) {
            throw new ErrorResponseException(request, response);
        }
        if (!response.isException()) {
            data = response.getData();
        }
        for (KeyedModbusLocator<K> locator : functionGroup.getLocators()) {
            if (errorsInResults && response.isException()) {
                results.addResult(locator.getKey(), new ExceptionResult(response.getExceptionCode()));
                continue;
            }
            try {
                results.addResult(locator.getKey(), locator.bytesToValue(data, startOffset));
            }
            catch (RuntimeException e) {
                throw new RuntimeException("Result conversion exception. data=" + ArrayUtils.toHexString(data) + ", startOffset=" + startOffset + ", locator=" + locator + ", functionGroup.functionCode=" + functionGroup.getFunctionCode() + ", functionGroup.startOffset=" + startOffset + ", functionGroup.length=" + length, e);
            }
        }
    }

    private void setValue(ModbusRequest request) throws ModbusTransportException, ErrorResponseException {
        ModbusResponse response = this.send(request);
        if (response == null) {
            return;
        }
        if (response.isException()) {
            throw new ErrorResponseException(request, response);
        }
    }

    private void setHoldingRegisterBit(int slaveId, int writeOffset, int bit, boolean value) throws ModbusTransportException, ErrorResponseException {
        SlaveProfile sp = this.getSlaveProfile(slaveId);
        if (sp.getWriteMaskRegister()) {
            WriteMaskRegisterRequest request = new WriteMaskRegisterRequest(slaveId, writeOffset);
            request.setBit(bit, value);
            ModbusResponse response = this.send(request);
            if (response == null) {
                return;
            }
            if (!response.isException()) {
                return;
            }
            if (response.getExceptionCode() == 1) {
                sp.setWriteMaskRegister(false);
            } else {
                throw new ErrorResponseException(request, response);
            }
        }
        int regValue = (Integer)this.getValue(new NumericLocator(slaveId, 3, writeOffset, 2));
        regValue = value ? (regValue |= 1 << bit) : (regValue &= ~(1 << bit));
        this.setValue(new WriteRegisterRequest(slaveId, writeOffset, regValue));
    }

    private SlaveProfile getSlaveProfile(int slaveId) {
        SlaveProfile sp = this.slaveProfiles.get(slaveId);
        if (sp == null) {
            sp = new SlaveProfile();
            this.slaveProfiles.put(slaveId, sp);
        }
        return sp;
    }
}

