/*
 * Decompiled with CFR 0.152.
 */
package com.zgkxzx.modbus4And.base;

import com.zgkxzx.modbus4And.ModbusSlaveSet;
import com.zgkxzx.modbus4And.ProcessImage;
import com.zgkxzx.modbus4And.exception.ModbusTransportException;
import com.zgkxzx.modbus4And.msg.ModbusRequest;
import com.zgkxzx.modbus4And.msg.ModbusResponse;
import com.zgkxzx.modbus4And.sero.messaging.RequestHandler;

public abstract class BaseRequestHandler
implements RequestHandler {
    protected ModbusSlaveSet slave;

    public BaseRequestHandler(ModbusSlaveSet slave) {
        this.slave = slave;
    }

    protected ModbusResponse handleRequestImpl(ModbusRequest request) throws ModbusTransportException {
        request.validate(this.slave);
        int slaveId = request.getSlaveId();
        if (slaveId == 0) {
            for (ProcessImage processImage : this.slave.getProcessImages()) {
                request.handle(processImage);
            }
            return null;
        }
        ProcessImage processImage = this.slave.getProcessImage(slaveId);
        if (processImage == null) {
            return null;
        }
        return request.handle(processImage);
    }
}

