/*
 * Decompiled with CFR 0.152.
 */
package com.zgkxzx.modbus4And.base;

import com.zgkxzx.modbus4And.base.KeyedModbusLocator;
import com.zgkxzx.modbus4And.base.SlaveAndRange;
import com.zgkxzx.modbus4And.code.RegisterRange;
import java.util.ArrayList;
import java.util.List;

public class ReadFunctionGroup<K> {
    private final SlaveAndRange slaveAndRange;
    private final int functionCode;
    private final List<KeyedModbusLocator<K>> locators = new ArrayList<KeyedModbusLocator<K>>();
    private int startOffset = 65536;
    private int length = 0;

    public ReadFunctionGroup(KeyedModbusLocator<K> locator) {
        this.slaveAndRange = locator.getSlaveAndRange();
        this.functionCode = RegisterRange.getReadFunctionCode(this.slaveAndRange.getRange());
        this.add(locator);
    }

    public void add(KeyedModbusLocator<K> locator) {
        if (this.startOffset > locator.getOffset()) {
            this.startOffset = locator.getOffset();
        }
        if (this.length < locator.getEndOffset() - this.startOffset + 1) {
            this.length = locator.getEndOffset() - this.startOffset + 1;
        }
        this.locators.add(locator);
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.startOffset + this.length - 1;
    }

    public SlaveAndRange getSlaveAndRange() {
        return this.slaveAndRange;
    }

    public int getLength() {
        return this.length;
    }

    public int getFunctionCode() {
        return this.functionCode;
    }

    public List<KeyedModbusLocator<K>> getLocators() {
        return this.locators;
    }
}

