/*
 * Decompiled with CFR 0.152.
 */
package com.zgkxzx.modbus4And.msg;

import com.zgkxzx.modbus4And.base.ModbusUtils;
import com.zgkxzx.modbus4And.exception.ModbusTransportException;
import com.zgkxzx.modbus4And.msg.ModbusResponse;
import com.zgkxzx.modbus4And.sero.util.queue.ByteQueue;

public class ReportSlaveIdResponse
extends ModbusResponse {
    private byte[] data;

    ReportSlaveIdResponse(int slaveId) throws ModbusTransportException {
        super(slaveId);
    }

    ReportSlaveIdResponse(int slaveId, byte[] data) throws ModbusTransportException {
        super(slaveId);
        this.data = data;
    }

    @Override
    public byte getFunctionCode() {
        return 17;
    }

    @Override
    protected void readResponse(ByteQueue queue) {
        int numberOfBytes = ModbusUtils.popUnsignedByte(queue);
        if (queue.size() < numberOfBytes) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.data = new byte[numberOfBytes];
        queue.pop(this.data);
    }

    @Override
    protected void writeResponse(ByteQueue queue) {
        ModbusUtils.pushByte(queue, this.data.length);
        queue.push(this.data);
    }

    public byte[] getData() {
        return this.data;
    }
}

