/*
 * Decompiled with CFR 0.152.
 */
package com.zgkxzx.modbus4And.serial.ascii;

import com.zgkxzx.modbus4And.exception.ModbusInitException;
import com.zgkxzx.modbus4And.exception.ModbusTransportException;
import com.zgkxzx.modbus4And.msg.ModbusRequest;
import com.zgkxzx.modbus4And.msg.ModbusResponse;
import com.zgkxzx.modbus4And.serial.SerialMaster;
import com.zgkxzx.modbus4And.serial.SerialPortWrapper;
import com.zgkxzx.modbus4And.serial.SerialWaitingRoomKeyFactory;
import com.zgkxzx.modbus4And.serial.ascii.AsciiMessageParser;
import com.zgkxzx.modbus4And.serial.ascii.AsciiMessageRequest;
import com.zgkxzx.modbus4And.serial.ascii.AsciiMessageResponse;
import com.zgkxzx.modbus4And.sero.messaging.MessageControl;
import com.zgkxzx.modbus4And.sero.messaging.StreamTransport;
import java.io.IOException;

public class AsciiMaster
extends SerialMaster {
    private MessageControl conn;

    public AsciiMaster(SerialPortWrapper wrapper) {
        super(wrapper);
    }

    @Override
    public void init() throws ModbusInitException {
        super.init();
        AsciiMessageParser asciiMessageParser = new AsciiMessageParser(true);
        this.conn = this.getMessageControl();
        try {
            this.conn.start(this.transport, asciiMessageParser, null, new SerialWaitingRoomKeyFactory());
            if (this.getePoll() == null) {
                ((StreamTransport)this.transport).start("Modbus ASCII master");
            }
        }
        catch (IOException e) {
            throw new ModbusInitException(e);
        }
        this.initialized = true;
    }

    @Override
    public void destroy() {
        this.closeMessageControl(this.conn);
        super.close();
    }

    @Override
    public ModbusResponse sendImpl(ModbusRequest request) throws ModbusTransportException {
        AsciiMessageRequest asciiRequest = new AsciiMessageRequest(request);
        try {
            AsciiMessageResponse asciiResponse = (AsciiMessageResponse)this.conn.send(asciiRequest);
            if (asciiResponse == null) {
                return null;
            }
            return asciiResponse.getModbusResponse();
        }
        catch (Exception e) {
            throw new ModbusTransportException(e, request.getSlaveId());
        }
    }
}

