/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.util;

import java.io.IOException;
import java.io.OutputStream;

public class ProxyOutputStream
extends OutputStream {
    protected OutputStream delegate;

    public ProxyOutputStream(OutputStream delegate) {
        this.delegate = delegate;
    }

    @Override
    public void write(int b) throws IOException {
        try {
            this.assertStreamConnected().write(b);
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        try {
            this.assertStreamConnected().write(b);
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        try {
            this.assertStreamConnected().write(b, off, len);
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
    }

    @Override
    public void flush() throws IOException {
        try {
            this.assertStreamConnected().flush();
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.assertStreamConnected().close();
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
    }

    protected void handleIOException(IOException e) throws IOException {
        throw e;
    }

    protected OutputStream assertStreamConnected() throws IOException {
        if (this.delegate == null) {
            throw new IOException("Stream is not connected");
        }
        return this.delegate;
    }
}

