/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.spring.boot.autoconfigure.observability.zipkin;

import org.apache.dubbo.spring.boot.autoconfigure.observability.annotation.ConditionalOnDubboTracingEnable;
import org.apache.dubbo.spring.boot.autoconfigure.observability.zipkin.ZipkinConfigurations;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.client.RestTemplateAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import zipkin2.Span;
import zipkin2.codec.BytesEncoder;
import zipkin2.codec.SpanBytesEncoder;
import zipkin2.reporter.Sender;

@ConditionalOnProperty(prefix="dubbo", name={"enabled"}, matchIfMissing=true)
@AutoConfiguration(after={RestTemplateAutoConfiguration.class}, afterName={"org.springframework.boot.actuate.autoconfigure.tracing.zipkin"})
@ConditionalOnClass(value={Sender.class})
@Import(value={ZipkinConfigurations.SenderConfiguration.class, ZipkinConfigurations.ReporterConfiguration.class, ZipkinConfigurations.BraveConfiguration.class, ZipkinConfigurations.OpenTelemetryConfiguration.class})
@ConditionalOnDubboTracingEnable
public class ZipkinAutoConfiguration {
    @Bean
    @ConditionalOnProperty(prefix="dubbo.tracing.tracing-exporter.zipkin-config", name={"endpoint"})
    @ConditionalOnMissingBean
    public BytesEncoder<Span> spanBytesEncoder() {
        return SpanBytesEncoder.JSON_V2;
    }
}

