/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.aggregate;

import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.table.api.Types;
import org.apache.flink.table.codegen.Compiler;
import org.apache.flink.table.codegen.Compiler$class;
import org.apache.flink.table.codegen.GeneratedAggregationsFunction;
import org.apache.flink.table.runtime.aggregate.GeneratedAggregations;
import org.apache.flink.table.runtime.aggregate.ProcessFunctionWithCleanupState;
import org.apache.flink.table.runtime.types.CRow;
import org.apache.flink.table.util.Logging;
import org.apache.flink.table.util.Logging$class;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.codehaus.commons.compiler.CompileException;
import org.slf4j.Logger;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ef\u0001B\u0001\u0003\u0001=\u0011qc\u0012:pkB\fum\u001a)s_\u000e,7o\u001d$v]\u000e$\u0018n\u001c8\u000b\u0005\r!\u0011!C1hOJ,w-\u0019;f\u0015\t)a!A\u0004sk:$\u0018.\\3\u000b\u0005\u001dA\u0011!\u0002;bE2,'BA\u0005\u000b\u0003\u00151G.\u001b8l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001U\u0011\u0001cF\n\u0005\u0001EI#\u0007E\u0003\u0013'U\u00193%D\u0001\u0003\u0013\t!\"AA\u0010Qe>\u001cWm]:Gk:\u001cG/[8o/&$\bn\u00117fC:,\bo\u0015;bi\u0016\u0004\"AF\f\r\u0001\u0011)\u0001\u0004\u0001b\u00013\t\t1*\u0005\u0002\u001bAA\u00111DH\u0007\u00029)\tQ$A\u0003tG\u0006d\u0017-\u0003\u0002 9\t9aj\u001c;iS:<\u0007CA\u000e\"\u0013\t\u0011CDA\u0002B]f\u0004\"\u0001J\u0014\u000e\u0003\u0015R!A\n\u0003\u0002\u000bQL\b/Z:\n\u0005!*#\u0001B\"S_^\u00042AK\u00170\u001b\u0005Y#B\u0001\u0017\u0007\u0003\u001d\u0019w\u000eZ3hK:L!AL\u0016\u0003\u0011\r{W\u000e]5mKJ\u0004\"A\u0005\u0019\n\u0005E\u0012!!F$f]\u0016\u0014\u0018\r^3e\u0003\u001e<'/Z4bi&|gn\u001d\t\u0003gYj\u0011\u0001\u000e\u0006\u0003k\u0019\tA!\u001e;jY&\u0011q\u0007\u000e\u0002\b\u0019><w-\u001b8h\u0011!I\u0004A!A!\u0002\u0013Q\u0014aD4f]\u0006;wM]3hCRLwN\\:\u0011\u0005)Z\u0014B\u0001\u001f,\u0005u9UM\\3sCR,G-Q4he\u0016<\u0017\r^5p]N4UO\\2uS>t\u0007\u0002\u0003 \u0001\u0005\u0003\u0005\u000b\u0011B \u0002)\u0005<wM]3hCRLwN\\*uCR,G+\u001f9f!\t\u0001u)D\u0001B\u0015\t\u00115)A\u0005usB,W\u000f^5mg*\u0011A)R\u0001\u0005U\u00064\u0018M\u0003\u0002G\u0011\u0005\u0019\u0011\r]5\n\u0005!\u000b%a\u0003*poRK\b/Z%oM>D\u0001B\u0013\u0001\u0003\u0002\u0003\u0006IaS\u0001\u0013O\u0016tWM]1uKJ+GO]1di&|g\u000e\u0005\u0002\u001c\u0019&\u0011Q\n\b\u0002\b\u0005>|G.Z1o\u0011!y\u0005A!A!\u0002\u0013\u0001\u0016\u0001E7j]J+G/\u001a8uS>tG+[7f!\tY\u0012+\u0003\u0002S9\t!Aj\u001c8h\u0011!!\u0006A!A!\u0002\u0013\u0001\u0016\u0001E7bqJ+G/\u001a8uS>tG+[7f\u0011\u00151\u0006\u0001\"\u0001X\u0003\u0019a\u0014N\\5u}Q1\u0001,\u0017.\\9v\u00032A\u0005\u0001\u0016\u0011\u0015IT\u000b1\u0001;\u0011\u0015qT\u000b1\u0001@\u0011\u0015QU\u000b1\u0001L\u0011\u0015yU\u000b1\u0001Q\u0011\u0015!V\u000b1\u0001Q\u0011%y\u0006\u00011AA\u0002\u0013%\u0001-\u0001\u0005gk:\u001cG/[8o+\u0005y\u0003\"\u00032\u0001\u0001\u0004\u0005\r\u0011\"\u0003d\u000311WO\\2uS>tw\fJ3r)\t!w\r\u0005\u0002\u001cK&\u0011a\r\b\u0002\u0005+:LG\u000fC\u0004iC\u0006\u0005\t\u0019A\u0018\u0002\u0007a$\u0013\u0007\u0003\u0004k\u0001\u0001\u0006KaL\u0001\nMVt7\r^5p]\u0002B\u0011\u0002\u001c\u0001A\u0002\u0003\u0007I\u0011B7\u0002\r9,wOU8x+\u0005\u0019\u0003\"C8\u0001\u0001\u0004\u0005\r\u0011\"\u0003q\u0003)qWm\u001e*po~#S-\u001d\u000b\u0003IFDq\u0001\u001b8\u0002\u0002\u0003\u00071\u0005\u0003\u0004t\u0001\u0001\u0006KaI\u0001\b]\u0016<(k\\<!\u0011%)\b\u00011AA\u0002\u0013%Q.A\u0004qe\u00164(k\\<\t\u0013]\u0004\u0001\u0019!a\u0001\n\u0013A\u0018a\u00039sKZ\u0014vn^0%KF$\"\u0001Z=\t\u000f!4\u0018\u0011!a\u0001G!11\u0010\u0001Q!\n\r\n\u0001\u0002\u001d:fmJ{w\u000f\t\u0005\n{\u0002\u0001\r\u00111A\u0005\ny\f\u0001BZ5sgR\u0014vn^\u000b\u0002\u0017\"Y\u0011\u0011\u0001\u0001A\u0002\u0003\u0007I\u0011BA\u0002\u000311\u0017N]:u%><x\fJ3r)\r!\u0017Q\u0001\u0005\bQ~\f\t\u00111\u0001L\u0011\u001d\tI\u0001\u0001Q!\n-\u000b\u0011BZ5sgR\u0014vn\u001e\u0011\t\u0017\u00055\u0001\u00011AA\u0002\u0013%\u0011qB\u0001\u0006gR\fG/Z\u000b\u0003\u0003#\u0001b!a\u0005\u0002\u001c\u0005}QBAA\u000b\u0015\u0011\ti!a\u0006\u000b\u0007\u0005eQ)\u0001\u0004d_6lwN\\\u0005\u0005\u0003;\t)B\u0001\u0006WC2,Xm\u0015;bi\u0016\u0004B!!\t\u0002&5\u0011\u00111\u0005\u0006\u0003M!IA!a\n\u0002$\t\u0019!k\\<\t\u0017\u0005-\u0002\u00011AA\u0002\u0013%\u0011QF\u0001\ngR\fG/Z0%KF$2\u0001ZA\u0018\u0011%A\u0017\u0011FA\u0001\u0002\u0004\t\t\u0002\u0003\u0005\u00024\u0001\u0001\u000b\u0015BA\t\u0003\u0019\u0019H/\u0019;fA!Y\u0011q\u0007\u0001A\u0002\u0003\u0007I\u0011BA\u001d\u0003!\u0019g\u000e^*uCR,WCAA\u001e!\u0019\t\u0019\"a\u0007\u0002>A!\u0011qHA$\u001b\t\t\tE\u0003\u0003\u0002D\u0005\u0015\u0013\u0001\u00027b]\u001eT\u0011\u0001R\u0005\u0004%\u0006\u0005\u0003bCA&\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u001b\nAb\u00198u'R\fG/Z0%KF$2\u0001ZA(\u0011%A\u0017\u0011JA\u0001\u0002\u0004\tY\u0004\u0003\u0005\u0002T\u0001\u0001\u000b\u0015BA\u001e\u0003%\u0019g\u000e^*uCR,\u0007\u0005C\u0004\u0002X\u0001!\t%!\u0017\u0002\t=\u0004XM\u001c\u000b\u0004I\u0006m\u0003\u0002CA/\u0003+\u0002\r!a\u0018\u0002\r\r|gNZ5h!\u0011\t\t'a\u001a\u000e\u0005\u0005\r$bAA3\u0011\u0005i1m\u001c8gS\u001e,(/\u0019;j_:LA!!\u001b\u0002d\ti1i\u001c8gS\u001e,(/\u0019;j_:Dq!!\u001c\u0001\t\u0003\ny'\u0001\bqe>\u001cWm]:FY\u0016lWM\u001c;\u0015\u000f\u0011\f\t(!\u001e\u0002\u0012\"9\u00111OA6\u0001\u0004\u0019\u0013AB5oaV$8\t\u0003\u0005\u0002x\u0005-\u0004\u0019AA=\u0003\r\u0019G\u000f\u001f\t\u0005\u0003w\ni\tE\u0004\u0002~\u0005%UcI\u0012\u000e\u0005\u0005}$\u0002BAA\u0003\u0007\u000b\u0011BZ;oGRLwN\\:\u000b\u0007\u0019\u000b)IC\u0002\u0002\b\"\t\u0011b\u001d;sK\u0006l\u0017N\\4\n\t\u0005-\u0015q\u0010\u0002\u0015\u0017\u0016LX\r\u001a)s_\u000e,7o\u001d$v]\u000e$\u0018n\u001c8\n\t\u0005=\u0015\u0011\u0012\u0002\b\u0007>tG/\u001a=u\u0011!\t\u0019*a\u001bA\u0002\u0005U\u0015aA8viB)\u0011qSANG5\u0011\u0011\u0011\u0014\u0006\u0003k!IA!!(\u0002\u001a\nI1i\u001c7mK\u000e$xN\u001d\u0005\b\u0003C\u0003A\u0011IAR\u0003\u001dyg\u000eV5nKJ$r\u0001ZAS\u0003S\u000b\t\fC\u0004\u0002(\u0006}\u0005\u0019\u0001)\u0002\u0013QLW.Z:uC6\u0004\b\u0002CA<\u0003?\u0003\r!a+\u0011\t\u0005m\u0014QV\u0005\u0005\u0003_\u000bII\u0001\bP]RKW.\u001a:D_:$X\r\u001f;\t\u0011\u0005M\u0015q\u0014a\u0001\u0003+Cq!!.\u0001\t\u0003\n9,A\u0003dY>\u001cX\rF\u0001e\u0001")
public class GroupAggProcessFunction<K>
extends ProcessFunctionWithCleanupState<K, CRow, CRow>
implements Compiler<GeneratedAggregations>,
Logging {
    private final GeneratedAggregationsFunction genAggregations;
    private final RowTypeInfo aggregationStateType;
    private final boolean generateRetraction;
    private GeneratedAggregations function;
    private CRow newRow;
    private CRow prevRow;
    private boolean firstRow;
    private ValueState<Row> state;
    private ValueState<Long> cntState;
    private final transient Logger LOG;
    private volatile transient boolean bitmap$trans$0;

    private Logger LOG$lzycompute() {
        GroupAggProcessFunction groupAggProcessFunction = this;
        synchronized (groupAggProcessFunction) {
            if (!this.bitmap$trans$0) {
                this.LOG = Logging$class.LOG(this);
                this.bitmap$trans$0 = true;
            }
            return this.LOG;
        }
    }

    @Override
    public Logger LOG() {
        return this.bitmap$trans$0 ? this.LOG : this.LOG$lzycompute();
    }

    @Override
    public Class<GeneratedAggregations> compile(ClassLoader cl, String name, String code) throws CompileException {
        return Compiler$class.compile(this, cl, name, code);
    }

    private GeneratedAggregations function() {
        return this.function;
    }

    private void function_$eq(GeneratedAggregations x$1) {
        this.function = x$1;
    }

    private CRow newRow() {
        return this.newRow;
    }

    private void newRow_$eq(CRow x$1) {
        this.newRow = x$1;
    }

    private CRow prevRow() {
        return this.prevRow;
    }

    private void prevRow_$eq(CRow x$1) {
        this.prevRow = x$1;
    }

    private boolean firstRow() {
        return this.firstRow;
    }

    private void firstRow_$eq(boolean x$1) {
        this.firstRow = x$1;
    }

    private ValueState<Row> state() {
        return this.state;
    }

    private void state_$eq(ValueState<Row> x$1) {
        this.state = x$1;
    }

    private ValueState<Long> cntState() {
        return this.cntState;
    }

    private void cntState_$eq(ValueState<Long> x$1) {
        this.cntState = x$1;
    }

    public void open(Configuration config) {
        this.LOG().debug(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compiling AggregateHelper: ", ".name \\n\\n "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.genAggregations}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Code:\\n", ".code"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.genAggregations}))).toString());
        Class<GeneratedAggregations> clazz = this.compile(this.getRuntimeContext().getUserCodeClassLoader(), this.genAggregations.name(), this.genAggregations.code());
        this.LOG().debug("Instantiating AggregateHelper.");
        this.function_$eq(clazz.newInstance());
        this.function().open(this.getRuntimeContext());
        this.newRow_$eq(new CRow(this.function().createOutputRow(), true));
        this.prevRow_$eq(new CRow(this.function().createOutputRow(), false));
        ValueStateDescriptor stateDescriptor = new ValueStateDescriptor("GroupAggregateState", (TypeInformation)this.aggregationStateType);
        this.state_$eq((ValueState<Row>)this.getRuntimeContext().getState(stateDescriptor));
        ValueStateDescriptor inputCntDescriptor = new ValueStateDescriptor("GroupAggregateInputCounter", Types.LONG());
        this.cntState_$eq((ValueState<Long>)this.getRuntimeContext().getState(inputCntDescriptor));
        this.initCleanupTimeState("GroupAggregateCleanupTime");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void processElement(CRow inputC, KeyedProcessFunction.Context ctx, Collector<CRow> out) {
        long currentTime = ctx.timerService().currentProcessingTime();
        this.processCleanupTimer(ctx, currentTime);
        Row input = inputC.row();
        Row accumulators = (Row)this.state().value();
        Long inputCnt = (Long)this.cntState().value();
        if (accumulators == null) {
            if (!inputC.change()) return;
            this.firstRow_$eq(true);
            accumulators = this.function().createAccumulators();
        } else {
            this.firstRow_$eq(false);
        }
        if (inputCnt == null) {
            inputCnt = Predef$.MODULE$.long2Long(0L);
        }
        this.function().setForwardedFields(input, this.newRow().row());
        this.function().setForwardedFields(input, this.prevRow().row());
        this.function().setAggregationResults(accumulators, this.prevRow().row());
        if (inputC.change()) {
            inputCnt = Predef$.MODULE$.long2Long(Predef$.MODULE$.Long2long(inputCnt) + 1L);
            this.function().accumulate(accumulators, input);
            this.function().setAggregationResults(accumulators, this.newRow().row());
        } else {
            inputCnt = Predef$.MODULE$.long2Long(Predef$.MODULE$.Long2long(inputCnt) - 1L);
            this.function().retract(accumulators, input);
            this.function().setAggregationResults(accumulators, this.newRow().row());
        }
        if (BoxesRunTime.equalsNumObject((Number)inputCnt, (Object)BoxesRunTime.boxToInteger((int)0))) {
            out.collect((Object)this.prevRow());
            this.state().clear();
            this.cntState().clear();
            return;
        } else {
            this.state().update((Object)accumulators);
            this.cntState().update((Object)inputCnt);
            if (!this.firstRow()) {
                if (this.prevRow().row().equals((Object)this.newRow().row()) && !this.stateCleaningEnabled()) {
                    return;
                }
                if (this.generateRetraction) {
                    out.collect((Object)this.prevRow());
                }
            }
            out.collect((Object)this.newRow());
        }
    }

    public void onTimer(long timestamp, KeyedProcessFunction.OnTimerContext ctx, Collector<CRow> out) {
        if (this.stateCleaningEnabled()) {
            this.cleanupState((Seq<State>)Predef$.MODULE$.wrapRefArray((Object[])new State[]{this.state(), this.cntState()}));
            this.function().cleanup();
        }
    }

    public void close() {
        if (this.function() != null) {
            this.function().close();
        }
    }

    public GroupAggProcessFunction(GeneratedAggregationsFunction genAggregations, RowTypeInfo aggregationStateType, boolean generateRetraction, long minRetentionTime, long maxRetentionTime) {
        this.genAggregations = genAggregations;
        this.aggregationStateType = aggregationStateType;
        this.generateRetraction = generateRetraction;
        super(minRetentionTime, maxRetentionTime);
        Compiler$class.$init$(this);
        Logging$class.$init$(this);
    }
}

