/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.aggregate;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.ListTypeInfo;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.streaming.api.operators.TimestampedCollector;
import org.apache.flink.table.codegen.Compiler;
import org.apache.flink.table.codegen.Compiler$class;
import org.apache.flink.table.codegen.GeneratedAggregationsFunction;
import org.apache.flink.table.runtime.aggregate.GeneratedAggregations;
import org.apache.flink.table.runtime.aggregate.ProcessFunctionWithCleanupState;
import org.apache.flink.table.runtime.types.CRow;
import org.apache.flink.table.runtime.types.CRowTypeInfo;
import org.apache.flink.table.util.Logging;
import org.apache.flink.table.util.Logging$class;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.codehaus.commons.compiler.CompileException;
import org.slf4j.Logger;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005%f\u0001B\u0001\u0003\u0001=\u0011\u0001\u0004\u0015:pGRKW.\u001a\"pk:$W\r\u001a*b]\u001e,wJ^3s\u0015\t\u0019A!A\u0005bO\u001e\u0014XmZ1uK*\u0011QAB\u0001\beVtG/[7f\u0015\t9\u0001\"A\u0003uC\ndWM\u0003\u0002\n\u0015\u0005)a\r\\5oW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001)\"\u0001E\f\u0014\t\u0001\t\u0012F\r\t\u0006%M)2eI\u0007\u0002\u0005%\u0011AC\u0001\u0002 !J|7-Z:t\rVt7\r^5p]^KG\u000f[\"mK\u0006tW\u000f]*uCR,\u0007C\u0001\f\u0018\u0019\u0001!Q\u0001\u0007\u0001C\u0002e\u0011\u0011aS\t\u00035\u0001\u0002\"a\u0007\u0010\u000e\u0003qQ\u0011!H\u0001\u0006g\u000e\fG.Y\u0005\u0003?q\u0011qAT8uQ&tw\r\u0005\u0002\u001cC%\u0011!\u0005\b\u0002\u0004\u0003:L\bC\u0001\u0013(\u001b\u0005)#B\u0001\u0014\u0005\u0003\u0015!\u0018\u0010]3t\u0013\tASE\u0001\u0003D%><\bc\u0001\u0016._5\t1F\u0003\u0002-\r\u000591m\u001c3fO\u0016t\u0017B\u0001\u0018,\u0005!\u0019u.\u001c9jY\u0016\u0014\bC\u0001\n1\u0013\t\t$AA\u000bHK:,'/\u0019;fI\u0006;wM]3hCRLwN\\:\u0011\u0005M2T\"\u0001\u001b\u000b\u0005U2\u0011\u0001B;uS2L!a\u000e\u001b\u0003\u000f1{wmZ5oO\"A\u0011\b\u0001B\u0001B\u0003%!(A\bhK:\fum\u001a:fO\u0006$\u0018n\u001c8t!\tQ3(\u0003\u0002=W\tir)\u001a8fe\u0006$X\rZ!hOJ,w-\u0019;j_:\u001ch)\u001e8di&|g\u000e\u0003\u0005?\u0001\t\u0005\t\u0015!\u0003@\u0003U\u0001(/Z2fI&tw\rV5nK\n{WO\u001c3bef\u0004\"a\u0007!\n\u0005\u0005c\"\u0001\u0002'p]\u001eD\u0001b\u0011\u0001\u0003\u0002\u0003\u0006I\u0001R\u0001\u0013C\u001e<'/Z4bi\u0016\u001cH+\u001f9f\u0013:4w\u000e\u0005\u0002F\u00196\taI\u0003\u0002H\u0011\u0006IA/\u001f9fkRLGn\u001d\u0006\u0003\u0013*\u000bAA[1wC*\u00111\nC\u0001\u0004CBL\u0017BA'G\u0005-\u0011vn\u001e+za\u0016LeNZ8\t\u0011=\u0003!\u0011!Q\u0001\nA\u000b\u0011\"\u001b8qkR$\u0016\u0010]3\u0011\u0007E36%D\u0001S\u0015\t\u0019F+\u0001\u0005usB,\u0017N\u001c4p\u0015\t)&*\u0001\u0004d_6lwN\\\u0005\u0003/J\u0013q\u0002V=qK&sgm\u001c:nCRLwN\u001c\u0005\t3\u0002\u0011\t\u0011)A\u0005\u007f\u0005\u0001R.\u001b8SKR,g\u000e^5p]RKW.\u001a\u0005\t7\u0002\u0011\t\u0011)A\u0005\u007f\u0005\u0001R.\u0019=SKR,g\u000e^5p]RKW.\u001a\u0005\u0006;\u0002!\tAX\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000f}\u0003\u0017MY2eKB\u0019!\u0003A\u000b\t\u000beb\u0006\u0019\u0001\u001e\t\u000byb\u0006\u0019A \t\u000b\rc\u0006\u0019\u0001#\t\u000b=c\u0006\u0019\u0001)\t\u000bec\u0006\u0019A \t\u000bmc\u0006\u0019A \t\u0013\u001d\u0004\u0001\u0019!a\u0001\n\u0013A\u0017AB8viB,H/F\u0001$\u0011%Q\u0007\u00011AA\u0002\u0013%1.\u0001\u0006pkR\u0004X\u000f^0%KF$\"\u0001\\8\u0011\u0005mi\u0017B\u00018\u001d\u0005\u0011)f.\u001b;\t\u000fAL\u0017\u0011!a\u0001G\u0005\u0019\u0001\u0010J\u0019\t\rI\u0004\u0001\u0015)\u0003$\u0003\u001dyW\u000f\u001e9vi\u0002B\u0011\u0002\u001e\u0001A\u0002\u0003\u0007I\u0011B;\u0002!\u0005\u001c7-^7vY\u0006$xN]*uCR,W#\u0001<\u0011\u0007]TH0D\u0001y\u0015\tIH+A\u0003ti\u0006$X-\u0003\u0002|q\nQa+\u00197vKN#\u0018\r^3\u0011\u0005u|X\"\u0001@\u000b\u0005\u0019B\u0011bAA\u0001}\n\u0019!k\\<\t\u0017\u0005\u0015\u0001\u00011AA\u0002\u0013%\u0011qA\u0001\u0015C\u000e\u001cW/\\;mCR|'o\u0015;bi\u0016|F%Z9\u0015\u00071\fI\u0001\u0003\u0005q\u0003\u0007\t\t\u00111\u0001w\u0011\u001d\ti\u0001\u0001Q!\nY\f\u0011#Y2dk6,H.\u0019;peN#\u0018\r^3!\u0011-\t\t\u0002\u0001a\u0001\u0002\u0004%I!a\u0005\u0002\u0017I|w/T1q'R\fG/Z\u000b\u0003\u0003+\u0001ba^A\f\u007f\u0005m\u0011bAA\rq\nAQ*\u00199Ti\u0006$X\rE\u0003\u0002\u001e\u0005\rB0\u0004\u0002\u0002 )\u0019Q'!\t\u000b\u0003%KA!!\n\u0002 \t!A*[:u\u0011-\tI\u0003\u0001a\u0001\u0002\u0004%I!a\u000b\u0002\u001fI|w/T1q'R\fG/Z0%KF$2\u0001\\A\u0017\u0011%\u0001\u0018qEA\u0001\u0002\u0004\t)\u0002\u0003\u0005\u00022\u0001\u0001\u000b\u0015BA\u000b\u00031\u0011xn^'baN#\u0018\r^3!\u0011-\t)\u0004\u0001a\u0001\u0002\u0004%I!a\u000e\u0002\u0011\u0019,hn\u0019;j_:,\u0012a\f\u0005\f\u0003w\u0001\u0001\u0019!a\u0001\n\u0013\ti$\u0001\u0007gk:\u001cG/[8o?\u0012*\u0017\u000fF\u0002m\u0003\u007fA\u0001\u0002]A\u001d\u0003\u0003\u0005\ra\f\u0005\b\u0003\u0007\u0002\u0001\u0015)\u00030\u0003%1WO\\2uS>t\u0007\u0005C\u0004\u0002H\u0001!\t%!\u0013\u0002\t=\u0004XM\u001c\u000b\u0004Y\u0006-\u0003\u0002CA'\u0003\u000b\u0002\r!a\u0014\u0002\r\r|gNZ5h!\u0011\t\t&a\u0016\u000e\u0005\u0005M#bAA+\u0011\u0005i1m\u001c8gS\u001e,(/\u0019;j_:LA!!\u0017\u0002T\ti1i\u001c8gS\u001e,(/\u0019;j_:Dq!!\u0018\u0001\t\u0003\ny&\u0001\bqe>\u001cWm]:FY\u0016lWM\u001c;\u0015\u000f1\f\t'!\u001a\u0002\u0002\"9\u00111MA.\u0001\u0004\u0019\u0013!B5oaV$\b\u0002CA4\u00037\u0002\r!!\u001b\u0002\u0007\r$\b\u0010\u0005\u0003\u0002l\u0005u\u0004cBA7\u0003s*2eI\u0007\u0003\u0003_RA!!\u001d\u0002t\u0005Ia-\u001e8di&|gn\u001d\u0006\u0004\u0017\u0006U$bAA<\u0011\u0005I1\u000f\u001e:fC6LgnZ\u0005\u0005\u0003w\nyG\u0001\u000bLKf,G\r\u0015:pG\u0016\u001c8OR;oGRLwN\\\u0005\u0005\u0003\u007f\nIHA\u0004D_:$X\r\u001f;\t\u0011\u0005\r\u00151\fa\u0001\u0003\u000b\u000b1a\\;u!\u0015\t9)a#$\u001b\t\tII\u0003\u00026\u0011%!\u0011QRAE\u0005%\u0019u\u000e\u001c7fGR|'\u000fC\u0004\u0002\u0012\u0002!\t%a%\u0002\u000f=tG+[7feR9A.!&\u0002\u001a\u0006\u0005\u0006bBAL\u0003\u001f\u0003\raP\u0001\ni&lWm\u001d;b[BD\u0001\"a\u001a\u0002\u0010\u0002\u0007\u00111\u0014\t\u0005\u0003W\ni*\u0003\u0003\u0002 \u0006e$AD(o)&lWM]\"p]R,\u0007\u0010\u001e\u0005\t\u0003\u0007\u000by\t1\u0001\u0002\u0006\"9\u0011Q\u0015\u0001\u0005B\u0005\u001d\u0016!B2m_N,G#\u00017")
public class ProcTimeBoundedRangeOver<K>
extends ProcessFunctionWithCleanupState<K, CRow, CRow>
implements Compiler<GeneratedAggregations>,
Logging {
    private final GeneratedAggregationsFunction genAggregations;
    private final long precedingTimeBoundary;
    private final RowTypeInfo aggregatesTypeInfo;
    private final TypeInformation<CRow> inputType;
    private CRow output;
    private ValueState<Row> accumulatorState;
    private MapState<Object, List<Row>> rowMapState;
    private GeneratedAggregations function;
    private final transient Logger LOG;
    private volatile transient boolean bitmap$trans$0;

    private Logger LOG$lzycompute() {
        ProcTimeBoundedRangeOver procTimeBoundedRangeOver = this;
        synchronized (procTimeBoundedRangeOver) {
            if (!this.bitmap$trans$0) {
                this.LOG = Logging$class.LOG(this);
                this.bitmap$trans$0 = true;
            }
            return this.LOG;
        }
    }

    @Override
    public Logger LOG() {
        return this.bitmap$trans$0 ? this.LOG : this.LOG$lzycompute();
    }

    @Override
    public Class<GeneratedAggregations> compile(ClassLoader cl, String name, String code) throws CompileException {
        return Compiler$class.compile(this, cl, name, code);
    }

    private CRow output() {
        return this.output;
    }

    private void output_$eq(CRow x$1) {
        this.output = x$1;
    }

    private ValueState<Row> accumulatorState() {
        return this.accumulatorState;
    }

    private void accumulatorState_$eq(ValueState<Row> x$1) {
        this.accumulatorState = x$1;
    }

    private MapState<Object, List<Row>> rowMapState() {
        return this.rowMapState;
    }

    private void rowMapState_$eq(MapState<Object, List<Row>> x$1) {
        this.rowMapState = x$1;
    }

    private GeneratedAggregations function() {
        return this.function;
    }

    private void function_$eq(GeneratedAggregations x$1) {
        this.function = x$1;
    }

    public void open(Configuration config) {
        this.LOG().debug(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compiling AggregateHelper: ", " \\n\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.genAggregations.name()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Code:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.genAggregations.code()}))).toString());
        Class<GeneratedAggregations> clazz = this.compile(this.getRuntimeContext().getUserCodeClassLoader(), this.genAggregations.name(), this.genAggregations.code());
        this.LOG().debug("Instantiating AggregateHelper.");
        this.function_$eq(clazz.newInstance());
        this.function().open(this.getRuntimeContext());
        this.output_$eq(new CRow(this.function().createOutputRow(), true));
        ListTypeInfo rowListTypeInfo = new ListTypeInfo((TypeInformation)((CRowTypeInfo)this.inputType).rowType());
        MapStateDescriptor mapStateDescriptor = new MapStateDescriptor("rowmapstate", (TypeInformation)BasicTypeInfo.LONG_TYPE_INFO, (TypeInformation)rowListTypeInfo);
        this.rowMapState_$eq((MapState<Object, List<Row>>)this.getRuntimeContext().getMapState(mapStateDescriptor));
        ValueStateDescriptor stateDescriptor = new ValueStateDescriptor("overState", (TypeInformation)this.aggregatesTypeInfo);
        this.accumulatorState_$eq((ValueState<Row>)this.getRuntimeContext().getState(stateDescriptor));
        this.initCleanupTimeState("ProcTimeBoundedRangeOverCleanupTime");
    }

    public void processElement(CRow input, KeyedProcessFunction.Context ctx, Collector<CRow> out) {
        long currentTime = ctx.timerService().currentProcessingTime();
        this.processCleanupTimer(ctx, currentTime);
        ArrayList<Row> rowList = (ArrayList<Row>)this.rowMapState().get((Object)BoxesRunTime.boxToLong((long)currentTime));
        if (rowList == null) {
            rowList = new ArrayList<Row>();
            ctx.timerService().registerProcessingTimeTimer(currentTime + 1L);
        }
        rowList.add(input.row());
        this.rowMapState().put((Object)BoxesRunTime.boxToLong((long)currentTime), rowList);
    }

    public void onTimer(long timestamp, KeyedProcessFunction.OnTimerContext ctx, Collector<CRow> out) {
        int iElemenets;
        Long cleanupTime;
        if (this.stateCleaningEnabled() && (cleanupTime = (Long)this.cleanupTimeState().value()) != null && BoxesRunTime.equals((Object)BoxesRunTime.boxToLong((long)timestamp), (Object)cleanupTime)) {
            this.cleanupState((Seq<State>)Predef$.MODULE$.wrapRefArray((Object[])new State[]{this.rowMapState(), this.accumulatorState()}));
            this.function().cleanup();
            return;
        }
        ((TimestampedCollector)out).eraseTimestamp();
        long currentTime = timestamp - 1L;
        List currentElements = (List)this.rowMapState().get((Object)BoxesRunTime.boxToLong((long)currentTime));
        if (currentElements == null) {
            return;
        }
        Row accumulators = (Row)this.accumulatorState().value();
        if (accumulators == null) {
            accumulators = this.function().createAccumulators();
        }
        long limit = currentTime - this.precedingTimeBoundary;
        Iterator iter = this.rowMapState().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            long elementKey = BoxesRunTime.unboxToLong(entry.getKey());
            if (elementKey >= limit) continue;
            List elementsRemove = (List)entry.getValue();
            for (int iRemove = 0; iRemove < elementsRemove.size(); ++iRemove) {
                Row retractRow = (Row)elementsRemove.get(iRemove);
                this.function().retract(accumulators, retractRow);
            }
            iter.remove();
        }
        for (iElemenets = 0; iElemenets < currentElements.size(); ++iElemenets) {
            Row input = (Row)currentElements.get(iElemenets);
            this.function().accumulate(accumulators, input);
        }
        for (iElemenets = 0; iElemenets < currentElements.size(); ++iElemenets) {
            Row input = (Row)currentElements.get(iElemenets);
            this.function().setForwardedFields(input, this.output().row());
            this.function().setAggregationResults(accumulators, this.output().row());
            out.collect((Object)this.output());
        }
        this.accumulatorState().update((Object)accumulators);
    }

    public void close() {
        if (this.function() != null) {
            this.function().close();
        }
    }

    public ProcTimeBoundedRangeOver(GeneratedAggregationsFunction genAggregations, long precedingTimeBoundary, RowTypeInfo aggregatesTypeInfo, TypeInformation<CRow> inputType, long minRetentionTime, long maxRetentionTime) {
        this.genAggregations = genAggregations;
        this.precedingTimeBoundary = precedingTimeBoundary;
        this.aggregatesTypeInfo = aggregatesTypeInfo;
        this.inputType = inputType;
        super(minRetentionTime, maxRetentionTime);
        Compiler$class.$init$(this);
        Logging$class.$init$(this);
    }
}

